/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro;

import org.robovm.rt.bro.EnumConstantMissingException;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.MarshalsValue;

@Marshaler(value=AsSignedIntMarshaler.class)
public interface ValuedEnum {
    public long value();

    public static class AsMachineSizedUIntMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, @MachineSizedUInt long value, long flags) {
            return AsLongMarshaler.toObject(cls, value, flags);
        }

        @MarshalsValue
        @MachineSizedUInt
        public static long toNative(ValuedEnum v, long flags) {
            return v.value();
        }
    }

    public static class AsMachineSizedSIntMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, @MachineSizedSInt long value, long flags) {
            return AsLongMarshaler.toObject(cls, value, flags);
        }

        @MarshalsValue
        @MachineSizedSInt
        public static long toNative(ValuedEnum v, long flags) {
            return v.value();
        }
    }

    public static class AsLongMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, long value, long flags) {
            Enum[] values = Enum.getSharedConstants(cls);
            int length = values.length;
            if (length == 0) {
                throw new AssertionError((Object)"Enum class has no values!");
            }
            for (int i = 0; i < length; ++i) {
                Enum e = values[i];
                ValuedEnum v = (ValuedEnum)((Object)e);
                if (v.value() != value) continue;
                return v;
            }
            Class<?> enumType = values[0].getClass();
            throw new EnumConstantMissingException(value, "No constant with value " + value + " (0x" + Long.toHexString(value) + ") found in " + enumType.getName());
        }

        @MarshalsValue
        public static long toNative(ValuedEnum v, long flags) {
            return v.value();
        }
    }

    public static class AsUnsignedIntMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, int value, long flags) {
            return AsLongMarshaler.toObject(cls, (long)value & 0xFFFFFFFFL, flags);
        }

        @MarshalsValue
        public static int toNative(ValuedEnum v, long flags) {
            return (int)v.value();
        }
    }

    public static class AsSignedIntMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, int value, long flags) {
            return AsLongMarshaler.toObject(cls, value, flags);
        }

        @MarshalsValue
        public static int toNative(ValuedEnum v, long flags) {
            return (int)v.value();
        }
    }

    public static class AsUnsignedShortMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, short value, long flags) {
            return AsLongMarshaler.toObject(cls, (long)value & 0xFFFFL, flags);
        }

        @MarshalsValue
        public static short toNative(ValuedEnum v, long flags) {
            return (short)v.value();
        }
    }

    public static class AsSignedShortMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, short value, long flags) {
            return AsLongMarshaler.toObject(cls, value, flags);
        }

        @MarshalsValue
        public static short toNative(ValuedEnum v, long flags) {
            return (short)v.value();
        }
    }

    public static class AsUnsignedByteMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, byte value, long flags) {
            return AsLongMarshaler.toObject(cls, (long)value & 0xFFL, flags);
        }

        @MarshalsValue
        public static byte toNative(ValuedEnum v, long flags) {
            return (byte)v.value();
        }
    }

    public static class AsSignedByteMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> ValuedEnum toObject(Class<T> cls, byte value, long flags) {
            return AsLongMarshaler.toObject(cls, value, flags);
        }

        @MarshalsValue
        public static byte toNative(Enum<?> v, long flags) {
            return (byte)((ValuedEnum)((Object)v)).value();
        }
    }
}

