/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.HandshakeIODataStream;
import com.android.org.conscrypt.Message;
import com.android.org.conscrypt.util.EmptyArray;
import java.io.IOException;
import java.math.BigInteger;
import libcore.io.Streams;

public class ClientKeyExchange
extends Message {
    final byte[] exchange_keys;
    boolean isTLS;
    final boolean isRSA;

    public ClientKeyExchange(byte[] encrypted_pre_master_secret, boolean isTLS) {
        this.exchange_keys = encrypted_pre_master_secret;
        this.length = this.exchange_keys.length;
        if (isTLS) {
            this.length += 2;
        }
        this.isTLS = isTLS;
        this.isRSA = true;
    }

    public ClientKeyExchange(BigInteger dh_Yc) {
        byte[] bb = dh_Yc.toByteArray();
        if (bb[0] == 0) {
            this.exchange_keys = new byte[bb.length - 1];
            System.arraycopy((Object)bb, 1, (Object)this.exchange_keys, 0, this.exchange_keys.length);
        } else {
            this.exchange_keys = bb;
        }
        this.length = this.exchange_keys.length + 2;
        this.isRSA = false;
    }

    public ClientKeyExchange() {
        this.exchange_keys = EmptyArray.BYTE;
        this.length = 0;
        this.isRSA = false;
    }

    public ClientKeyExchange(HandshakeIODataStream in, int length, boolean isTLS, boolean isRSA) throws IOException {
        this.isTLS = isTLS;
        this.isRSA = isRSA;
        if (length == 0) {
            this.length = 0;
            this.exchange_keys = EmptyArray.BYTE;
        } else {
            int size;
            if (isRSA && !isTLS) {
                this.length = size = length;
            } else {
                size = in.readUint16();
                this.length = 2 + size;
            }
            this.exchange_keys = new byte[size];
            Streams.readFully(in, this.exchange_keys);
            if (this.length != length) {
                this.fatalAlert((byte)50, "DECODE ERROR: incorrect ClientKeyExchange");
            }
        }
    }

    @Override
    public void send(HandshakeIODataStream out) {
        if (this.exchange_keys.length != 0) {
            if (!this.isRSA || this.isTLS) {
                out.writeUint16(this.exchange_keys.length);
            }
            out.write(this.exchange_keys);
        }
    }

    @Override
    public int getType() {
        return 16;
    }

    public boolean isEmpty() {
        return this.exchange_keys.length == 0;
    }
}

