/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

class BootClassLoader
extends PathClassLoader {
    private static BootClassLoader instance;

    @FindBugsSuppressWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static synchronized BootClassLoader getInstance() {
        if (instance == null) {
            instance = new BootClassLoader();
        }
        return instance;
    }

    public BootClassLoader() {
        super(System.getProperty("java.boot.class.path", "."), null, true);
    }

    @Override
    public URL getResource(String resName) {
        return this.findResource(resName);
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(className);
        if (clazz == null) {
            clazz = this.findClass(className);
        }
        return clazz;
    }

    @Override
    public Enumeration<URL> getResources(String resName) throws IOException {
        return this.findResources(resName);
    }
}

