/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class Timestamp
extends Date {
    private static final long serialVersionUID = 2745179027874758501L;
    private int nanos;
    private static final String TIME_FORMAT_REGEX = "[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}.*";
    private static final String PADDING = "000000000";

    @Deprecated
    public Timestamp(int theYear, int theMonth, int theDate, int theHour, int theMinute, int theSecond, int theNano) throws IllegalArgumentException {
        super(theYear, theMonth, theDate, theHour, theMinute, theSecond);
        if (theNano < 0 || theNano > 999999999) {
            throw new IllegalArgumentException("ns out of range: " + theNano);
        }
        this.nanos = theNano;
    }

    public Timestamp(long theTime) {
        super(theTime);
        this.setTimeImpl(theTime);
    }

    public boolean after(Timestamp theTimestamp) {
        long compareTime;
        long thisTime = this.getTime();
        if (thisTime > (compareTime = theTimestamp.getTime())) {
            return true;
        }
        if (thisTime < compareTime) {
            return false;
        }
        return this.getNanos() > theTimestamp.getNanos();
    }

    public boolean before(Timestamp theTimestamp) {
        long compareTime;
        long thisTime = this.getTime();
        if (thisTime < (compareTime = theTimestamp.getTime())) {
            return true;
        }
        if (thisTime > compareTime) {
            return false;
        }
        return this.getNanos() < theTimestamp.getNanos();
    }

    @Override
    public int compareTo(Date theObject) throws ClassCastException {
        return this.compareTo((Timestamp)theObject);
    }

    @Override
    public int compareTo(Timestamp theTimestamp) {
        int result = super.compareTo(theTimestamp);
        if (result == 0) {
            int thatNano;
            int thisNano = this.getNanos();
            if (thisNano > (thatNano = theTimestamp.getNanos())) {
                return 1;
            }
            if (thisNano == thatNano) {
                return 0;
            }
            return -1;
        }
        return result;
    }

    @Override
    public boolean equals(Object theObject) {
        if (theObject instanceof Timestamp) {
            return this.equals((Timestamp)theObject);
        }
        return false;
    }

    public boolean equals(Timestamp theTimestamp) {
        if (theTimestamp == null) {
            return false;
        }
        return this.getTime() == theTimestamp.getTime() && this.getNanos() == theTimestamp.getNanos();
    }

    public int getNanos() {
        return this.nanos;
    }

    @Override
    public long getTime() {
        long theTime = super.getTime();
        return theTime += (long)(this.nanos / 1000000);
    }

    public void setNanos(int n) throws IllegalArgumentException {
        if (n < 0 || n > 999999999) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.nanos = n;
    }

    @Override
    public void setTime(long theTime) {
        this.setTimeImpl(theTime);
    }

    private void setTimeImpl(long theTime) {
        int milliseconds = (int)(theTime % 1000L);
        theTime -= (long)milliseconds;
        if (milliseconds < 0) {
            theTime -= 1000L;
            milliseconds = 1000 + milliseconds;
        }
        super.setTime(theTime);
        this.setNanos(milliseconds * 1000000);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(29);
        this.format(this.getYear() + 1900, 4, sb);
        sb.append('-');
        this.format(this.getMonth() + 1, 2, sb);
        sb.append('-');
        this.format(this.getDate(), 2, sb);
        sb.append(' ');
        this.format(this.getHours(), 2, sb);
        sb.append(':');
        this.format(this.getMinutes(), 2, sb);
        sb.append(':');
        this.format(this.getSeconds(), 2, sb);
        sb.append('.');
        if (this.nanos == 0) {
            sb.append('0');
        } else {
            this.format(this.nanos, 9, sb);
            while (sb.charAt(sb.length() - 1) == '0') {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    private void format(int date, int digits, StringBuilder sb) {
        String str = String.valueOf(date);
        if (digits - str.length() > 0) {
            sb.append(PADDING.substring(0, digits - str.length()));
        }
        sb.append(str);
    }

    public static Timestamp valueOf(String s) throws IllegalArgumentException {
        int theNanos;
        Date theDate;
        if (s == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (!Pattern.matches(TIME_FORMAT_REGEX, s = s.trim())) {
            throw Timestamp.badTimestampString(s);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        ParsePosition pp = new ParsePosition(0);
        try {
            theDate = df.parse(s, pp);
        }
        catch (Exception e) {
            throw Timestamp.badTimestampString(s);
        }
        if (theDate == null) {
            throw Timestamp.badTimestampString(s);
        }
        int position = pp.getIndex();
        int remaining = s.length() - position;
        if (remaining == 0) {
            theNanos = 0;
        } else {
            if (s.length() - position < ".n".length()) {
                throw Timestamp.badTimestampString(s);
            }
            if (s.length() - position > ".nnnnnnnnn".length()) {
                throw Timestamp.badTimestampString(s);
            }
            if (s.charAt(position) != '.') {
                throw new NumberFormatException("Bad input string format: expected '.' not '" + s.charAt(position) + "' in \"" + s + "\"");
            }
            int nanoLength = s.length() - position - 1;
            String theNanoString = s.substring(position + 1, position + 1 + nanoLength);
            theNanoString = theNanoString + PADDING;
            theNanoString = theNanoString.substring(0, 9);
            try {
                theNanos = Integer.parseInt(theNanoString);
            }
            catch (Exception e) {
                throw Timestamp.badTimestampString(s);
            }
        }
        if (theNanos < 0 || theNanos > 999999999) {
            throw Timestamp.badTimestampString(s);
        }
        Timestamp theTimestamp = new Timestamp(theDate.getTime());
        theTimestamp.setNanos(theNanos);
        return theTimestamp;
    }

    private static IllegalArgumentException badTimestampString(String s) {
        throw new IllegalArgumentException("Timestamp format must be yyyy-MM-dd HH:mm:ss.fffffffff; was '" + s + "'");
    }
}

