/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class AttributedString {
    String text;
    Map<AttributedCharacterIterator.Attribute, List<Range>> attributeMap;

    public AttributedString(AttributedCharacterIterator iterator) {
        if (iterator.getBeginIndex() > iterator.getEndIndex()) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = iterator.getBeginIndex(); i < iterator.getEndIndex(); ++i) {
            buffer.append(iterator.current());
            iterator.next();
        }
        this.text = buffer.toString();
        Set<AttributedCharacterIterator.Attribute> attributes = iterator.getAllAttributeKeys();
        if (attributes == null) {
            return;
        }
        this.attributeMap = new HashMap<AttributedCharacterIterator.Attribute, List<Range>>(attributes.size() * 4 / 3 + 1);
        for (AttributedCharacterIterator.Attribute attribute : attributes) {
            iterator.setIndex(0);
            while (iterator.current() != '\uffff') {
                int start = iterator.getRunStart(attribute);
                int limit = iterator.getRunLimit(attribute);
                Object value = iterator.getAttribute(attribute);
                if (value != null) {
                    this.addAttribute(attribute, value, start, limit);
                }
                iterator.setIndex(limit);
            }
        }
    }

    private AttributedString(AttributedCharacterIterator iterator, int start, int end, Set<AttributedCharacterIterator.Attribute> attributes) {
        if (start < iterator.getBeginIndex() || end > iterator.getEndIndex() || start > end) {
            throw new IllegalArgumentException();
        }
        if (attributes == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        iterator.setIndex(start);
        while (iterator.getIndex() < end) {
            buffer.append(iterator.current());
            iterator.next();
        }
        this.text = buffer.toString();
        this.attributeMap = new HashMap<AttributedCharacterIterator.Attribute, List<Range>>(attributes.size() * 4 / 3 + 1);
        for (AttributedCharacterIterator.Attribute attribute : attributes) {
            iterator.setIndex(start);
            while (iterator.getIndex() < end) {
                Object value = iterator.getAttribute(attribute);
                int runStart = iterator.getRunStart(attribute);
                int limit = iterator.getRunLimit(attribute);
                if (value instanceof Annotation && runStart >= start && limit <= end || value != null && !(value instanceof Annotation)) {
                    this.addAttribute(attribute, value, (runStart < start ? start : runStart) - start, (limit > end ? end : limit) - start);
                }
                iterator.setIndex(limit);
            }
        }
    }

    public AttributedString(AttributedCharacterIterator iterator, int start, int end) {
        this(iterator, start, end, iterator.getAllAttributeKeys());
    }

    public AttributedString(AttributedCharacterIterator iterator, int start, int end, AttributedCharacterIterator.Attribute[] attributes) {
        this(iterator, start, end, attributes == null ? new HashSet<AttributedCharacterIterator.Attribute>() : new HashSet<AttributedCharacterIterator.Attribute>(Arrays.asList(attributes)));
    }

    public AttributedString(String value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        this.text = value;
        this.attributeMap = new HashMap<AttributedCharacterIterator.Attribute, List<Range>>(11);
    }

    public AttributedString(String value, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (value.length() == 0 && !attributes.isEmpty()) {
            throw new IllegalArgumentException("Cannot add attributes to empty string");
        }
        this.text = value;
        this.attributeMap = new HashMap<AttributedCharacterIterator.Attribute, List<Range>>(attributes.size() * 4 / 3 + 1);
        for (Map.Entry<AttributedCharacterIterator.Attribute, ?> entry : attributes.entrySet()) {
            ArrayList<Range> ranges = new ArrayList<Range>(1);
            ranges.add(new Range(0, this.text.length(), entry.getValue()));
            this.attributeMap.put(entry.getKey(), ranges);
        }
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value) {
        if (attribute == null) {
            throw new NullPointerException("attribute == null");
        }
        if (this.text.isEmpty()) {
            throw new IllegalArgumentException("text is empty");
        }
        List<Range> ranges = this.attributeMap.get(attribute);
        if (ranges == null) {
            ranges = new ArrayList<Range>(1);
            this.attributeMap.put(attribute, ranges);
        } else {
            ranges.clear();
        }
        ranges.add(new Range(0, this.text.length(), value));
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value, int start, int end) {
        if (attribute == null) {
            throw new NullPointerException("attribute == null");
        }
        if (start < 0 || end > this.text.length() || start >= end) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            return;
        }
        List<Range> ranges = this.attributeMap.get(attribute);
        if (ranges == null) {
            ranges = new ArrayList<Range>(1);
            ranges.add(new Range(start, end, value));
            this.attributeMap.put(attribute, ranges);
            return;
        }
        ListIterator<Range> it = ranges.listIterator();
        while (it.hasNext()) {
            Range range = it.next();
            if (end <= range.start) {
                it.previous();
                break;
            }
            if (start >= range.end && (start != range.end || !value.equals(range.value))) continue;
            Range r1 = null;
            it.remove();
            r1 = new Range(range.start, start, range.value);
            Range r3 = new Range(end, range.end, range.value);
            while (end > range.end && it.hasNext()) {
                range = it.next();
                if (end <= range.end) {
                    if (end <= range.start && (end != range.start || !value.equals(range.value))) continue;
                    it.remove();
                    r3 = new Range(end, range.end, range.value);
                    break;
                }
                it.remove();
            }
            if (value.equals(r1.value)) {
                if (value.equals(r3.value)) {
                    it.add(new Range(r1.start < start ? r1.start : start, r3.end > end ? r3.end : end, r1.value));
                } else {
                    it.add(new Range(r1.start < start ? r1.start : start, end, r1.value));
                    if (r3.start < r3.end) {
                        it.add(r3);
                    }
                }
            } else if (value.equals(r3.value)) {
                if (r1.start < r1.end) {
                    it.add(r1);
                }
                it.add(new Range(start, r3.end > end ? r3.end : end, r3.value));
            } else {
                if (r1.start < r1.end) {
                    it.add(r1);
                }
                it.add(new Range(start, end, value));
                if (r3.start < r3.end) {
                    it.add(r3);
                }
            }
            return;
        }
        it.add(new Range(start, end, value));
    }

    public void addAttributes(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes, int start, int end) {
        for (Map.Entry<AttributedCharacterIterator.Attribute, ?> entry : attributes.entrySet()) {
            this.addAttribute(entry.getKey(), entry.getValue(), start, end);
        }
    }

    public AttributedCharacterIterator getIterator() {
        return new AttributedIterator(this);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes) {
        return new AttributedIterator(this, attributes, 0, this.text.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes, int start, int end) {
        return new AttributedIterator(this, attributes, start, end);
    }

    static class Range {
        int start;
        int end;
        Object value;

        Range(int s, int e, Object v) {
            this.start = s;
            this.end = e;
            this.value = v;
        }
    }

    static class AttributedIterator
    implements AttributedCharacterIterator {
        private int begin;
        private int end;
        private int offset;
        private AttributedString attrString;
        private HashSet<AttributedCharacterIterator.Attribute> attributesAllowed;

        AttributedIterator(AttributedString attrString) {
            this.attrString = attrString;
            this.begin = 0;
            this.end = attrString.text.length();
            this.offset = 0;
        }

        AttributedIterator(AttributedString attrString, AttributedCharacterIterator.Attribute[] attributes, int begin, int end) {
            if (begin < 0 || end > attrString.text.length() || begin > end) {
                throw new IllegalArgumentException();
            }
            this.begin = begin;
            this.end = end;
            this.offset = begin;
            this.attrString = attrString;
            if (attributes != null) {
                HashSet<AttributedCharacterIterator.Attribute> set = new HashSet<AttributedCharacterIterator.Attribute>(attributes.length * 4 / 3 + 1);
                int i = attributes.length;
                while (--i >= 0) {
                    set.add(attributes[i]);
                }
                this.attributesAllowed = set;
            }
        }

        @Override
        public Object clone() {
            try {
                AttributedIterator clone = (AttributedIterator)super.clone();
                if (this.attributesAllowed != null) {
                    clone.attributesAllowed = (HashSet)this.attributesAllowed.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public char current() {
            if (this.offset == this.end) {
                return '\uffff';
            }
            return this.attrString.text.charAt(this.offset);
        }

        @Override
        public char first() {
            if (this.begin == this.end) {
                return '\uffff';
            }
            this.offset = this.begin;
            return this.attrString.text.charAt(this.offset);
        }

        @Override
        public int getBeginIndex() {
            return this.begin;
        }

        @Override
        public int getEndIndex() {
            return this.end;
        }

        @Override
        public int getIndex() {
            return this.offset;
        }

        private boolean inRange(Range range) {
            if (!(range.value instanceof Annotation)) {
                return true;
            }
            return range.start >= this.begin && range.start < this.end && range.end > this.begin && range.end <= this.end;
        }

        private boolean inRange(List<Range> ranges) {
            for (Range range : ranges) {
                if (range.start >= this.begin && range.start < this.end) {
                    return !(range.value instanceof Annotation) || range.end > this.begin && range.end <= this.end;
                }
                if (range.end <= this.begin || range.end > this.end) continue;
                return !(range.value instanceof Annotation) || range.start >= this.begin && range.start < this.end;
            }
            return false;
        }

        @Override
        public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            if (this.begin == 0 && this.end == this.attrString.text.length() && this.attributesAllowed == null) {
                return this.attrString.attributeMap.keySet();
            }
            HashSet<AttributedCharacterIterator.Attribute> result = new HashSet<AttributedCharacterIterator.Attribute>(this.attrString.attributeMap.size() * 4 / 3 + 1);
            for (Map.Entry<AttributedCharacterIterator.Attribute, List<Range>> entry : this.attrString.attributeMap.entrySet()) {
                List<Range> ranges;
                if (this.attributesAllowed != null && !this.attributesAllowed.contains(entry.getKey()) || !this.inRange(ranges = entry.getValue())) continue;
                result.add(entry.getKey());
            }
            return result;
        }

        private Object currentValue(List<Range> ranges) {
            for (Range range : ranges) {
                if (this.offset < range.start || this.offset >= range.end) continue;
                return this.inRange(range) ? range.value : null;
            }
            return null;
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return null;
            }
            ArrayList ranges = (ArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return null;
            }
            return this.currentValue(ranges);
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            HashMap<AttributedCharacterIterator.Attribute, Object> result = new HashMap<AttributedCharacterIterator.Attribute, Object>(this.attrString.attributeMap.size() * 4 / 3 + 1);
            for (Map.Entry<AttributedCharacterIterator.Attribute, List<Range>> entry : this.attrString.attributeMap.entrySet()) {
                Object value;
                if (this.attributesAllowed != null && !this.attributesAllowed.contains(entry.getKey()) || (value = this.currentValue(entry.getValue())) == null) continue;
                result.put(entry.getKey(), value);
            }
            return result;
        }

        @Override
        public int getRunLimit() {
            return this.getRunLimit(this.getAllAttributeKeys());
        }

        private int runLimit(List<Range> ranges) {
            int result = this.end;
            ListIterator<Range> it = ranges.listIterator(ranges.size());
            while (it.hasPrevious()) {
                Range range = it.previous();
                if (range.end <= this.begin) break;
                if (this.offset >= range.start && this.offset < range.end) {
                    return this.inRange(range) ? range.end : result;
                }
                if (this.offset >= range.end) break;
                result = range.start;
            }
            return result;
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return this.end;
            }
            ArrayList ranges = (ArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return this.end;
            }
            return this.runLimit(ranges);
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            int limit = this.end;
            for (AttributedCharacterIterator.Attribute attribute : attributes) {
                int newLimit = this.getRunLimit(attribute);
                if (newLimit >= limit) continue;
                limit = newLimit;
            }
            return limit;
        }

        @Override
        public int getRunStart() {
            return this.getRunStart(this.getAllAttributeKeys());
        }

        private int runStart(List<Range> ranges) {
            int result = this.begin;
            for (Range range : ranges) {
                if (range.start >= this.end) break;
                if (this.offset >= range.start && this.offset < range.end) {
                    return this.inRange(range) ? range.start : result;
                }
                if (this.offset < range.start) break;
                result = range.end;
            }
            return result;
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return this.begin;
            }
            ArrayList ranges = (ArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return this.begin;
            }
            return this.runStart(ranges);
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            int start = this.begin;
            for (AttributedCharacterIterator.Attribute attribute : attributes) {
                int newStart = this.getRunStart(attribute);
                if (newStart <= start) continue;
                start = newStart;
            }
            return start;
        }

        @Override
        public char last() {
            if (this.begin == this.end) {
                return '\uffff';
            }
            this.offset = this.end - 1;
            return this.attrString.text.charAt(this.offset);
        }

        @Override
        public char next() {
            if (this.offset >= this.end - 1) {
                this.offset = this.end;
                return '\uffff';
            }
            return this.attrString.text.charAt(++this.offset);
        }

        @Override
        public char previous() {
            if (this.offset == this.begin) {
                return '\uffff';
            }
            return this.attrString.text.charAt(--this.offset);
        }

        @Override
        public char setIndex(int location) {
            if (location < this.begin || location > this.end) {
                throw new IllegalArgumentException();
            }
            this.offset = location;
            if (this.offset == this.end) {
                return '\uffff';
            }
            return this.attrString.text.charAt(this.offset);
        }
    }
}

