/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formattable;
import java.util.FormatterClosedException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;
import libcore.icu.LocaleData;
import libcore.icu.NativeDecimalFormat;
import libcore.io.IoUtils;

public final class Formatter
implements Closeable,
Flushable {
    private static final char[] ZEROS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
    private Appendable out;
    private Locale locale;
    private Object arg;
    private boolean closed = false;
    private FormatToken formatToken;
    private IOException lastIOException;
    private LocaleData localeData;
    private static final ThreadLocal<CachedDecimalFormat> cachedDecimalFormat = new ThreadLocal<CachedDecimalFormat>(){

        @Override
        protected CachedDecimalFormat initialValue() {
            return new CachedDecimalFormat();
        }
    };

    private NativeDecimalFormat getDecimalFormat(String pattern) {
        return cachedDecimalFormat.get().update(this.localeData, pattern);
    }

    public Formatter() {
        this(new StringBuilder(), Locale.getDefault());
    }

    public Formatter(Appendable a) {
        this(a, Locale.getDefault());
    }

    public Formatter(Locale l) {
        this(new StringBuilder(), l);
    }

    public Formatter(Appendable a, Locale l) {
        this.out = a == null ? new StringBuilder() : a;
        this.locale = l;
    }

    public Formatter(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public Formatter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), csn);
    }

    public Formatter(String fileName, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), csn, l);
    }

    public Formatter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public Formatter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, csn, Locale.getDefault());
    }

    public Formatter(File file, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, csn));
        }
        catch (RuntimeException e) {
            IoUtils.closeQuietly(fout);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            IoUtils.closeQuietly(fout);
            throw e;
        }
        this.locale = l;
    }

    public Formatter(OutputStream os) {
        this.out = new BufferedWriter(new OutputStreamWriter(os, Charset.defaultCharset()));
        this.locale = Locale.getDefault();
    }

    public Formatter(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(os, csn, Locale.getDefault());
    }

    public Formatter(OutputStream os, String csn, Locale l) throws UnsupportedEncodingException {
        this.out = new BufferedWriter(new OutputStreamWriter(os, csn));
        this.locale = l;
    }

    public Formatter(PrintStream ps) {
        if (ps == null) {
            throw new NullPointerException("ps == null");
        }
        this.out = ps;
        this.locale = Locale.getDefault();
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
    }

    public Locale locale() {
        this.checkNotClosed();
        return this.locale;
    }

    public Appendable out() {
        this.checkNotClosed();
        return this.out;
    }

    public String toString() {
        this.checkNotClosed();
        return this.out.toString();
    }

    @Override
    public void flush() {
        this.checkNotClosed();
        if (this.out instanceof Flushable) {
            try {
                ((Flushable)((Object)this.out)).flush();
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.out instanceof Closeable) {
                    ((Closeable)((Object)this.out)).close();
                }
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        }
    }

    public IOException ioException() {
        return this.lastIOException;
    }

    public Formatter format(String format, Object ... args) {
        return this.format(this.locale, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Formatter format(Locale l, String format, Object ... args) {
        Locale originalLocale = this.locale;
        try {
            this.locale = l == null ? Locale.US : l;
            this.localeData = LocaleData.get(this.locale);
            this.doFormat(format, args);
        }
        finally {
            this.locale = originalLocale;
        }
        return this;
    }

    private void doFormat(String format, Object ... args) {
        this.checkNotClosed();
        FormatSpecifierParser fsp = new FormatSpecifierParser(format);
        int currentObjectIndex = 0;
        Object lastArgument = null;
        boolean hasLastArgumentSet = false;
        int length = format.length();
        int i = 0;
        while (i < length) {
            CharSequence substitution;
            int plainTextEnd;
            int plainTextStart = i;
            int nextPercent = format.indexOf(37, i);
            int n = plainTextEnd = nextPercent == -1 ? length : nextPercent;
            if (plainTextEnd > plainTextStart) {
                this.outputCharSequence(format, plainTextStart, plainTextEnd);
            }
            if ((i = plainTextEnd) >= length) continue;
            FormatToken token = fsp.parseFormatToken(i + 1);
            Object argument = null;
            if (token.requireArgument()) {
                int index = token.getArgIndex() == -1 ? currentObjectIndex++ : token.getArgIndex();
                lastArgument = argument = this.getArgument(args, index, fsp, lastArgument, hasLastArgumentSet);
                hasLastArgumentSet = true;
            }
            if ((substitution = this.transform(token, argument)) != null) {
                this.outputCharSequence(substitution, 0, substitution.length());
            }
            i = fsp.i;
        }
    }

    private void outputCharSequence(CharSequence cs, int start, int end) {
        try {
            this.out.append(cs, start, end);
        }
        catch (IOException e) {
            this.lastIOException = e;
        }
    }

    private Object getArgument(Object[] args, int index, FormatSpecifierParser fsp, Object lastArgument, boolean hasLastArgumentSet) {
        if (index == -2 && !hasLastArgumentSet) {
            throw new MissingFormatArgumentException("<");
        }
        if (args == null) {
            return null;
        }
        if (index >= args.length) {
            throw new MissingFormatArgumentException(fsp.getFormatSpecifierText());
        }
        if (index == -2) {
            return lastArgument;
        }
        return args[index];
    }

    private CharSequence transform(FormatToken token, Object argument) {
        CharSequence result;
        this.formatToken = token;
        this.arg = argument;
        if (token.isDefault()) {
            switch (token.getConversionType()) {
                case 's': {
                    if (this.arg == null) {
                        return "null";
                    }
                    if (this.arg instanceof Formattable) break;
                    return this.arg.toString();
                }
                case 'd': {
                    boolean needLocalizedDigits;
                    boolean bl = needLocalizedDigits = this.localeData.zeroDigit != '0';
                    if (this.out instanceof StringBuilder && !needLocalizedDigits) {
                        if (this.arg instanceof Integer || this.arg instanceof Short || this.arg instanceof Byte) {
                            IntegralToString.appendInt((StringBuilder)this.out, ((Number)this.arg).intValue());
                            return null;
                        }
                        if (this.arg instanceof Long) {
                            IntegralToString.appendLong((StringBuilder)this.out, (Long)this.arg);
                            return null;
                        }
                    }
                    if (!(this.arg instanceof Integer) && !(this.arg instanceof Long) && !(this.arg instanceof Short) && !(this.arg instanceof Byte)) break;
                    String result2 = this.arg.toString();
                    return needLocalizedDigits ? this.localizeDigits(result2) : result2;
                }
            }
        }
        this.formatToken.checkFlags(this.arg);
        switch (token.getConversionType()) {
            case 'B': 
            case 'b': {
                result = this.transformFromBoolean();
                break;
            }
            case 'H': 
            case 'h': {
                result = this.transformFromHashCode();
                break;
            }
            case 'S': 
            case 's': {
                result = this.transformFromString();
                break;
            }
            case 'C': 
            case 'c': {
                result = this.transformFromCharacter();
                break;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                if (this.arg == null || this.arg instanceof BigInteger) {
                    result = this.transformFromBigInteger();
                    break;
                }
                result = this.transformFromInteger();
                break;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                result = this.transformFromFloat();
                break;
            }
            case '%': {
                result = this.transformFromPercent();
                break;
            }
            case 'n': {
                result = System.lineSeparator();
                break;
            }
            case 'T': 
            case 't': {
                result = this.transformFromDateTime();
                break;
            }
            default: {
                throw token.unknownFormatConversionException();
            }
        }
        if (Character.isUpperCase(token.getConversionType()) && result != null) {
            result = result.toString().toUpperCase(this.locale);
        }
        return result;
    }

    private IllegalFormatConversionException badArgumentType() {
        throw new IllegalFormatConversionException(this.formatToken.getConversionType(), this.arg.getClass());
    }

    private CharSequence localizeDigits(CharSequence s) {
        int length = s.length();
        int offsetToLocalizedDigits = this.localeData.zeroDigit - 48;
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') {
                ch = (char)(ch + offsetToLocalizedDigits);
            }
            result.append(ch);
        }
        return result;
    }

    private CharSequence insertGrouping(CharSequence s) {
        int headLength;
        StringBuilder result = new StringBuilder(s.length() + s.length() / 3);
        int digitsLength = s.length();
        int i = 0;
        if (s.charAt(0) == '-') {
            --digitsLength;
            ++i;
            result.append('-');
        }
        if ((headLength = digitsLength % 3) == 0) {
            headLength = 3;
        }
        result.append(s, i, i + headLength);
        i += headLength;
        while (i < s.length()) {
            result.append(this.localeData.groupingSeparator);
            result.append(s, i, i + 3);
            i += 3;
        }
        return result;
    }

    private CharSequence transformFromBoolean() {
        String result = this.arg instanceof Boolean ? this.arg.toString() : (this.arg == null ? "false" : "true");
        return this.padding(result, 0);
    }

    private CharSequence transformFromHashCode() {
        String result = this.arg == null ? "null" : Integer.toHexString(this.arg.hashCode());
        return this.padding(result, 0);
    }

    private CharSequence transformFromString() {
        if (this.arg instanceof Formattable) {
            int flags = 0;
            if (this.formatToken.flagMinus) {
                flags |= 1;
            }
            if (this.formatToken.flagSharp) {
                flags |= 4;
            }
            if (Character.isUpperCase(this.formatToken.getConversionType())) {
                flags |= 2;
            }
            ((Formattable)this.arg).formatTo(this, flags, this.formatToken.getWidth(), this.formatToken.getPrecision());
            return null;
        }
        String result = this.arg != null ? this.arg.toString() : "null";
        return this.padding(result, 0);
    }

    private CharSequence transformFromCharacter() {
        if (this.arg == null) {
            return this.padding("null", 0);
        }
        if (this.arg instanceof Character) {
            return this.padding(String.valueOf(this.arg), 0);
        }
        if (this.arg instanceof Byte || this.arg instanceof Short || this.arg instanceof Integer) {
            int codePoint = ((Number)this.arg).intValue();
            if (!Character.isValidCodePoint(codePoint)) {
                throw new IllegalFormatCodePointException(codePoint);
            }
            String result = codePoint < 65536 ? String.valueOf((char)codePoint) : String.valueOf(Character.toChars(codePoint));
            return this.padding(result, 0);
        }
        throw this.badArgumentType();
    }

    private CharSequence transformFromPercent() {
        return this.padding("%", 0);
    }

    private CharSequence padding(CharSequence source, int startIndex) {
        int start = startIndex;
        int width = this.formatToken.getWidth();
        int precision = this.formatToken.getPrecision();
        int length = source.length();
        if (precision >= 0) {
            length = Math.min(length, precision);
            if (source instanceof StringBuilder) {
                ((StringBuilder)source).setLength(length);
            } else {
                source = source.subSequence(0, length);
            }
        }
        if (width > 0) {
            width = Math.max(source.length(), width);
        }
        if (length >= width) {
            return source;
        }
        char paddingChar = ' ';
        if (this.formatToken.flagZero) {
            paddingChar = this.formatToken.getConversionType() == 'd' ? (char)this.localeData.zeroDigit : (char)'0';
        } else {
            start = 0;
        }
        char[] paddingChars = new char[width - length];
        Arrays.fill(paddingChars, paddingChar);
        boolean paddingRight = this.formatToken.flagMinus;
        StringBuilder result = this.toStringBuilder(source);
        if (paddingRight) {
            result.append(paddingChars);
        } else {
            result.insert(start, paddingChars);
        }
        return result;
    }

    private StringBuilder toStringBuilder(CharSequence cs) {
        return cs instanceof StringBuilder ? (StringBuilder)cs : new StringBuilder(cs);
    }

    private StringBuilder wrapParentheses(StringBuilder result) {
        result.setCharAt(0, '(');
        if (this.formatToken.flagZero) {
            this.formatToken.setWidth(this.formatToken.getWidth() - 1);
            result = (StringBuilder)this.padding(result, 1);
            result.append(')');
        } else {
            result.append(')');
            result = (StringBuilder)this.padding(result, 0);
        }
        return result;
    }

    private CharSequence transformFromInteger() {
        long value;
        int startIndex = 0;
        StringBuilder result = new StringBuilder();
        char currentConversionType = this.formatToken.getConversionType();
        if (this.arg instanceof Long) {
            value = (Long)this.arg;
        } else if (this.arg instanceof Integer) {
            value = ((Integer)this.arg).longValue();
        } else if (this.arg instanceof Short) {
            value = ((Short)this.arg).longValue();
        } else if (this.arg instanceof Byte) {
            value = ((Byte)this.arg).longValue();
        } else {
            throw this.badArgumentType();
        }
        if (this.formatToken.flagSharp) {
            if (currentConversionType == 'o') {
                result.append("0");
                ++startIndex;
            } else {
                result.append("0x");
                startIndex += 2;
            }
        }
        if (currentConversionType == 'd') {
            CharSequence digits = Long.toString(value);
            if (this.formatToken.flagComma) {
                digits = this.insertGrouping(digits);
            }
            if (this.localeData.zeroDigit != '0') {
                digits = this.localizeDigits(digits);
            }
            result.append(digits);
            if (value < 0L) {
                if (this.formatToken.flagParenthesis) {
                    return this.wrapParentheses(result);
                }
                if (this.formatToken.flagZero) {
                    ++startIndex;
                }
            } else if (this.formatToken.flagPlus) {
                result.insert(0, '+');
                ++startIndex;
            } else if (this.formatToken.flagSpace) {
                result.insert(0, ' ');
                ++startIndex;
            }
        } else {
            if (this.arg instanceof Byte) {
                value &= 0xFFL;
            } else if (this.arg instanceof Short) {
                value &= 0xFFFFL;
            } else if (this.arg instanceof Integer) {
                value &= 0xFFFFFFFFL;
            }
            if (currentConversionType == 'o') {
                result.append(Long.toOctalString(value));
            } else {
                result.append(Long.toHexString(value));
            }
        }
        return this.padding(result, startIndex);
    }

    private CharSequence transformFromNull() {
        this.formatToken.flagZero = false;
        return this.padding("null", 0);
    }

    private CharSequence transformFromBigInteger() {
        boolean isNegative;
        int startIndex = 0;
        StringBuilder result = new StringBuilder();
        BigInteger bigInt = (BigInteger)this.arg;
        char currentConversionType = this.formatToken.getConversionType();
        if (bigInt == null) {
            return this.transformFromNull();
        }
        boolean bl = isNegative = bigInt.compareTo(BigInteger.ZERO) < 0;
        if (currentConversionType == 'd') {
            CharSequence digits = bigInt.toString(10);
            if (this.formatToken.flagComma) {
                digits = this.insertGrouping(digits);
            }
            result.append(digits);
        } else if (currentConversionType == 'o') {
            result.append(bigInt.toString(8));
        } else {
            result.append(bigInt.toString(16));
        }
        if (this.formatToken.flagSharp) {
            int n = startIndex = isNegative ? 1 : 0;
            if (currentConversionType == 'o') {
                result.insert(startIndex, "0");
                ++startIndex;
            } else if (currentConversionType == 'x' || currentConversionType == 'X') {
                result.insert(startIndex, "0x");
                startIndex += 2;
            }
        }
        if (!isNegative) {
            if (this.formatToken.flagPlus) {
                result.insert(0, '+');
                ++startIndex;
            }
            if (this.formatToken.flagSpace) {
                result.insert(0, ' ');
                ++startIndex;
            }
        }
        if (isNegative && this.formatToken.flagParenthesis) {
            return this.wrapParentheses(result);
        }
        if (isNegative && this.formatToken.flagZero) {
            ++startIndex;
        }
        return this.padding(result, startIndex);
    }

    private CharSequence transformFromDateTime() {
        Calendar calendar;
        if (this.arg == null) {
            return this.transformFromNull();
        }
        if (this.arg instanceof Calendar) {
            calendar = (Calendar)this.arg;
        } else {
            Date date = null;
            if (this.arg instanceof Long) {
                date = new Date((Long)this.arg);
            } else if (this.arg instanceof Date) {
                date = (Date)this.arg;
            } else {
                throw this.badArgumentType();
            }
            calendar = Calendar.getInstance(this.locale);
            calendar.setTime(date);
        }
        StringBuilder result = new StringBuilder();
        if (!this.appendT(result, this.formatToken.getDateSuffix(), calendar)) {
            throw this.formatToken.unknownFormatConversionException();
        }
        return this.padding(result, 0);
    }

    private boolean appendT(StringBuilder result, char conversion, Calendar calendar) {
        switch (conversion) {
            case 'A': {
                result.append(this.localeData.longWeekdayNames[calendar.get(7)]);
                return true;
            }
            case 'a': {
                result.append(this.localeData.shortWeekdayNames[calendar.get(7)]);
                return true;
            }
            case 'B': {
                result.append(this.localeData.longMonthNames[calendar.get(2)]);
                return true;
            }
            case 'b': 
            case 'h': {
                result.append(this.localeData.shortMonthNames[calendar.get(2)]);
                return true;
            }
            case 'C': {
                this.appendLocalized(result, calendar.get(1) / 100, 2);
                return true;
            }
            case 'D': {
                this.appendT(result, 'm', calendar);
                result.append('/');
                this.appendT(result, 'd', calendar);
                result.append('/');
                this.appendT(result, 'y', calendar);
                return true;
            }
            case 'F': {
                this.appendT(result, 'Y', calendar);
                result.append('-');
                this.appendT(result, 'm', calendar);
                result.append('-');
                this.appendT(result, 'd', calendar);
                return true;
            }
            case 'H': {
                this.appendLocalized(result, calendar.get(11), 2);
                return true;
            }
            case 'I': {
                this.appendLocalized(result, this.to12Hour(calendar.get(10)), 2);
                return true;
            }
            case 'L': {
                this.appendLocalized(result, calendar.get(14), 3);
                return true;
            }
            case 'M': {
                this.appendLocalized(result, calendar.get(12), 2);
                return true;
            }
            case 'N': {
                this.appendLocalized(result, (long)calendar.get(14) * 1000000L, 9);
                return true;
            }
            case 'Q': {
                this.appendLocalized(result, calendar.getTimeInMillis(), 0);
                return true;
            }
            case 'R': {
                this.appendT(result, 'H', calendar);
                result.append(':');
                this.appendT(result, 'M', calendar);
                return true;
            }
            case 'S': {
                this.appendLocalized(result, calendar.get(13), 2);
                return true;
            }
            case 'T': {
                this.appendT(result, 'H', calendar);
                result.append(':');
                this.appendT(result, 'M', calendar);
                result.append(':');
                this.appendT(result, 'S', calendar);
                return true;
            }
            case 'Y': {
                this.appendLocalized(result, calendar.get(1), 4);
                return true;
            }
            case 'Z': {
                TimeZone timeZone = calendar.getTimeZone();
                result.append(timeZone.getDisplayName(timeZone.inDaylightTime(calendar.getTime()), 0, this.locale));
                return true;
            }
            case 'c': {
                this.appendT(result, 'a', calendar);
                result.append(' ');
                this.appendT(result, 'b', calendar);
                result.append(' ');
                this.appendT(result, 'd', calendar);
                result.append(' ');
                this.appendT(result, 'T', calendar);
                result.append(' ');
                this.appendT(result, 'Z', calendar);
                result.append(' ');
                this.appendT(result, 'Y', calendar);
                return true;
            }
            case 'd': {
                this.appendLocalized(result, calendar.get(5), 2);
                return true;
            }
            case 'e': {
                this.appendLocalized(result, calendar.get(5), 0);
                return true;
            }
            case 'j': {
                this.appendLocalized(result, calendar.get(6), 3);
                return true;
            }
            case 'k': {
                this.appendLocalized(result, calendar.get(11), 0);
                return true;
            }
            case 'l': {
                this.appendLocalized(result, this.to12Hour(calendar.get(10)), 0);
                return true;
            }
            case 'm': {
                this.appendLocalized(result, calendar.get(2) + 1, 2);
                return true;
            }
            case 'p': {
                result.append(this.localeData.amPm[calendar.get(9)].toLowerCase(this.locale));
                return true;
            }
            case 'r': {
                this.appendT(result, 'I', calendar);
                result.append(':');
                this.appendT(result, 'M', calendar);
                result.append(':');
                this.appendT(result, 'S', calendar);
                result.append(' ');
                result.append(this.localeData.amPm[calendar.get(9)]);
                return true;
            }
            case 's': {
                this.appendLocalized(result, calendar.getTimeInMillis() / 1000L, 0);
                return true;
            }
            case 'y': {
                this.appendLocalized(result, calendar.get(1) % 100, 2);
                return true;
            }
            case 'z': {
                long offset = calendar.get(15) + calendar.get(16);
                char sign = '+';
                if (offset < 0L) {
                    sign = '-';
                    offset = -offset;
                }
                result.append(sign);
                this.appendLocalized(result, offset / 3600000L, 2);
                this.appendLocalized(result, offset % 3600000L / 60000L, 2);
                return true;
            }
        }
        return false;
    }

    private int to12Hour(int hour) {
        return hour == 0 ? 12 : hour;
    }

    private void appendLocalized(StringBuilder result, long value, int width) {
        int paddingIndex = result.length();
        char zeroDigit = this.localeData.zeroDigit;
        if (zeroDigit == '0') {
            result.append(value);
        } else {
            result.append(this.localizeDigits(Long.toString(value)));
        }
        int zeroCount = width - (result.length() - paddingIndex);
        if (zeroCount <= 0) {
            return;
        }
        if (zeroDigit == '0') {
            result.insert(paddingIndex, ZEROS, 0, zeroCount);
        } else {
            for (int i = 0; i < zeroCount; ++i) {
                result.insert(paddingIndex, zeroDigit);
            }
        }
    }

    private CharSequence transformFromSpecialNumber(double d) {
        String source = null;
        if (Double.isNaN(d)) {
            source = "NaN";
        } else if (d == Double.POSITIVE_INFINITY) {
            source = this.formatToken.flagPlus ? "+Infinity" : (this.formatToken.flagSpace ? " Infinity" : "Infinity");
        } else if (d == Double.NEGATIVE_INFINITY) {
            source = this.formatToken.flagParenthesis ? "(Infinity)" : "-Infinity";
        } else {
            return null;
        }
        this.formatToken.setPrecision(-1);
        this.formatToken.flagZero = false;
        return this.padding(source, 0);
    }

    private CharSequence transformFromFloat() {
        if (this.arg == null) {
            return this.transformFromNull();
        }
        if (this.arg instanceof Float || this.arg instanceof Double) {
            Number number = (Number)this.arg;
            double d = number.doubleValue();
            if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                return this.transformFromSpecialNumber(d);
            }
        } else if (!(this.arg instanceof BigDecimal)) {
            throw this.badArgumentType();
        }
        char conversionType = this.formatToken.getConversionType();
        if (conversionType != 'a' && conversionType != 'A' && !this.formatToken.isPrecisionSet()) {
            this.formatToken.setPrecision(6);
        }
        StringBuilder result = new StringBuilder();
        switch (conversionType) {
            case 'A': 
            case 'a': {
                this.transformA(result);
                break;
            }
            case 'E': 
            case 'e': {
                this.transformE(result);
                break;
            }
            case 'f': {
                this.transformF(result);
                break;
            }
            case 'G': 
            case 'g': {
                this.transformG(result);
                break;
            }
            default: {
                throw this.formatToken.unknownFormatConversionException();
            }
        }
        this.formatToken.setPrecision(-1);
        int startIndex = 0;
        if (result.charAt(0) == this.localeData.minusSign) {
            if (this.formatToken.flagParenthesis) {
                return this.wrapParentheses(result);
            }
        } else {
            if (this.formatToken.flagSpace) {
                result.insert(0, ' ');
                ++startIndex;
            }
            if (this.formatToken.flagPlus) {
                result.insert(0, '+');
                ++startIndex;
            }
        }
        char firstChar = result.charAt(0);
        if (this.formatToken.flagZero && (firstChar == '+' || firstChar == this.localeData.minusSign)) {
            startIndex = 1;
        }
        if (conversionType == 'a' || conversionType == 'A') {
            startIndex += 2;
        }
        return this.padding(result, startIndex);
    }

    private void transformE(StringBuilder result) {
        int precision = this.formatToken.getPrecision();
        String pattern = "0E+00";
        if (precision > 0) {
            StringBuilder sb = new StringBuilder("0.");
            char[] zeros = new char[precision];
            Arrays.fill(zeros, '0');
            sb.append(zeros);
            sb.append("E+00");
            pattern = sb.toString();
        }
        NativeDecimalFormat nf = this.getDecimalFormat(pattern);
        char[] chars = this.arg instanceof BigDecimal ? nf.formatBigDecimal((BigDecimal)this.arg, null) : nf.formatDouble(((Number)this.arg).doubleValue(), null);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != 'E') continue;
            chars[i] = 101;
        }
        result.append(chars);
        if (this.formatToken.flagSharp && precision == 0) {
            int indexOfE = result.indexOf("e");
            result.insert(indexOfE, this.localeData.decimalSeparator);
        }
    }

    private void transformG(StringBuilder result) {
        int precision = this.formatToken.getPrecision();
        if (precision == 0) {
            precision = 1;
        }
        this.formatToken.setPrecision(precision);
        double d = ((Number)this.arg).doubleValue();
        if (d == 0.0) {
            this.formatToken.setPrecision(--precision);
            this.transformF(result);
            return;
        }
        boolean requireScientificRepresentation = true;
        if (Double.isInfinite(d = Math.abs(d))) {
            precision = this.formatToken.getPrecision();
            this.formatToken.setPrecision(--precision);
            this.transformE(result);
            return;
        }
        BigDecimal b = new BigDecimal(d, new MathContext(precision));
        d = b.doubleValue();
        long l = b.longValue();
        if (d >= 1.0 && d < Math.pow(10.0, precision)) {
            if ((double)l < Math.pow(10.0, precision)) {
                requireScientificRepresentation = false;
                if (String.valueOf(l = Math.round(d * Math.pow(10.0, (precision = (precision -= String.valueOf(l).length()) < 0 ? 0 : precision) + 1))).length() <= this.formatToken.getPrecision()) {
                    ++precision;
                }
                this.formatToken.setPrecision(precision);
            }
        } else {
            l = b.movePointRight(4).longValue();
            if (d >= Math.pow(10.0, -4.0) && d < 1.0) {
                requireScientificRepresentation = false;
                if (String.valueOf(l = b.movePointRight((precision += 4 - String.valueOf(l).length()) + 1).longValue()).length() <= this.formatToken.getPrecision()) {
                    ++precision;
                }
                if ((double)(l = b.movePointRight(precision).longValue()) >= Math.pow(10.0, precision - 4)) {
                    this.formatToken.setPrecision(precision);
                }
            }
        }
        if (requireScientificRepresentation) {
            precision = this.formatToken.getPrecision();
            this.formatToken.setPrecision(--precision);
            this.transformE(result);
        } else {
            this.transformF(result);
        }
    }

    private void transformF(StringBuilder result) {
        String pattern = "0.000000";
        int precision = this.formatToken.getPrecision();
        if (this.formatToken.flagComma || precision != 6) {
            StringBuilder patternBuilder = new StringBuilder();
            if (this.formatToken.flagComma) {
                patternBuilder.append(',');
                int groupingSize = 3;
                char[] sharps = new char[groupingSize - 1];
                Arrays.fill(sharps, '#');
                patternBuilder.append(sharps);
            }
            patternBuilder.append('0');
            if (precision > 0) {
                patternBuilder.append('.');
                for (int i = 0; i < precision; ++i) {
                    patternBuilder.append('0');
                }
            }
            pattern = patternBuilder.toString();
        }
        NativeDecimalFormat nf = this.getDecimalFormat(pattern);
        if (this.arg instanceof BigDecimal) {
            result.append(nf.formatBigDecimal((BigDecimal)this.arg, null));
        } else {
            result.append(nf.formatDouble(((Number)this.arg).doubleValue(), null));
        }
        if (this.formatToken.flagSharp && precision == 0) {
            result.append(this.localeData.decimalSeparator);
        }
    }

    private void transformA(StringBuilder result) {
        if (this.arg instanceof Float) {
            result.append(Float.toHexString(((Float)this.arg).floatValue()));
        } else if (this.arg instanceof Double) {
            result.append(Double.toHexString((Double)this.arg));
        } else {
            throw this.badArgumentType();
        }
        if (!this.formatToken.isPrecisionSet()) {
            return;
        }
        int precision = this.formatToken.getPrecision();
        if (precision == 0) {
            precision = 1;
        }
        int indexOfFirstFractionalDigit = result.indexOf(".") + 1;
        int indexOfP = result.indexOf("p");
        int fractionalLength = indexOfP - indexOfFirstFractionalDigit;
        if (fractionalLength == precision) {
            return;
        }
        if (fractionalLength < precision) {
            char[] zeros = new char[precision - fractionalLength];
            Arrays.fill(zeros, '0');
            result.insert(indexOfP, zeros);
            return;
        }
        result.delete(indexOfFirstFractionalDigit + precision, indexOfP);
    }

    private static class CachedDecimalFormat {
        public NativeDecimalFormat decimalFormat;
        public LocaleData currentLocaleData;
        public String currentPattern;

        public NativeDecimalFormat update(LocaleData localeData, String pattern) {
            if (this.decimalFormat == null) {
                this.currentPattern = pattern;
                this.currentLocaleData = localeData;
                this.decimalFormat = new NativeDecimalFormat(this.currentPattern, this.currentLocaleData);
            }
            if (!pattern.equals(this.currentPattern)) {
                this.decimalFormat.applyPattern(pattern);
                this.currentPattern = pattern;
            }
            if (localeData != this.currentLocaleData) {
                this.decimalFormat.setDecimalFormatSymbols(localeData);
                this.currentLocaleData = localeData;
            }
            return this.decimalFormat;
        }
    }

    private static class FormatSpecifierParser {
        private String format;
        private int length;
        private int startIndex;
        private int i;

        FormatSpecifierParser(String format) {
            this.format = format;
            this.length = format.length();
        }

        FormatToken parseFormatToken(int offset) {
            this.startIndex = offset;
            this.i = offset;
            return this.parseArgumentIndexAndFlags(new FormatToken());
        }

        String getFormatSpecifierText() {
            return this.format.substring(this.startIndex, this.i);
        }

        private int peek() {
            return this.i < this.length ? (int)this.format.charAt(this.i) : -1;
        }

        private char advance() {
            if (this.i >= this.length) {
                throw this.unknownFormatConversionException();
            }
            return this.format.charAt(this.i++);
        }

        private UnknownFormatConversionException unknownFormatConversionException() {
            throw new UnknownFormatConversionException(this.getFormatSpecifierText());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private FormatToken parseArgumentIndexAndFlags(FormatToken token) {
            int position = this.i;
            int ch = this.peek();
            if (Character.isDigit(ch)) {
                int number = this.nextInt();
                if (this.peek() == 36) {
                    this.advance();
                    if (number == -1) {
                        throw new MissingFormatArgumentException(this.getFormatSpecifierText());
                    }
                    token.setArgIndex(Math.max(0, number - 1));
                } else {
                    if (ch != 48) return this.parseWidth(token, number);
                    this.i = position;
                }
            } else if (ch == 60) {
                token.setArgIndex(-2);
                this.advance();
            }
            while (token.setFlag(this.peek())) {
                this.advance();
            }
            ch = this.peek();
            if (Character.isDigit(ch)) {
                return this.parseWidth(token, this.nextInt());
            }
            if (ch != 46) return this.parseConversionType(token);
            return this.parsePrecision(token);
        }

        private FormatToken parseWidth(FormatToken token, int width) {
            token.setWidth(width);
            int ch = this.peek();
            if (ch == 46) {
                return this.parsePrecision(token);
            }
            return this.parseConversionType(token);
        }

        private FormatToken parsePrecision(FormatToken token) {
            this.advance();
            int ch = this.peek();
            if (Character.isDigit(ch)) {
                token.setPrecision(this.nextInt());
                return this.parseConversionType(token);
            }
            throw this.unknownFormatConversionException();
        }

        private FormatToken parseConversionType(FormatToken token) {
            char conversionType = this.advance();
            token.setConversionType(conversionType);
            if (conversionType == 't' || conversionType == 'T') {
                char dateSuffix = this.advance();
                token.setDateSuffix(dateSuffix);
            }
            return token;
        }

        private int nextInt() {
            long value = 0L;
            while (this.i < this.length && Character.isDigit(this.format.charAt(this.i))) {
                if ((value = 10L * value + (long)(this.format.charAt(this.i++) - 48)) <= Integer.MAX_VALUE) continue;
                return this.failNextInt();
            }
            return (int)value;
        }

        private int failNextInt() {
            while (Character.isDigit(this.peek())) {
                this.advance();
            }
            return -1;
        }
    }

    private static class FormatToken {
        static final int LAST_ARGUMENT_INDEX = -2;
        static final int UNSET = -1;
        static final int FLAGS_UNSET = 0;
        static final int DEFAULT_PRECISION = 6;
        static final int FLAG_ZERO = 16;
        private int argIndex = -1;
        boolean flagComma;
        boolean flagMinus;
        boolean flagParenthesis;
        boolean flagPlus;
        boolean flagSharp;
        boolean flagSpace;
        boolean flagZero;
        private char conversionType = (char)65535;
        private char dateSuffix;
        private int precision = -1;
        private int width = -1;
        private StringBuilder strFlags;

        private FormatToken() {
        }

        boolean isDefault() {
            return !this.flagComma && !this.flagMinus && !this.flagParenthesis && !this.flagPlus && !this.flagSharp && !this.flagSpace && !this.flagZero && this.width == -1 && this.precision == -1;
        }

        boolean isPrecisionSet() {
            return this.precision != -1;
        }

        int getArgIndex() {
            return this.argIndex;
        }

        void setArgIndex(int index) {
            this.argIndex = index;
        }

        int getWidth() {
            return this.width;
        }

        void setWidth(int width) {
            this.width = width;
        }

        int getPrecision() {
            return this.precision;
        }

        void setPrecision(int precise) {
            this.precision = precise;
        }

        String getStrFlags() {
            return this.strFlags != null ? this.strFlags.toString() : "";
        }

        boolean setFlag(int ch) {
            boolean dupe = false;
            switch (ch) {
                case 44: {
                    dupe = this.flagComma;
                    this.flagComma = true;
                    break;
                }
                case 45: {
                    dupe = this.flagMinus;
                    this.flagMinus = true;
                    break;
                }
                case 40: {
                    dupe = this.flagParenthesis;
                    this.flagParenthesis = true;
                    break;
                }
                case 43: {
                    dupe = this.flagPlus;
                    this.flagPlus = true;
                    break;
                }
                case 35: {
                    dupe = this.flagSharp;
                    this.flagSharp = true;
                    break;
                }
                case 32: {
                    dupe = this.flagSpace;
                    this.flagSpace = true;
                    break;
                }
                case 48: {
                    dupe = this.flagZero;
                    this.flagZero = true;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (dupe) {
                throw new DuplicateFormatFlagsException(String.valueOf(ch));
            }
            if (this.strFlags == null) {
                this.strFlags = new StringBuilder(7);
            }
            this.strFlags.append((char)ch);
            return true;
        }

        char getConversionType() {
            return this.conversionType;
        }

        void setConversionType(char c) {
            this.conversionType = c;
        }

        char getDateSuffix() {
            return this.dateSuffix;
        }

        void setDateSuffix(char c) {
            this.dateSuffix = c;
        }

        boolean requireArgument() {
            return this.conversionType != '%' && this.conversionType != 'n';
        }

        void checkFlags(Object arg) {
            boolean allowComma = false;
            boolean allowMinus = true;
            boolean allowParenthesis = false;
            boolean allowPlus = false;
            boolean allowSharp = false;
            boolean allowSpace = false;
            boolean allowZero = false;
            boolean allowPrecision = true;
            boolean allowWidth = true;
            boolean allowArgument = true;
            switch (this.conversionType) {
                case 'C': 
                case 'T': 
                case 'c': 
                case 't': {
                    allowPrecision = false;
                    break;
                }
                case 'S': 
                case 's': {
                    if (!(arg instanceof Formattable)) break;
                    allowSharp = true;
                    break;
                }
                case 'G': 
                case 'g': {
                    allowZero = true;
                    allowSpace = true;
                    allowPlus = true;
                    allowParenthesis = true;
                    allowComma = true;
                    break;
                }
                case 'f': {
                    allowZero = true;
                    allowSpace = true;
                    allowSharp = true;
                    allowPlus = true;
                    allowParenthesis = true;
                    allowComma = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    allowZero = true;
                    allowSpace = true;
                    allowSharp = true;
                    allowPlus = true;
                    allowParenthesis = true;
                    break;
                }
                case 'A': 
                case 'a': {
                    allowZero = true;
                    allowSpace = true;
                    allowSharp = true;
                    allowPlus = true;
                    break;
                }
                case 'd': {
                    allowZero = true;
                    allowSpace = true;
                    allowPlus = true;
                    allowParenthesis = true;
                    allowComma = true;
                    allowPrecision = false;
                    break;
                }
                case 'X': 
                case 'o': 
                case 'x': {
                    allowZero = true;
                    allowSharp = true;
                    if (arg == null || arg instanceof BigInteger) {
                        allowSpace = true;
                        allowPlus = true;
                        allowParenthesis = true;
                    }
                    allowPrecision = false;
                    break;
                }
                case 'n': {
                    allowMinus = false;
                    allowWidth = false;
                    allowPrecision = false;
                    allowArgument = false;
                    break;
                }
                case '%': {
                    allowArgument = false;
                    allowPrecision = false;
                    break;
                }
                case 'B': 
                case 'H': 
                case 'b': 
                case 'h': {
                    break;
                }
                default: {
                    throw this.unknownFormatConversionException();
                }
            }
            String mismatch = null;
            if (!allowComma && this.flagComma) {
                mismatch = ",";
            } else if (!allowMinus && this.flagMinus) {
                mismatch = "-";
            } else if (!allowParenthesis && this.flagParenthesis) {
                mismatch = "(";
            } else if (!allowPlus && this.flagPlus) {
                mismatch = "+";
            } else if (!allowSharp && this.flagSharp) {
                mismatch = "#";
            } else if (!allowSpace && this.flagSpace) {
                mismatch = " ";
            } else if (!allowZero && this.flagZero) {
                mismatch = "0";
            }
            if (mismatch != null) {
                if (this.conversionType == 'n') {
                    throw new IllegalFormatFlagsException(mismatch);
                }
                throw new FormatFlagsConversionMismatchException(mismatch, this.conversionType);
            }
            if ((this.flagMinus || this.flagZero) && this.width == -1) {
                throw new MissingFormatWidthException("-" + this.conversionType);
            }
            if (!allowArgument && this.argIndex != -1) {
                throw new IllegalFormatFlagsException("%" + this.conversionType + " doesn't take an argument");
            }
            if (!allowPrecision && this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (!allowWidth && this.width != -1) {
                throw new IllegalFormatWidthException(this.width);
            }
            if (this.flagPlus && this.flagSpace) {
                throw new IllegalFormatFlagsException("the '+' and ' ' flags are incompatible");
            }
            if (this.flagMinus && this.flagZero) {
                throw new IllegalFormatFlagsException("the '-' and '0' flags are incompatible");
            }
        }

        public UnknownFormatConversionException unknownFormatConversionException() {
            if (this.conversionType == 't' || this.conversionType == 'T') {
                throw new UnknownFormatConversionException(String.format("%c%c", Character.valueOf(this.conversionType), Character.valueOf(this.dateSuffix)));
            }
            throw new UnknownFormatConversionException(String.valueOf(this.conversionType));
        }
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }
}

