/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

public final class EventLogger {
    private static volatile Reporter REPORTER = new DefaultReporter();

    public static void setReporter(Reporter reporter) {
        if (reporter == null) {
            throw new NullPointerException("reporter == null");
        }
        REPORTER = reporter;
    }

    public static Reporter getReporter() {
        return REPORTER;
    }

    public static void writeEvent(int code, Object ... list) {
        EventLogger.getReporter().report(code, list);
    }

    public static interface Reporter {
        public void report(int var1, Object ... var2);
    }

    private static final class DefaultReporter
    implements Reporter {
        private DefaultReporter() {
        }

        @Override
        public void report(int code, Object ... list) {
            StringBuilder sb = new StringBuilder();
            sb.append(code);
            for (Object o : list) {
                sb.append(",");
                sb.append(o.toString());
            }
            System.out.println(sb);
        }
    }
}

