/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.crypto;

public class SHA1Impl {
    static void computeHash(int[] arrW) {
        int temp;
        int t;
        int a = arrW[82];
        int b = arrW[83];
        int c = arrW[84];
        int d = arrW[85];
        int e = arrW[86];
        for (t = 16; t < 80; ++t) {
            temp = arrW[t - 3] ^ arrW[t - 8] ^ arrW[t - 14] ^ arrW[t - 16];
            arrW[t] = temp << 1 | temp >>> 31;
        }
        for (t = 0; t < 20; ++t) {
            temp = (a << 5 | a >>> 27) + (b & c | ~b & d) + (e + arrW[t] + 1518500249);
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (t = 20; t < 40; ++t) {
            temp = (a << 5 | a >>> 27) + (b ^ c ^ d) + (e + arrW[t] + 1859775393);
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (t = 40; t < 60; ++t) {
            temp = (a << 5 | a >>> 27) + (b & c | b & d | c & d) + (e + arrW[t] + -1894007588);
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (t = 60; t < 80; ++t) {
            temp = (a << 5 | a >>> 27) + (b ^ c ^ d) + (e + arrW[t] + -899497514);
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        arrW[82] = arrW[82] + a;
        arrW[83] = arrW[83] + b;
        arrW[84] = arrW[84] + c;
        arrW[85] = arrW[85] + d;
        arrW[86] = arrW[86] + e;
    }

    static void updateHash(int[] intArray, byte[] byteInput, int fromByte, int toByte) {
        int byteIndex;
        int index = intArray[81];
        int i = fromByte;
        int wordIndex = index >> 2;
        intArray[81] = index + toByte - fromByte + 1 & 0x3F;
        if (byteIndex != 0) {
            for (byteIndex = index & 3; i <= toByte && byteIndex < 4; ++byteIndex, ++i) {
                int n = wordIndex;
                intArray[n] = intArray[n] | (byteInput[i] & 0xFF) << (3 - byteIndex << 3);
            }
            if (byteIndex == 4 && ++wordIndex == 16) {
                SHA1Impl.computeHash(intArray);
                wordIndex = 0;
            }
            if (i > toByte) {
                return;
            }
        }
        int maxWord = toByte - i + 1 >> 2;
        for (int k = 0; k < maxWord; ++k) {
            intArray[wordIndex] = (byteInput[i] & 0xFF) << 24 | (byteInput[i + 1] & 0xFF) << 16 | (byteInput[i + 2] & 0xFF) << 8 | byteInput[i + 3] & 0xFF;
            i += 4;
            if (++wordIndex < 16) continue;
            SHA1Impl.computeHash(intArray);
            wordIndex = 0;
        }
        int nBytes = toByte - i + 1;
        if (nBytes != 0) {
            int w = (byteInput[i] & 0xFF) << 24;
            if (nBytes != 1) {
                w |= (byteInput[i + 1] & 0xFF) << 16;
                if (nBytes != 2) {
                    w |= (byteInput[i + 2] & 0xFF) << 8;
                }
            }
            intArray[wordIndex] = w;
        }
    }
}

