/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Callback;
import SQLite.Exception;
import SQLite.Shell;
import SQLite.TableResult;

class DBDump
implements Callback {
    Shell s;

    DBDump(Shell s, String[] tables) {
        this.s = s;
        s.pw.println("BEGIN TRANSACTION;");
        if (tables == null || tables.length == 0) {
            try {
                s.db.exec("SELECT name, type, sql FROM sqlite_master WHERE type!='meta' AND sql NOT NULL ORDER BY substr(type,2,1), name", this);
            }
            catch (Exception e) {
                s.err.println("SQL Error: " + e);
                s.err.flush();
            }
        } else {
            String[] arg = new String[1];
            for (int i = 0; i < tables.length; ++i) {
                arg[0] = tables[i];
                try {
                    s.db.exec("SELECT name, type, sql FROM sqlite_master WHERE tbl_name LIKE '%q' AND type!='meta'  AND sql NOT NULL  ORDER BY substr(type,2,1), name", this, arg);
                    continue;
                }
                catch (Exception e) {
                    s.err.println("SQL Error: " + e);
                    s.err.flush();
                }
            }
        }
        s.pw.println("COMMIT;");
    }

    @Override
    public void columns(String[] col) {
    }

    @Override
    public void types(String[] args) {
    }

    @Override
    public boolean newrow(String[] args) {
        if (args.length != 3) {
            return true;
        }
        this.s.pw.println(args[2] + ";");
        if (args[1].compareTo("table") == 0) {
            Shell s2 = (Shell)this.s.clone();
            s2.mode = 5;
            s2.set_table_name(args[0]);
            String[] qargs = new String[]{args[0]};
            try {
                if (s2.db.is3()) {
                    String query;
                    TableResult t = null;
                    t = s2.db.get_table("PRAGMA table_info('%q')", qargs);
                    if (t != null) {
                        StringBuffer sb = new StringBuffer();
                        String sep = "";
                        sb.append("SELECT ");
                        for (int i = 0; i < t.nrows; ++i) {
                            String col = ((String[])t.rows.elementAt(i))[1];
                            sb.append(sep + "quote(" + Shell.sql_quote_dbl(col) + ")");
                            sep = ",";
                        }
                        sb.append(" from '%q'");
                        query = sb.toString();
                        s2.mode = 6;
                    } else {
                        query = "SELECT * from '%q'";
                    }
                    s2.db.exec(query, s2, qargs);
                } else {
                    s2.db.exec("SELECT * from '%q'", s2, qargs);
                }
            }
            catch (Exception e) {
                this.s.err.println("SQL Error: " + e);
                this.s.err.flush();
                return true;
            }
        }
        return false;
    }
}

