/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Callback;
import SQLite.DBDump;
import SQLite.Database;
import SQLite.Exception;
import SQLite.TableResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Shell
implements Callback {
    Database db;
    boolean echo;
    int count;
    int mode;
    boolean showHeader;
    String tableName;
    String sep;
    String[] cols;
    int[] colwidth;
    String destTable;
    PrintWriter pw;
    PrintWriter err;
    static final int MODE_Line = 0;
    static final int MODE_Column = 1;
    static final int MODE_List = 2;
    static final int MODE_Semi = 3;
    static final int MODE_Html = 4;
    static final int MODE_Insert = 5;
    static final int MODE_Insert2 = 6;

    public Shell(PrintWriter pw, PrintWriter err) {
        this.pw = pw;
        this.err = err;
    }

    public Shell(PrintStream ps, PrintStream errs) {
        this.pw = new PrintWriter(ps);
        this.err = new PrintWriter(errs);
    }

    protected Object clone() {
        Shell s = new Shell(this.pw, this.err);
        s.db = this.db;
        s.echo = this.echo;
        s.mode = this.mode;
        s.count = 0;
        s.showHeader = this.showHeader;
        s.tableName = this.tableName;
        s.sep = this.sep;
        s.colwidth = this.colwidth;
        return s;
    }

    public static String sql_quote_dbl(String str) {
        int i;
        if (str == null) {
            return "NULL";
        }
        int single = 0;
        int dbl = 0;
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\'') {
                ++single;
                continue;
            }
            if (str.charAt(i) != '\"') continue;
            ++dbl;
        }
        if (dbl == 0) {
            return "\"" + str + "\"";
        }
        StringBuffer sb = new StringBuffer("\"");
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                sb.append("\"\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String sql_quote(String str) {
        int i;
        if (str == null) {
            return "NULL";
        }
        int single = 0;
        int dbl = 0;
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\'') {
                ++single;
                continue;
            }
            if (str.charAt(i) != '\"') continue;
            ++dbl;
        }
        if (single == 0) {
            return "'" + str + "'";
        }
        if (dbl == 0) {
            return "\"" + str + "\"";
        }
        StringBuffer sb = new StringBuffer("'");
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String html_quote(String str) {
        if (str == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            char x = c;
            if (x < ' ' || x > '\u007f') {
                sb.append("&#" + x + ";");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static boolean is_numeric(String str) {
        try {
            Double d = Double.valueOf(str);
        }
        catch (java.lang.Exception e) {
            return false;
        }
        return true;
    }

    void set_table_name(String str) {
        if (str == null) {
            this.tableName = "";
            return;
        }
        this.tableName = this.db.is3() ? Shell.sql_quote_dbl(str) : Shell.sql_quote(str);
    }

    @Override
    public void columns(String[] args) {
        this.cols = args;
    }

    @Override
    public void types(String[] args) {
    }

    @Override
    public boolean newrow(String[] args) {
        switch (this.mode) {
            case 0: {
                if (args.length == 0) break;
                if (this.count++ > 0) {
                    this.pw.println("");
                }
                for (int i = 0; i < args.length; ++i) {
                    this.pw.println(this.cols[i] + " = " + args[i] == null ? "NULL" : args[i]);
                }
                break;
            }
            case 1: {
                int i;
                String csep = "";
                if (this.count++ == 0) {
                    this.colwidth = new int[args.length];
                    for (i = 0; i < args.length; ++i) {
                        int w = this.cols[i].length();
                        if (w < 10) {
                            w = 10;
                        }
                        this.colwidth[i] = w;
                        if (!this.showHeader) continue;
                        this.pw.print(csep + this.cols[i]);
                        csep = " ";
                    }
                    if (this.showHeader) {
                        this.pw.println("");
                    }
                }
                if (args.length == 0) break;
                csep = "";
                for (i = 0; i < args.length; ++i) {
                    this.pw.print(csep + (args[i] == null ? "NULL" : args[i]));
                    csep = " ";
                }
                this.pw.println("");
                break;
            }
            case 2: 
            case 3: {
                int i;
                if (this.count++ == 0 && this.showHeader) {
                    for (i = 0; i < args.length; ++i) {
                        this.pw.print(this.cols[i] + (i == args.length - 1 ? "\n" : this.sep));
                    }
                }
                if (args.length == 0) break;
                for (i = 0; i < args.length; ++i) {
                    this.pw.print(args[i] == null ? "NULL" : args[i]);
                    if (this.mode == 3) {
                        this.pw.print(";");
                        continue;
                    }
                    if (i >= args.length - 1) continue;
                    this.pw.print(this.sep);
                }
                this.pw.println("");
                break;
            }
            case 4: {
                int i;
                if (this.count++ == 0 && this.showHeader) {
                    this.pw.print("<TR>");
                    for (i = 0; i < args.length; ++i) {
                        this.pw.print("<TH>" + Shell.html_quote(this.cols[i]) + "</TH>");
                    }
                    this.pw.println("</TR>");
                }
                if (args.length == 0) break;
                this.pw.print("<TR>");
                for (i = 0; i < args.length; ++i) {
                    this.pw.print("<TD>" + Shell.html_quote(args[i]) + "</TD>");
                }
                this.pw.println("</TR>");
                break;
            }
            case 5: {
                if (args.length == 0) break;
                String tname = this.tableName;
                if (this.destTable != null) {
                    tname = this.destTable;
                }
                this.pw.print("INSERT INTO " + tname + " VALUES(");
                for (int i = 0; i < args.length; ++i) {
                    String tsep;
                    String string = tsep = i > 0 ? "," : "";
                    if (args[i] == null) {
                        this.pw.print(tsep + "NULL");
                        continue;
                    }
                    if (Shell.is_numeric(args[i])) {
                        this.pw.print(tsep + args[i]);
                        continue;
                    }
                    this.pw.print(tsep + Shell.sql_quote(args[i]));
                }
                this.pw.println(");");
                break;
            }
            case 6: {
                if (args.length == 0) break;
                String tname = this.tableName;
                if (this.destTable != null) {
                    tname = this.destTable;
                }
                this.pw.print("INSERT INTO " + tname + " VALUES(");
                for (int i = 0; i < args.length; ++i) {
                    String tsep = i > 0 ? "," : "";
                    this.pw.print(tsep + args[i]);
                }
                this.pw.println(");");
            }
        }
        return false;
    }

    void do_meta(String line) {
        StringTokenizer st = new StringTokenizer(line.toLowerCase());
        int n = st.countTokens();
        if (n <= 0) {
            return;
        }
        String cmd = st.nextToken();
        String[] args = new String[n - 1];
        int i = 0;
        while (st.hasMoreTokens()) {
            args[i] = st.nextToken();
            ++i;
        }
        if (cmd.compareTo(".dump") == 0) {
            new DBDump(this, args);
            return;
        }
        if (cmd.compareTo(".echo") == 0) {
            if (args.length > 0 && (args[0].startsWith("y") || args[0].startsWith("on"))) {
                this.echo = true;
            }
            return;
        }
        if (cmd.compareTo(".exit") == 0) {
            try {
                this.db.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
        if (cmd.compareTo(".header") == 0) {
            if (args.length > 0 && (args[0].startsWith("y") || args[0].startsWith("on"))) {
                this.showHeader = true;
            }
            return;
        }
        if (cmd.compareTo(".help") == 0) {
            this.pw.println(".dump ?TABLE? ...  Dump database in text fmt");
            this.pw.println(".echo ON|OFF       Command echo on or off");
            this.pw.println(".enc ?NAME?        Change encoding");
            this.pw.println(".exit              Exit program");
            this.pw.println(".header ON|OFF     Display headers on or off");
            this.pw.println(".help              This message");
            this.pw.println(".mode MODE         Set output mode to\n                   line, column, insert\n                   list, or html");
            this.pw.println(".mode insert TABLE Generate SQL insert stmts");
            this.pw.println(".schema ?PATTERN?  List table schema");
            this.pw.println(".separator STRING  Set separator string");
            this.pw.println(".tables ?PATTERN?  List table names");
            return;
        }
        if (cmd.compareTo(".mode") == 0) {
            if (args.length > 0) {
                if (args[0].compareTo("line") == 0) {
                    this.mode = 0;
                } else if (args[0].compareTo("column") == 0) {
                    this.mode = 1;
                } else if (args[0].compareTo("list") == 0) {
                    this.mode = 2;
                } else if (args[0].compareTo("html") == 0) {
                    this.mode = 4;
                } else if (args[0].compareTo("insert") == 0) {
                    this.mode = 5;
                    if (args.length > 1) {
                        this.destTable = args[1];
                    }
                }
            }
            return;
        }
        if (cmd.compareTo(".separator") == 0) {
            if (args.length > 0) {
                this.sep = args[0];
            }
            return;
        }
        if (cmd.compareTo(".tables") == 0) {
            TableResult t = null;
            if (args.length > 0) {
                try {
                    String[] qarg = new String[]{args[0]};
                    t = this.db.get_table("SELECT name FROM sqlite_master WHERE type='table' AND name LIKE '%%%q%%' ORDER BY name", qarg);
                }
                catch (Exception e) {
                    this.err.println("SQL Error: " + e);
                    this.err.flush();
                }
            } else {
                try {
                    t = this.db.get_table("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name");
                }
                catch (Exception e) {
                    this.err.println("SQL Error: " + e);
                    this.err.flush();
                }
            }
            if (t != null) {
                for (i = 0; i < t.nrows; ++i) {
                    String tab = ((String[])t.rows.elementAt(i))[0];
                    if (tab == null) continue;
                    this.pw.println(tab);
                }
            }
            return;
        }
        if (cmd.compareTo(".schema") == 0) {
            if (args.length > 0) {
                try {
                    String[] qarg = new String[]{args[0]};
                    this.db.exec("SELECT sql FROM sqlite_master WHERE type!='meta' AND name LIKE '%%%q%%' AND sql NOTNULL ORDER BY type DESC, name", this, qarg);
                }
                catch (Exception e) {
                    this.err.println("SQL Error: " + e);
                    this.err.flush();
                }
            } else {
                try {
                    this.db.exec("SELECT sql FROM sqlite_master WHERE type!='meta' AND sql NOTNULL ORDER BY tbl_name, type DESC, name", this);
                }
                catch (Exception e) {
                    this.err.println("SQL Error: " + e);
                    this.err.flush();
                }
            }
            return;
        }
        if (cmd.compareTo(".enc") == 0) {
            try {
                this.db.set_encoding(args.length > 0 ? args[0] : null);
            }
            catch (Exception e) {
                this.err.println("" + e);
                this.err.flush();
            }
            return;
        }
        if (cmd.compareTo(".rekey") == 0) {
            try {
                this.db.rekey(args.length > 0 ? args[0] : null);
            }
            catch (Exception e) {
                this.err.println("" + e);
                this.err.flush();
            }
            return;
        }
        this.err.println("Unknown command '" + cmd + "'");
        this.err.flush();
    }

    String read_line(BufferedReader is, String prompt) {
        try {
            if (prompt != null) {
                this.pw.print(prompt);
                this.pw.flush();
            }
            String line = is.readLine();
            return line;
        }
        catch (IOException e) {
            return null;
        }
    }

    void do_input(BufferedReader is) {
        String line;
        String sql = null;
        String prompt = "SQLITE> ";
        while ((line = this.read_line(is, prompt)) != null) {
            if (this.echo) {
                this.pw.println(line);
            }
            if (line.length() > 0 && line.charAt(0) == '.') {
                this.do_meta(line);
            } else if (Database.complete(sql = sql == null ? line : sql + " " + line)) {
                try {
                    this.db.exec(sql, this);
                }
                catch (Exception e) {
                    if (!this.echo) {
                        this.err.println(sql);
                    }
                    this.err.println("SQL Error: " + e);
                    this.err.flush();
                }
                sql = null;
                prompt = "SQLITE> ";
            } else {
                prompt = "SQLITE? ";
            }
            this.pw.flush();
        }
        if (sql != null) {
            this.err.println("Incomplete SQL: " + sql);
            this.err.flush();
        }
    }

    void do_cmd(String sql) {
        if (this.db == null) {
            return;
        }
        if (sql.length() > 0 && sql.charAt(0) == '.') {
            this.do_meta(sql);
        } else {
            try {
                this.db.exec(sql, this);
            }
            catch (Exception e) {
                this.err.println("SQL Error: " + e);
                this.err.flush();
            }
        }
    }

    public static void main(String[] args) {
        String key = null;
        Shell s = new Shell(System.out, System.err);
        s.mode = 2;
        s.sep = "|";
        s.showHeader = false;
        s.db = new Database();
        String dbname = null;
        String sql = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-html") == 0) {
                s.mode = 4;
                continue;
            }
            if (args[i].compareTo("-list") == 0) {
                s.mode = 2;
                continue;
            }
            if (args[i].compareTo("-line") == 0) {
                s.mode = 0;
                continue;
            }
            if (i < args.length - 1 && args[i].compareTo("-separator") == 0) {
                s.sep = args[++i];
                continue;
            }
            if (args[i].compareTo("-header") == 0) {
                s.showHeader = true;
                continue;
            }
            if (args[i].compareTo("-noheader") == 0) {
                s.showHeader = false;
                continue;
            }
            if (args[i].compareTo("-echo") == 0) {
                s.echo = true;
                continue;
            }
            if (args[i].compareTo("-key") == 0) {
                key = args[++i];
                continue;
            }
            if (dbname == null) {
                dbname = args[i];
                continue;
            }
            if (sql == null) {
                sql = args[i];
                continue;
            }
            System.err.println("Arguments: ?OPTIONS? FILENAME ?SQL?");
            System.exit(1);
        }
        if (dbname == null) {
            System.err.println("No database file given");
            System.exit(1);
        }
        try {
            s.db.open(dbname, 0);
        }
        catch (Exception e) {
            System.err.println("Unable to open database: " + e);
            System.exit(1);
        }
        if (key != null) {
            try {
                s.db.key(key);
            }
            catch (Exception e) {
                System.err.println("Unable to set key: " + e);
                System.exit(1);
            }
        }
        if (sql != null) {
            s.do_cmd(sql);
            s.pw.flush();
        } else {
            BufferedReader is = new BufferedReader(new InputStreamReader(System.in));
            s.do_input(is);
            s.pw.flush();
        }
        try {
            s.db.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

