/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.spdy;

import com.android.okhttp.internal.Util;
import com.android.okhttp.internal.spdy.Settings;
import com.android.okhttp.internal.spdy.SpdyConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public final class SpdyStream {
    private static final int DATA_FRAME_HEADER_LENGTH = 8;
    private static final String[] STATUS_CODE_NAMES = new String[]{null, "PROTOCOL_ERROR", "INVALID_STREAM", "REFUSED_STREAM", "UNSUPPORTED_VERSION", "CANCEL", "INTERNAL_ERROR", "FLOW_CONTROL_ERROR", "STREAM_IN_USE", "STREAM_ALREADY_CLOSED", "INVALID_CREDENTIALS", "FRAME_TOO_LARGE"};
    public static final int RST_PROTOCOL_ERROR = 1;
    public static final int RST_INVALID_STREAM = 2;
    public static final int RST_REFUSED_STREAM = 3;
    public static final int RST_UNSUPPORTED_VERSION = 4;
    public static final int RST_CANCEL = 5;
    public static final int RST_INTERNAL_ERROR = 6;
    public static final int RST_FLOW_CONTROL_ERROR = 7;
    public static final int RST_STREAM_IN_USE = 8;
    public static final int RST_STREAM_ALREADY_CLOSED = 9;
    public static final int RST_INVALID_CREDENTIALS = 10;
    public static final int RST_FRAME_TOO_LARGE = 11;
    public static final int WINDOW_UPDATE_THRESHOLD = 32768;
    private final int id;
    private final SpdyConnection connection;
    private final int priority;
    private final int slot;
    private long readTimeoutMillis = 0L;
    private int writeWindowSize;
    private final List<String> requestHeaders;
    private List<String> responseHeaders;
    private final SpdyDataInputStream in = new SpdyDataInputStream();
    private final SpdyDataOutputStream out = new SpdyDataOutputStream();
    private int rstStatusCode = -1;

    SpdyStream(int id, SpdyConnection connection, int flags, int priority, int slot, List<String> requestHeaders, Settings settings) {
        if (connection == null) {
            throw new NullPointerException("connection == null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders == null");
        }
        this.id = id;
        this.connection = connection;
        this.priority = priority;
        this.slot = slot;
        this.requestHeaders = requestHeaders;
        if (this.isLocallyInitiated()) {
            this.in.finished = (flags & 2) != 0;
            this.out.finished = (flags & 1) != 0;
        } else {
            this.in.finished = (flags & 1) != 0;
            this.out.finished = (flags & 2) != 0;
        }
        this.setSettings(settings);
    }

    public synchronized boolean isOpen() {
        if (this.rstStatusCode != -1) {
            return false;
        }
        return !this.in.finished && !this.in.closed || !this.out.finished && !this.out.closed || this.responseHeaders == null;
    }

    public boolean isLocallyInitiated() {
        boolean streamIsClient = this.id % 2 == 1;
        return this.connection.client == streamIsClient;
    }

    public SpdyConnection getConnection() {
        return this.connection;
    }

    public List<String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public synchronized List<String> getResponseHeaders() throws IOException {
        try {
            while (this.responseHeaders == null && this.rstStatusCode == -1) {
                this.wait();
            }
            if (this.responseHeaders != null) {
                return this.responseHeaders;
            }
            throw new IOException("stream was reset: " + this.rstStatusString());
        }
        catch (InterruptedException e) {
            InterruptedIOException rethrow = new InterruptedIOException();
            rethrow.initCause(e);
            throw rethrow;
        }
    }

    public synchronized int getRstStatusCode() {
        return this.rstStatusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(List<String> responseHeaders, boolean out) throws IOException {
        assert (!Thread.holdsLock(this));
        int flags = 0;
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (responseHeaders == null) {
                throw new NullPointerException("responseHeaders == null");
            }
            if (this.isLocallyInitiated()) {
                throw new IllegalStateException("cannot reply to a locally initiated stream");
            }
            if (this.responseHeaders != null) {
                throw new IllegalStateException("reply already sent");
            }
            this.responseHeaders = responseHeaders;
            if (!out) {
                this.out.finished = true;
                flags |= 1;
            }
        }
        this.connection.writeSynReply(this.id, flags, responseHeaders);
    }

    public void setReadTimeout(long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() {
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.responseHeaders == null && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the output stream");
            }
        }
        return this.out;
    }

    public void close(int rstStatusCode) throws IOException {
        if (!this.closeInternal(rstStatusCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, rstStatusCode);
    }

    public void closeLater(int rstStatusCode) {
        if (!this.closeInternal(rstStatusCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, rstStatusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(int rstStatusCode) {
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.rstStatusCode != -1) {
                return false;
            }
            if (this.in.finished && this.out.finished) {
                return false;
            }
            this.rstStatusCode = rstStatusCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveReply(List<String> strings) throws IOException {
        assert (!Thread.holdsLock(this));
        boolean streamInUseError = false;
        boolean open = true;
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.isLocallyInitiated() && this.responseHeaders == null) {
                this.responseHeaders = strings;
                open = this.isOpen();
                this.notifyAll();
            } else {
                streamInUseError = true;
            }
        }
        if (streamInUseError) {
            this.closeLater(8);
        } else if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeaders(List<String> headers) throws IOException {
        assert (!Thread.holdsLock(this));
        boolean protocolError = false;
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.responseHeaders != null) {
                ArrayList<String> newHeaders = new ArrayList<String>();
                newHeaders.addAll(this.responseHeaders);
                newHeaders.addAll(headers);
                this.responseHeaders = newHeaders;
            } else {
                protocolError = true;
            }
        }
        if (protocolError) {
            this.closeLater(1);
        }
    }

    void receiveData(InputStream in, int length) throws IOException {
        assert (!Thread.holdsLock(this));
        this.in.receive(in, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFin() {
        boolean open;
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            this.in.finished = true;
            open = this.isOpen();
            this.notifyAll();
        }
        if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    synchronized void receiveRstStream(int statusCode) {
        if (this.rstStatusCode == -1) {
            this.rstStatusCode = statusCode;
            this.notifyAll();
        }
    }

    private void setSettings(Settings settings) {
        assert (Thread.holdsLock(this.connection));
        this.writeWindowSize = settings != null ? settings.getInitialWindowSize(65536) : 65536;
    }

    void receiveSettings(Settings settings) {
        assert (Thread.holdsLock(this));
        this.setSettings(settings);
        this.notifyAll();
    }

    synchronized void receiveWindowUpdate(int deltaWindowSize) {
        this.out.unacknowledgedBytes -= deltaWindowSize;
        this.notifyAll();
    }

    private String rstStatusString() {
        return this.rstStatusCode > 0 && this.rstStatusCode < STATUS_CODE_NAMES.length ? STATUS_CODE_NAMES[this.rstStatusCode] : Integer.toString(this.rstStatusCode);
    }

    int getPriority() {
        return this.priority;
    }

    int getSlot() {
        return this.slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelStreamIfNecessary() throws IOException {
        boolean open;
        boolean cancel;
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            cancel = !this.in.finished && this.in.closed && (this.out.finished || this.out.closed);
            open = this.isOpen();
        }
        if (cancel) {
            this.close(5);
        } else if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    private final class SpdyDataOutputStream
    extends OutputStream {
        private final byte[] buffer = new byte[8192];
        private int pos = 8;
        private boolean closed;
        private boolean finished;
        private int unacknowledgedBytes = 0;

        private SpdyDataOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            Util.writeSingleByte(this, b);
        }

        @Override
        public void write(byte[] bytes, int offset, int count) throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            Util.checkOffsetAndCount(bytes.length, offset, count);
            this.checkNotClosed();
            while (count > 0) {
                if (this.pos == this.buffer.length) {
                    this.writeFrame(false);
                }
                int bytesToCopy = Math.min(count, this.buffer.length - this.pos);
                System.arraycopy((Object)bytes, offset, (Object)this.buffer, this.pos, bytesToCopy);
                this.pos += bytesToCopy;
                offset += bytesToCopy;
                count -= bytesToCopy;
            }
        }

        @Override
        public void flush() throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            this.checkNotClosed();
            if (this.pos > 8) {
                this.writeFrame(false);
                SpdyStream.this.connection.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            if (!((SpdyStream)SpdyStream.this).out.finished) {
                this.writeFrame(true);
            }
            SpdyStream.this.connection.flush();
            SpdyStream.this.cancelStreamIfNecessary();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFrame(boolean last) throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            int length = this.pos - 8;
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                this.waitUntilWritable(length, last);
                this.unacknowledgedBytes += length;
            }
            int flags = 0;
            if (last) {
                flags |= 1;
            }
            Util.pokeInt(this.buffer, 0, SpdyStream.this.id & Integer.MAX_VALUE, ByteOrder.BIG_ENDIAN);
            Util.pokeInt(this.buffer, 4, (flags & 0xFF) << 24 | length & 0xFFFFFF, ByteOrder.BIG_ENDIAN);
            SpdyStream.this.connection.writeFrame(this.buffer, 0, this.pos);
            this.pos = 8;
        }

        private void waitUntilWritable(int count, boolean last) throws IOException {
            try {
                while (this.unacknowledgedBytes + count >= SpdyStream.this.writeWindowSize) {
                    SpdyStream.this.wait();
                    if (!last && this.closed) {
                        throw new IOException("stream closed");
                    }
                    if (this.finished) {
                        throw new IOException("stream finished");
                    }
                    if (SpdyStream.this.rstStatusCode == -1) continue;
                    throw new IOException("stream was reset: " + SpdyStream.this.rstStatusString());
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNotClosed() throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                if (this.closed) {
                    throw new IOException("stream closed");
                }
                if (this.finished) {
                    throw new IOException("stream finished");
                }
                if (SpdyStream.this.rstStatusCode != -1) {
                    throw new IOException("stream was reset: " + SpdyStream.this.rstStatusString());
                }
            }
        }
    }

    private final class SpdyDataInputStream
    extends InputStream {
        private final byte[] buffer = new byte[65536];
        private int pos = -1;
        private int limit;
        private boolean closed;
        private boolean finished;
        private int unacknowledgedBytes = 0;

        private SpdyDataInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                this.checkNotClosed();
                if (this.pos == -1) {
                    return 0;
                }
                if (this.limit > this.pos) {
                    return this.limit - this.pos;
                }
                return this.limit + (this.buffer.length - this.pos);
            }
        }

        @Override
        public int read() throws IOException {
            return Util.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int offset, int count) throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                int bytesToCopy;
                Util.checkOffsetAndCount(b.length, offset, count);
                this.waitUntilReadable();
                this.checkNotClosed();
                if (this.pos == -1) {
                    return -1;
                }
                int copied = 0;
                if (this.limit <= this.pos) {
                    bytesToCopy = Math.min(count, this.buffer.length - this.pos);
                    System.arraycopy((Object)this.buffer, this.pos, (Object)b, offset, bytesToCopy);
                    this.pos += bytesToCopy;
                    copied += bytesToCopy;
                    if (this.pos == this.buffer.length) {
                        this.pos = 0;
                    }
                }
                if (copied < count) {
                    bytesToCopy = Math.min(this.limit - this.pos, count - copied);
                    System.arraycopy((Object)this.buffer, this.pos, (Object)b, offset + copied, bytesToCopy);
                    this.pos += bytesToCopy;
                    copied += bytesToCopy;
                }
                this.unacknowledgedBytes += copied;
                if (this.unacknowledgedBytes >= 32768) {
                    SpdyStream.this.connection.writeWindowUpdateLater(SpdyStream.this.id, this.unacknowledgedBytes);
                    this.unacknowledgedBytes = 0;
                }
                if (this.pos == this.limit) {
                    this.pos = -1;
                    this.limit = 0;
                }
                return copied;
            }
        }

        private void waitUntilReadable() throws IOException {
            long start = 0L;
            long remaining = 0L;
            if (SpdyStream.this.readTimeoutMillis != 0L) {
                start = System.nanoTime() / 1000000L;
                remaining = SpdyStream.this.readTimeoutMillis;
            }
            try {
                while (this.pos == -1 && !this.finished && !this.closed && SpdyStream.this.rstStatusCode == -1) {
                    if (SpdyStream.this.readTimeoutMillis == 0L) {
                        SpdyStream.this.wait();
                        continue;
                    }
                    if (remaining > 0L) {
                        SpdyStream.this.wait(remaining);
                        remaining = start + SpdyStream.this.readTimeoutMillis - System.nanoTime() / 1000000L;
                        continue;
                    }
                    throw new SocketTimeoutException();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void receive(InputStream in, int byteCount) throws IOException {
            boolean flowControlError;
            int limit;
            int firstNewByte;
            int pos;
            boolean finished;
            assert (!Thread.holdsLock(SpdyStream.this));
            if (byteCount == 0) {
                return;
            }
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                finished = this.finished;
                pos = this.pos;
                firstNewByte = this.limit;
                limit = this.limit;
                flowControlError = byteCount > this.buffer.length - this.available();
            }
            if (flowControlError) {
                Util.skipByReading(in, byteCount);
                SpdyStream.this.closeLater(7);
                return;
            }
            if (finished) {
                Util.skipByReading(in, byteCount);
                return;
            }
            if (pos < limit) {
                int firstCopyCount = Math.min(byteCount, this.buffer.length - limit);
                Util.readFully(in, this.buffer, limit, firstCopyCount);
                byteCount -= firstCopyCount;
                if ((limit += firstCopyCount) == this.buffer.length) {
                    limit = 0;
                }
            }
            if (byteCount > 0) {
                Util.readFully(in, this.buffer, limit, byteCount);
                limit += byteCount;
            }
            SpdyStream spdyStream2 = SpdyStream.this;
            synchronized (spdyStream2) {
                this.limit = limit;
                if (this.pos == -1) {
                    this.pos = firstNewByte;
                    SpdyStream.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                this.closed = true;
                SpdyStream.this.notifyAll();
            }
            SpdyStream.this.cancelStreamIfNecessary();
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("stream closed");
            }
            if (SpdyStream.this.rstStatusCode != -1) {
                throw new IOException("stream was reset: " + SpdyStream.this.rstStatusString());
            }
        }
    }
}

