/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

final class StringToReal {
    StringToReal() {
    }

    private static native double parseDblImpl(String var0, int var1);

    private static native float parseFltImpl(String var0, int var1);

    private static NumberFormatException invalidReal(String s, boolean isDouble) {
        throw new NumberFormatException("Invalid " + (isDouble ? "double" : "float") + ": \"" + s + "\"");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StringExponentPair initialParse(String s, int length, boolean isDouble) {
        StringExponentPair result = new StringExponentPair();
        if (length == 0) {
            throw StringToReal.invalidReal(s, isDouble);
        }
        result.negative = s.charAt(0) == '-';
        char c = s.charAt(length - 1);
        if ((c == 'D' || c == 'd' || c == 'F' || c == 'f') && --length == 0) {
            throw StringToReal.invalidReal(s, isDouble);
        }
        int end = Math.max(s.indexOf(69), s.indexOf(101));
        if (end == -1) {
            end = length;
        } else {
            String exponentString;
            if (end + 1 == length) {
                throw StringToReal.invalidReal(s, isDouble);
            }
            int exponentOffset = end + 1;
            boolean negativeExponent = false;
            char firstExponentChar = s.charAt(exponentOffset);
            if (firstExponentChar == '+' || firstExponentChar == '-') {
                negativeExponent = firstExponentChar == '-';
                ++exponentOffset;
            }
            if ((exponentString = s.substring(exponentOffset, length)).isEmpty()) {
                throw StringToReal.invalidReal(s, isDouble);
            }
            for (int i = 0; i < exponentString.length(); ++i) {
                char ch = exponentString.charAt(i);
                if (ch < '0') throw StringToReal.invalidReal(s, isDouble);
                if (ch <= '9') continue;
                throw StringToReal.invalidReal(s, isDouble);
            }
            try {
                result.e = Integer.parseInt(exponentString);
                if (negativeExponent) {
                    result.e = -result.e;
                }
            }
            catch (NumberFormatException ex) {
                if (negativeExponent) {
                    result.zero = true;
                    return result;
                }
                result.infinity = true;
                return result;
            }
        }
        if (length == 0) {
            throw StringToReal.invalidReal(s, isDouble);
        }
        int start = 0;
        c = s.charAt(start);
        if (c == '-') {
            ++start;
            --length;
            result.negative = true;
        } else if (c == '+') {
            ++start;
            --length;
        }
        if (length == 0) {
            throw StringToReal.invalidReal(s, isDouble);
        }
        int decimal = s.indexOf(46);
        if (decimal > -1) {
            result.e -= (long)(end - decimal - 1);
            s = s.substring(start, decimal) + s.substring(decimal + 1, end);
        } else {
            s = s.substring(start, end);
        }
        length = s.length();
        if (length == 0) {
            throw StringToReal.invalidReal(s, isDouble);
        }
        for (end = length; end > 1 && s.charAt(end - 1) == '0'; --end) {
        }
        for (start = 0; start < end - 1 && s.charAt(start) == '0'; ++start) {
        }
        if (end != length || start != 0) {
            result.e += (long)(length - end);
            s = s.substring(start, end);
        }
        int APPROX_MIN_MAGNITUDE = -359;
        int MAX_DIGITS = 52;
        length = s.length();
        if (length > 52 && result.e < -359L) {
            int d = Math.min(-359 - (int)result.e, length - 1);
            s = s.substring(0, length - d);
            result.e += (long)d;
        }
        if (result.e < -1024L) {
            result.zero = true;
            return result;
        }
        if (result.e > 1024L) {
            result.infinity = true;
            return result;
        }
        result.s = s;
        return result;
    }

    private static float parseName(String name, boolean isDouble) {
        boolean negative = false;
        int i = 0;
        int length = name.length();
        char firstChar = name.charAt(i);
        if (firstChar == '-') {
            negative = true;
            ++i;
            --length;
        } else if (firstChar == '+') {
            ++i;
            --length;
        }
        if (length == 8 && name.regionMatches(false, i, "Infinity", 0, 8)) {
            return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (length == 3 && name.regionMatches(false, i, "NaN", 0, 3)) {
            return Float.NaN;
        }
        throw StringToReal.invalidReal(name, isDouble);
    }

    public static double parseDouble(String s) {
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw StringToReal.invalidReal(s, true);
        }
        char last = s.charAt(length - 1);
        if (last == 'y' || last == 'N') {
            return StringToReal.parseName(s, true);
        }
        if (s.indexOf("0x") != -1 || s.indexOf("0X") != -1) {
            return HexStringParser.parseDouble(s);
        }
        StringExponentPair info = StringToReal.initialParse(s, length, true);
        if (info.infinity || info.zero) {
            return info.specialValue();
        }
        double result = StringToReal.parseDblImpl(info.s, (int)info.e);
        if (Double.doubleToRawLongBits(result) == -1L) {
            throw StringToReal.invalidReal(s, true);
        }
        return info.negative ? -result : result;
    }

    public static float parseFloat(String s) {
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw StringToReal.invalidReal(s, false);
        }
        char last = s.charAt(length - 1);
        if (last == 'y' || last == 'N') {
            return StringToReal.parseName(s, false);
        }
        if (s.indexOf("0x") != -1 || s.indexOf("0X") != -1) {
            return HexStringParser.parseFloat(s);
        }
        StringExponentPair info = StringToReal.initialParse(s, length, false);
        if (info.infinity || info.zero) {
            return info.specialValue();
        }
        float result = StringToReal.parseFltImpl(info.s, (int)info.e);
        if (Float.floatToRawIntBits(result) == -1) {
            throw StringToReal.invalidReal(s, false);
        }
        return info.negative ? -result : result;
    }

    private static final class StringExponentPair {
        String s;
        long e;
        boolean negative;
        boolean infinity;
        boolean zero;

        private StringExponentPair() {
        }

        public float specialValue() {
            if (this.infinity) {
                return this.negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            return this.negative ? -0.0f : 0.0f;
        }
    }
}

