/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable,
Map<K, V> {
    private static final long serialVersionUID = 458661240069192865L;
    private Class<K> keyType;
    transient Enum[] keys;
    transient Object[] values;
    transient boolean[] hasMapping;
    private transient int mappingsCount;
    transient int enumSize;
    private transient EnumMapEntrySet<K, V> entrySet = null;

    public EnumMap(Class<K> keyType) {
        this.initialization(keyType);
    }

    public EnumMap(EnumMap<K, ? extends V> map) {
        this.initialization(map);
    }

    public EnumMap(Map<K, ? extends V> map) {
        if (map instanceof EnumMap) {
            this.initialization((EnumMap)map);
        } else {
            if (map.isEmpty()) {
                throw new IllegalArgumentException("map is empty");
            }
            Iterator<K> iter = map.keySet().iterator();
            Enum enumKey = (Enum)iter.next();
            Class<?> clazz = enumKey.getClass();
            if (clazz.isEnum()) {
                this.initialization(clazz);
            } else {
                this.initialization(clazz.getSuperclass());
            }
            this.putAllImpl(map);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        Arrays.fill(this.hasMapping, false);
        this.mappingsCount = 0;
    }

    @Override
    public EnumMap<K, V> clone() {
        try {
            EnumMap enumMap = (EnumMap)super.clone();
            enumMap.initialization(this);
            return enumMap;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.isValidKeyType(key)) {
            int keyOrdinal = ((Enum)key).ordinal();
            return this.hasMapping[keyOrdinal];
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.enumSize; ++i) {
                if (!this.hasMapping[i] || this.values[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.enumSize; ++i) {
                if (!this.hasMapping[i] || !value.equals(this.values[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EnumMapEntrySet(this);
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EnumMap)) {
            return super.equals(object);
        }
        EnumMap enumMap = (EnumMap)object;
        if (this.keyType != enumMap.keyType || this.size() != enumMap.size()) {
            return false;
        }
        return Arrays.equals(this.hasMapping, enumMap.hasMapping) && Arrays.equals(this.values, enumMap.values);
    }

    @Override
    public V get(Object key) {
        if (!this.isValidKeyType(key)) {
            return null;
        }
        int keyOrdinal = ((Enum)key).ordinal();
        return (V)this.values[keyOrdinal];
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new EnumMapKeySet(this);
        }
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllImpl(map);
    }

    @Override
    public V remove(Object key) {
        if (!this.isValidKeyType(key)) {
            return null;
        }
        int keyOrdinal = ((Enum)key).ordinal();
        if (this.hasMapping[keyOrdinal]) {
            this.hasMapping[keyOrdinal] = false;
            --this.mappingsCount;
        }
        Object oldValue = this.values[keyOrdinal];
        this.values[keyOrdinal] = null;
        return (V)oldValue;
    }

    @Override
    public int size() {
        return this.mappingsCount;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new EnumMapValueCollection(this);
        }
        return this.valuesCollection;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int elementCount;
        stream.defaultReadObject();
        this.initialization(this.keyType);
        for (int i = elementCount = stream.readInt(); i > 0; --i) {
            Enum enumKey = (Enum)stream.readObject();
            Object value = stream.readObject();
            this.putImpl(enumKey, value);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.mappingsCount);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    private boolean isValidKeyType(Object key) {
        return key != null && this.keyType.isInstance(key);
    }

    private void initialization(EnumMap enumMap) {
        this.keyType = enumMap.keyType;
        this.keys = enumMap.keys;
        this.enumSize = enumMap.enumSize;
        this.values = (Object[])enumMap.values.clone();
        this.hasMapping = (boolean[])enumMap.hasMapping.clone();
        this.mappingsCount = enumMap.mappingsCount;
    }

    private void initialization(Class<K> type) {
        this.keyType = type;
        this.keys = Enum.getSharedConstants(this.keyType);
        this.enumSize = this.keys.length;
        this.values = new Object[this.enumSize];
        this.hasMapping = new boolean[this.enumSize];
    }

    private void putAllImpl(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.putImpl((Enum)entry.getKey(), entry.getValue());
        }
    }

    private V putImpl(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.keyType.cast(key);
        int keyOrdinal = ((Enum)key).ordinal();
        if (!this.hasMapping[keyOrdinal]) {
            this.hasMapping[keyOrdinal] = true;
            ++this.mappingsCount;
        }
        Object oldValue = this.values[keyOrdinal];
        this.values[keyOrdinal] = value;
        return (V)oldValue;
    }

    private static class EnumMapEntrySet<KT extends Enum<KT>, VT>
    extends AbstractSet<Map.Entry<KT, VT>> {
        private final EnumMap<KT, VT> enumMap;

        EnumMapEntrySet(EnumMap<KT, VT> em) {
            this.enumMap = em;
        }

        @Override
        public void clear() {
            this.enumMap.clear();
        }

        @Override
        public boolean contains(Object object) {
            boolean isEqual = false;
            if (object instanceof Map.Entry) {
                Object enumKey = ((Map.Entry)object).getKey();
                Object enumValue = ((Map.Entry)object).getValue();
                if (this.enumMap.containsKey(enumKey)) {
                    VT value = this.enumMap.get(enumKey);
                    isEqual = value == null ? enumValue == null : value.equals(enumValue);
                }
            }
            return isEqual;
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new EnumMapEntryIterator(new MapEntry.Type<Map.Entry<KT, VT>, KT, VT>(){

                @Override
                public Map.Entry<KT, VT> get(MapEntry<KT, VT> entry) {
                    return entry;
                }
            }, this.enumMap);
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.enumMap.remove(((Map.Entry)object).getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.enumMap.size();
        }

        @Override
        public Object[] toArray() {
            Object[] entryArray = new Object[this.enumMap.size()];
            return this.toArray(entryArray);
        }

        @Override
        public Object[] toArray(Object[] array) {
            int size = this.enumMap.size();
            int index = 0;
            Object[] entryArray = array;
            if (size > array.length) {
                Class<?> clazz = array.getClass().getComponentType();
                entryArray = (Object[])Array.newInstance(clazz, size);
            }
            Iterator<Map.Entry<KT, VT>> iter = this.iterator();
            while (index < size) {
                Map.Entry<KT, VT> entry = iter.next();
                entryArray[index] = new MapEntry<Enum, VT>((Enum)entry.getKey(), entry.getValue());
                ++index;
            }
            if (index < array.length) {
                entryArray[index] = null;
            }
            return entryArray;
        }
    }

    private static class EnumMapKeySet<KT extends Enum<KT>, VT>
    extends AbstractSet<KT> {
        private final EnumMap<KT, VT> enumMap;

        EnumMapKeySet(EnumMap<KT, VT> em) {
            this.enumMap = em;
        }

        @Override
        public void clear() {
            this.enumMap.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.enumMap.containsKey(object);
        }

        @Override
        public Iterator iterator() {
            return new EnumMapIterator(new MapEntry.Type<KT, KT, VT>(){

                @Override
                public KT get(MapEntry<KT, VT> entry) {
                    return (Enum)entry.key;
                }
            }, this.enumMap);
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.enumMap.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.enumMap.size();
        }
    }

    private static class EnumMapValueCollection<KT extends Enum<KT>, VT>
    extends AbstractCollection<VT> {
        private final EnumMap<KT, VT> enumMap;

        EnumMapValueCollection(EnumMap<KT, VT> em) {
            this.enumMap = em;
        }

        @Override
        public void clear() {
            this.enumMap.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.enumMap.containsValue(object);
        }

        @Override
        public Iterator iterator() {
            return new EnumMapIterator(new MapEntry.Type<VT, KT, VT>(){

                @Override
                public VT get(MapEntry<KT, VT> entry) {
                    return entry.value;
                }
            }, this.enumMap);
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                for (int i = 0; i < this.enumMap.enumSize; ++i) {
                    if (!this.enumMap.hasMapping[i] || this.enumMap.values[i] != null) continue;
                    this.enumMap.remove(this.enumMap.keys[i]);
                    return true;
                }
            } else {
                for (int i = 0; i < this.enumMap.enumSize; ++i) {
                    if (!this.enumMap.hasMapping[i] || !object.equals(this.enumMap.values[i])) continue;
                    this.enumMap.remove(this.enumMap.keys[i]);
                    return true;
                }
            }
            return false;
        }

        @Override
        public int size() {
            return this.enumMap.size();
        }
    }

    private static class EnumMapEntryIterator<E, KT extends Enum<KT>, VT>
    extends EnumMapIterator<E, KT, VT> {
        EnumMapEntryIterator(MapEntry.Type<E, KT, VT> value, EnumMap<KT, VT> em) {
            super(value, em);
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prePosition = this.position++;
            return (E)this.type.get(new Entry<Enum, Object>(this.enumMap.keys[this.prePosition], this.enumMap.values[this.prePosition], this.enumMap));
        }
    }

    private static class EnumMapIterator<E, KT extends Enum<KT>, VT>
    implements Iterator<E> {
        int position = 0;
        int prePosition = -1;
        final EnumMap<KT, VT> enumMap;
        final MapEntry.Type<E, KT, VT> type;

        EnumMapIterator(MapEntry.Type<E, KT, VT> value, EnumMap<KT, VT> em) {
            this.enumMap = em;
            this.type = value;
        }

        @Override
        public boolean hasNext() {
            int length = this.enumMap.enumSize;
            while (this.position < length && !this.enumMap.hasMapping[this.position]) {
                ++this.position;
            }
            return this.position != length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prePosition = this.position++;
            return this.type.get(new MapEntry<Enum, Object>(this.enumMap.keys[this.prePosition], this.enumMap.values[this.prePosition]));
        }

        @Override
        public void remove() {
            this.checkStatus();
            if (this.enumMap.hasMapping[this.prePosition]) {
                this.enumMap.remove(this.enumMap.keys[this.prePosition]);
            }
            this.prePosition = -1;
        }

        public String toString() {
            if (-1 == this.prePosition) {
                return super.toString();
            }
            return this.type.get(new MapEntry<Enum, Object>(this.enumMap.keys[this.prePosition], this.enumMap.values[this.prePosition])).toString();
        }

        private void checkStatus() {
            if (-1 == this.prePosition) {
                throw new IllegalStateException();
            }
        }
    }

    private static class Entry<KT extends Enum<KT>, VT>
    extends MapEntry<KT, VT> {
        private final EnumMap<KT, VT> enumMap;
        private final int ordinal;

        Entry(KT theKey, VT theValue, EnumMap<KT, VT> em) {
            super(theKey, theValue);
            this.enumMap = em;
            this.ordinal = ((Enum)theKey).ordinal();
        }

        @Override
        public boolean equals(Object object) {
            Map.Entry entry;
            Object enumKey;
            if (!this.enumMap.hasMapping[this.ordinal]) {
                return false;
            }
            boolean isEqual = false;
            if (object instanceof Map.Entry && ((Enum)this.key).equals(enumKey = (entry = (Map.Entry)object).getKey())) {
                Object theValue = entry.getValue();
                isEqual = this.enumMap.values[this.ordinal] == null ? theValue == null : this.enumMap.values[this.ordinal].equals(theValue);
            }
            return isEqual;
        }

        @Override
        public int hashCode() {
            return (this.enumMap.keys[this.ordinal] == null ? 0 : this.enumMap.keys[this.ordinal].hashCode()) ^ (this.enumMap.values[this.ordinal] == null ? 0 : this.enumMap.values[this.ordinal].hashCode());
        }

        @Override
        public KT getKey() {
            this.checkEntryStatus();
            return (KT)this.enumMap.keys[this.ordinal];
        }

        @Override
        public VT getValue() {
            this.checkEntryStatus();
            return (VT)this.enumMap.values[this.ordinal];
        }

        @Override
        public VT setValue(VT value) {
            this.checkEntryStatus();
            return this.enumMap.put((KT)this.enumMap.keys[this.ordinal], value);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(this.enumMap.keys[this.ordinal].toString());
            result.append("=");
            result.append(this.enumMap.values[this.ordinal] == null ? "null" : this.enumMap.values[this.ordinal].toString());
            return result.toString();
        }

        private void checkEntryStatus() {
            if (!this.enumMap.hasMapping[this.ordinal]) {
                throw new IllegalStateException();
            }
        }
    }
}

