/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public abstract class AbstractQueuedLongSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414692L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile long state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;
    private static final long nextOffset;

    protected AbstractQueuedLongSynchronizer() {
    }

    protected final long getState() {
        return this.state;
    }

    protected final void setState(long newState) {
        this.state = newState;
    }

    protected final boolean compareAndSetState(long expect, long update) {
        return unsafe.compareAndSwapLong(this, stateOffset, expect, update);
    }

    private Node enq(Node node) {
        Node t;
        while (true) {
            if ((t = this.tail) == null) {
                if (!this.compareAndSetHead(new Node())) continue;
                this.tail = this.head;
                continue;
            }
            node.prev = t;
            if (this.compareAndSetTail(t, node)) break;
        }
        t.next = node;
        return t;
    }

    private Node addWaiter(Node mode) {
        Node node = new Node(Thread.currentThread(), mode);
        Node pred = this.tail;
        if (pred != null) {
            node.prev = pred;
            if (this.compareAndSetTail(pred, node)) {
                pred.next = node;
                return node;
            }
        }
        this.enq(node);
        return node;
    }

    private void setHead(Node node) {
        this.head = node;
        node.thread = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        Node s;
        int ws = node.waitStatus;
        if (ws < 0) {
            AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, ws, 0);
        }
        if ((s = node.next) == null || s.waitStatus > 0) {
            s = null;
            Node t = this.tail;
            while (t != null && t != node) {
                if (t.waitStatus <= 0) {
                    s = t;
                }
                t = t.prev;
            }
        }
        if (s != null) {
            LockSupport.unpark(s.thread);
        }
    }

    private void doReleaseShared() {
        while (true) {
            Node h;
            if ((h = this.head) != null && h != this.tail) {
                int ws = h.waitStatus;
                if (ws == -1) {
                    if (!AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(h, -1, 0)) continue;
                    this.unparkSuccessor(h);
                } else if (ws == 0 && !AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(h, 0, -3)) continue;
            }
            if (h == this.head) break;
        }
    }

    private void setHeadAndPropagate(Node node, long propagate) {
        Node s;
        Node h = this.head;
        this.setHead(node);
        if (!(propagate <= 0L && h != null && h.waitStatus >= 0 || (s = node.next) != null && !s.isShared())) {
            this.doReleaseShared();
        }
    }

    private void cancelAcquire(Node node) {
        if (node == null) {
            return;
        }
        node.thread = null;
        Node pred = node.prev;
        while (pred.waitStatus > 0) {
            node.prev = pred = pred.prev;
        }
        Node predNext = pred.next;
        node.waitStatus = 1;
        if (node == this.tail && this.compareAndSetTail(node, pred)) {
            AbstractQueuedLongSynchronizer.compareAndSetNext(pred, predNext, null);
        } else {
            int ws;
            if (pred != this.head && ((ws = pred.waitStatus) == -1 || ws <= 0 && AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(pred, ws, -1)) && pred.thread != null) {
                Node next = node.next;
                if (next != null && next.waitStatus <= 0) {
                    AbstractQueuedLongSynchronizer.compareAndSetNext(pred, predNext, next);
                }
            } else {
                this.unparkSuccessor(node);
            }
            node.next = node;
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node pred, Node node) {
        int ws = pred.waitStatus;
        if (ws == -1) {
            return true;
        }
        if (ws > 0) {
            do {
                node.prev = pred = pred.prev;
            } while (pred.waitStatus > 0);
            pred.next = node;
        } else {
            AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(pred, ws, -1);
        }
        return false;
    }

    static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park(this);
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node, long arg) {
        boolean failed = true;
        try {
            boolean interrupted = false;
            while (true) {
                Node p;
                if ((p = node.predecessor()) == this.head && this.tryAcquire(arg)) {
                    this.setHead(node);
                    p.next = null;
                    failed = false;
                    boolean bl = interrupted;
                    return bl;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        finally {
            if (failed) {
                this.cancelAcquire(node);
            }
        }
    }

    private void doAcquireInterruptibly(long arg) throws InterruptedException {
        Node node = this.addWaiter(Node.EXCLUSIVE);
        boolean failed = true;
        try {
            Node p;
            do {
                if ((p = node.predecessor()) != this.head || !this.tryAcquire(arg)) continue;
                this.setHead(node);
                p.next = null;
                failed = false;
                return;
            } while (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt());
            throw new InterruptedException();
        }
        finally {
            if (failed) {
                this.cancelAcquire(node);
            }
        }
    }

    private boolean doAcquireNanos(long arg, long nanosTimeout) throws InterruptedException {
        if (nanosTimeout <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + nanosTimeout;
        Node node = this.addWaiter(Node.EXCLUSIVE);
        boolean failed = true;
        try {
            do {
                Node p;
                if ((p = node.predecessor()) == this.head && this.tryAcquire(arg)) {
                    this.setHead(node);
                    p.next = null;
                    failed = false;
                    boolean bl = true;
                    return bl;
                }
                nanosTimeout = deadline - System.nanoTime();
                if (nanosTimeout <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(p, node) || nanosTimeout <= 1000L) continue;
                LockSupport.parkNanos(this, nanosTimeout);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
        finally {
            if (failed) {
                this.cancelAcquire(node);
            }
        }
    }

    private void doAcquireShared(long arg) {
        Node node = this.addWaiter(Node.SHARED);
        boolean failed = true;
        try {
            boolean interrupted = false;
            while (true) {
                long r;
                Node p;
                if ((p = node.predecessor()) == this.head && (r = this.tryAcquireShared(arg)) >= 0L) {
                    this.setHeadAndPropagate(node, r);
                    p.next = null;
                    if (interrupted) {
                        AbstractQueuedLongSynchronizer.selfInterrupt();
                    }
                    failed = false;
                    return;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        finally {
            if (failed) {
                this.cancelAcquire(node);
            }
        }
    }

    private void doAcquireSharedInterruptibly(long arg) throws InterruptedException {
        Node node = this.addWaiter(Node.SHARED);
        boolean failed = true;
        try {
            Node p;
            do {
                long r;
                if ((p = node.predecessor()) != this.head || (r = this.tryAcquireShared(arg)) < 0L) continue;
                this.setHeadAndPropagate(node, r);
                p.next = null;
                failed = false;
                return;
            } while (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(p, node) || !this.parkAndCheckInterrupt());
            throw new InterruptedException();
        }
        finally {
            if (failed) {
                this.cancelAcquire(node);
            }
        }
    }

    private boolean doAcquireSharedNanos(long arg, long nanosTimeout) throws InterruptedException {
        if (nanosTimeout <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + nanosTimeout;
        Node node = this.addWaiter(Node.SHARED);
        boolean failed = true;
        try {
            do {
                long r;
                Node p;
                if ((p = node.predecessor()) == this.head && (r = this.tryAcquireShared(arg)) >= 0L) {
                    this.setHeadAndPropagate(node, r);
                    p.next = null;
                    failed = false;
                    boolean bl = true;
                    return bl;
                }
                nanosTimeout = deadline - System.nanoTime();
                if (nanosTimeout <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(p, node) || nanosTimeout <= 1000L) continue;
                LockSupport.parkNanos(this, nanosTimeout);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
        finally {
            if (failed) {
                this.cancelAcquire(node);
            }
        }
    }

    protected boolean tryAcquire(long arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(long arg) {
        throw new UnsupportedOperationException();
    }

    protected long tryAcquireShared(long arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(long arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(long arg) {
        if (!this.tryAcquire(arg) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), arg)) {
            AbstractQueuedLongSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(long arg) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquire(arg)) {
            this.doAcquireInterruptibly(arg);
        }
    }

    public final boolean tryAcquireNanos(long arg, long nanosTimeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquire(arg) || this.doAcquireNanos(arg, nanosTimeout);
    }

    public final boolean release(long arg) {
        if (this.tryRelease(arg)) {
            Node h = this.head;
            if (h != null && h.waitStatus != 0) {
                this.unparkSuccessor(h);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(long arg) {
        if (this.tryAcquireShared(arg) < 0L) {
            this.doAcquireShared(arg);
        }
    }

    public final void acquireSharedInterruptibly(long arg) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.tryAcquireShared(arg) < 0L) {
            this.doAcquireSharedInterruptibly(arg);
        }
    }

    public final boolean tryAcquireSharedNanos(long arg, long nanosTimeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireShared(arg) >= 0L || this.doAcquireSharedNanos(arg, nanosTimeout);
    }

    public final boolean releaseShared(long arg) {
        if (this.tryReleaseShared(arg)) {
            this.doReleaseShared();
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        return this.head != this.tail;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Thread st;
        Node s;
        Node h = this.head;
        if (h != null && (s = h.next) != null && s.prev == this.head && (st = s.thread) != null || (h = this.head) != null && (s = h.next) != null && s.prev == this.head && (st = s.thread) != null) {
            return st;
        }
        Node t = this.tail;
        Thread firstThread = null;
        while (t != null && t != this.head) {
            Thread tt = t.thread;
            if (tt != null) {
                firstThread = tt;
            }
            t = t.prev;
        }
        return firstThread;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node p = this.tail;
        while (p != null) {
            if (p.thread == thread) {
                return true;
            }
            p = p.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node s;
        Node h = this.head;
        return h != null && (s = h.next) != null && !s.isShared() && s.thread != null;
    }

    public final boolean hasQueuedPredecessors() {
        Node s;
        Node h = this.head;
        Node t = this.tail;
        return h != t && ((s = h.next) == null || s.thread != Thread.currentThread());
    }

    public final int getQueueLength() {
        int n = 0;
        Node p = this.tail;
        while (p != null) {
            if (p.thread != null) {
                ++n;
            }
            p = p.prev;
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t = p.thread;
            if (t != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t;
            if (!p.isShared() && (t = p.thread) != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t;
            if (p.isShared() && (t = p.thread) != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public String toString() {
        long s = this.getState();
        String q = this.hasQueuedThreads() ? "non" : "";
        return super.toString() + "[State = " + s + ", " + q + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node) {
        if (node.waitStatus == -2 || node.prev == null) {
            return false;
        }
        if (node.next != null) {
            return true;
        }
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node t = this.tail;
        while (t != node) {
            if (t == null) {
                return false;
            }
            t = t.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node) {
        if (!AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            return false;
        }
        Node p = this.enq(node);
        int ws = p.waitStatus;
        if (ws > 0 || !AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(p, ws, -1)) {
            LockSupport.unpark(node.thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node) {
        if (AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            this.enq(node);
            return true;
        }
        while (!this.isOnSyncQueue(node)) {
            Thread.yield();
        }
        return false;
    }

    final long fullyRelease(Node node) {
        boolean failed = true;
        try {
            long savedState = this.getState();
            if (this.release(savedState)) {
                failed = false;
                long l = savedState;
                return l;
            }
            throw new IllegalMonitorStateException();
        }
        finally {
            if (failed) {
                node.waitStatus = 1;
            }
        }
    }

    public final boolean owns(ConditionObject condition) {
        return condition.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node update) {
        return unsafe.compareAndSwapObject(this, headOffset, null, update);
    }

    private final boolean compareAndSetTail(Node expect, Node update) {
        return unsafe.compareAndSwapObject(this, tailOffset, expect, update);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int expect, int update) {
        return unsafe.compareAndSwapInt(node, waitStatusOffset, expect, update);
    }

    private static final boolean compareAndSetNext(Node node, Node expect, Node update) {
        return unsafe.compareAndSwapObject(node, nextOffset, expect, update);
    }

    static {
        try {
            stateOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("state"));
            headOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("head"));
            tailOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("tail"));
            waitStatusOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("waitStatus"));
            nextOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("next"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    static final class Node {
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final int PROPAGATE = -3;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node p = this.prev;
            if (p == null) {
                throw new NullPointerException();
            }
            return p;
        }

        Node() {
        }

        Node(Thread thread, Node mode) {
            this.nextWaiter = mode;
            this.thread = thread;
        }

        Node(Thread thread, int waitStatus) {
            this.waitStatus = waitStatus;
            this.thread = thread;
        }
    }

    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;

        private Node addConditionWaiter() {
            Node t = this.lastWaiter;
            if (t != null && t.waitStatus != -2) {
                this.unlinkCancelledWaiters();
                t = this.lastWaiter;
            }
            Node node = new Node(Thread.currentThread(), -2);
            if (t == null) {
                this.firstWaiter = node;
            } else {
                t.nextWaiter = node;
            }
            this.lastWaiter = node;
            return node;
        }

        private void doSignal(Node first) {
            do {
                if ((this.firstWaiter = first.nextWaiter) == null) {
                    this.lastWaiter = null;
                }
                first.nextWaiter = null;
            } while (!AbstractQueuedLongSynchronizer.this.transferForSignal(first) && (first = this.firstWaiter) != null);
        }

        private void doSignalAll(Node first) {
            Node next;
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                next = first.nextWaiter;
                first.nextWaiter = null;
                AbstractQueuedLongSynchronizer.this.transferForSignal(first);
            } while ((first = next) != null);
        }

        private void unlinkCancelledWaiters() {
            Node t = this.firstWaiter;
            Node trail = null;
            while (t != null) {
                Node next = t.nextWaiter;
                if (t.waitStatus != -2) {
                    t.nextWaiter = null;
                    if (trail == null) {
                        this.firstWaiter = next;
                    } else {
                        trail.nextWaiter = next;
                    }
                    if (next == null) {
                        this.lastWaiter = trail;
                    }
                } else {
                    trail = t;
                }
                t = next;
            }
        }

        @Override
        public final void signal() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node first = this.firstWaiter;
            if (first != null) {
                this.doSignal(first);
            }
        }

        @Override
        public final void signalAll() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node first = this.firstWaiter;
            if (first != null) {
                this.doSignalAll(first);
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            Node node = this.addConditionWaiter();
            long savedState = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            boolean interrupted = false;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                LockSupport.park(this);
                if (!Thread.interrupted()) continue;
                interrupted = true;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, savedState) || interrupted) {
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }

        private int checkInterruptWhileWaiting(Node node) {
            return Thread.interrupted() ? (AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node) ? -1 : 1) : 0;
        }

        private void reportInterruptAfterWait(int interruptMode) throws InterruptedException {
            if (interruptMode == -1) {
                throw new InterruptedException();
            }
            if (interruptMode == 1) {
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            long savedState = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            int interruptMode = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                LockSupport.park(this);
                interruptMode = this.checkInterruptWhileWaiting(node);
                if (interruptMode == 0) continue;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, savedState) && interruptMode != -1) {
                interruptMode = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (interruptMode != 0) {
                this.reportInterruptAfterWait(interruptMode);
            }
        }

        @Override
        public final long awaitNanos(long nanosTimeout) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            long savedState = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            long deadline = System.nanoTime() + nanosTimeout;
            int interruptMode = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                if (nanosTimeout <= 0L) {
                    AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                if (nanosTimeout >= 1000L) {
                    LockSupport.parkNanos(this, nanosTimeout);
                }
                if ((interruptMode = this.checkInterruptWhileWaiting(node)) != 0) break;
                nanosTimeout = deadline - System.nanoTime();
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, savedState) && interruptMode != -1) {
                interruptMode = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (interruptMode != 0) {
                this.reportInterruptAfterWait(interruptMode);
            }
            return deadline - System.nanoTime();
        }

        @Override
        public final boolean awaitUntil(Date deadline) throws InterruptedException {
            long abstime = deadline.getTime();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            long savedState = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            boolean timedout = false;
            int interruptMode = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                if (System.currentTimeMillis() > abstime) {
                    timedout = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkUntil(this, abstime);
                interruptMode = this.checkInterruptWhileWaiting(node);
                if (interruptMode == 0) continue;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, savedState) && interruptMode != -1) {
                interruptMode = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (interruptMode != 0) {
                this.reportInterruptAfterWait(interruptMode);
            }
            return !timedout;
        }

        @Override
        public final boolean await(long time, TimeUnit unit) throws InterruptedException {
            long nanosTimeout = unit.toNanos(time);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            long savedState = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            long deadline = System.nanoTime() + nanosTimeout;
            boolean timedout = false;
            int interruptMode = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                if (nanosTimeout <= 0L) {
                    timedout = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                if (nanosTimeout >= 1000L) {
                    LockSupport.parkNanos(this, nanosTimeout);
                }
                if ((interruptMode = this.checkInterruptWhileWaiting(node)) != 0) break;
                nanosTimeout = deadline - System.nanoTime();
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, savedState) && interruptMode != -1) {
                interruptMode = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (interruptMode != 0) {
                this.reportInterruptAfterWait(interruptMode);
            }
            return !timedout;
        }

        final boolean isOwnedBy(AbstractQueuedLongSynchronizer sync) {
            return sync == AbstractQueuedLongSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node w = this.firstWaiter;
            while (w != null) {
                if (w.waitStatus == -2) {
                    return true;
                }
                w = w.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n = 0;
            Node w = this.firstWaiter;
            while (w != null) {
                if (w.waitStatus == -2) {
                    ++n;
                }
                w = w.nextWaiter;
            }
            return n;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Thread> list = new ArrayList<Thread>();
            Node w = this.firstWaiter;
            while (w != null) {
                Thread t;
                if (w.waitStatus == -2 && (t = w.thread) != null) {
                    list.add(t);
                }
                w = w.nextWaiter;
            }
            return list;
        }
    }
}

