/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import libcore.util.EmptyArray;

public final class VM {
    private static HashMap<String, byte[]> runtimeData;

    public static native String bootClassPath();

    public static native String classPath();

    public static native String imagePath();

    public static native String resourcesPath();

    public static native String[] staticLibs();

    public static String vmVersion() {
        return "2.3.19";
    }

    public static final native Class<?>[] getStackClasses(int var0, int var1);

    public static final Class<?>[] listClasses(Class<?> assignableToClass, ClassLoader classLoader) {
        Class<?>[] result = VM.listClasses0(assignableToClass, classLoader);
        if (result == null) {
            return EmptyArray.CLASS;
        }
        return result;
    }

    public static final byte[] getRuntimeData(String id) {
        try {
            return VM.getRuntimeData0(id);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static final byte[] getRuntimeData0(String id) throws UnsupportedEncodingException {
        if (runtimeData == null) {
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            byte[] allData = VM.getRuntimeData0();
            if (allData != null) {
                ByteBuffer bb = ByteBuffer.wrap(allData).order(ByteOrder.nativeOrder());
                int pairCount = bb.getInt();
                for (int i = 0; i < pairCount; ++i) {
                    int keySize = bb.getInt();
                    String key = new String(allData, bb.position(), keySize, "UTF8");
                    bb.position(bb.position() + keySize);
                    int dataSize = bb.getInt();
                    byte[] data = new byte[dataSize];
                    bb.get(data);
                    map.put(key, data);
                }
            }
            runtimeData = map;
        }
        return runtimeData.get(id);
    }

    private static final native byte[] getRuntimeData0();

    private static final native Class<?>[] listClasses0(Class<?> var0, ClassLoader var1);

    public static final native void generateHeapDump();

    public static final native long allocateMemory(int var0);

    public static final native long allocateMemoryUncollectable(int var0);

    public static final native long allocateMemoryAtomic(int var0);

    public static final native long freeMemoryUncollectable(long var0);

    public static native void registerDisappearingLink(long var0, Object var2);

    public static native void unregisterDisappearingLink(long var0);

    public static final native long malloc(int var0);

    public static final native void free(long var0);

    public static final native <T> T allocateObject(Class<T> var0);

    public static final native ByteBuffer newDirectByteBuffer(long var0, long var2);

    public static final native void memcpy(long var0, long var2, long var4);

    public static final native void memmove8(long var0, long var2, long var4);

    public static final native void memmove16(long var0, long var2, long var4);

    public static final native void memmove32(long var0, long var2, long var4);

    public static final native void memmove64(long var0, long var2, long var4);

    public static final native void memset(long var0, byte var2, long var3);

    public static final native long getCallbackMethodImpl(Method var0);

    public static final native void bindBridgeMethod(Method var0, long var1);

    public static final native boolean isBridgeMethodBound(Method var0);

    public static final native long getObjectAddress(Object var0);

    public static final native Object castAddressToObject(long var0);

    public static final native long getFieldAddress(Field var0);

    public static final native int getInstanceFieldOffset(long var0);

    public static final native long getClassFieldAddress(long var0);

    public static final native Object getObject(long var0);

    public static final native double getDouble(long var0);

    public static final native float getFloat(long var0);

    public static final native long getLong(long var0);

    public static final native int getInt(long var0);

    public static final native char getChar(long var0);

    public static final native short getShort(long var0);

    public static final native byte getByte(long var0);

    public static final native boolean getBoolean(long var0);

    public static final native void setObject(long var0, Object var2);

    public static final native void setDouble(long var0, double var2);

    public static final native void setFloat(long var0, float var2);

    public static final native void setLong(long var0, long var2);

    public static final native void setInt(long var0, int var2);

    public static final native void setChar(long var0, char var2);

    public static final native void setShort(long var0, short var2);

    public static final native void setByte(long var0, byte var2);

    public static final native void setBoolean(long var0, boolean var2);

    public static final native long getPointer(long var0);

    public static final native void setPointer(long var0, long var2);

    public static final native long getStringUTFChars(String var0);

    public static final native String newStringUTF(long var0);

    public static final native String newStringNoCopy(char[] var0, int var1, int var2);

    public static final native long getArrayValuesAddress(Object var0);

    public static final native boolean[] newBooleanArray(long var0, int var2);

    public static final native byte[] newByteArray(long var0, int var2);

    public static final native char[] newCharArray(long var0, int var2);

    public static final native short[] newShortArray(long var0, int var2);

    public static final native int[] newIntArray(long var0, int var2);

    public static final native long[] newLongArray(long var0, int var2);

    public static final native float[] newFloatArray(long var0, int var2);

    public static final native double[] newDoubleArray(long var0, int var2);
}

