/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Dl;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

public final class Runtime {
    private static final String UNHIDDEN_SYMBOL_PREFIX = "_unhidden_";
    private static final Map<String, Long> handles = new HashMap<String, Long>();
    private static final List<String> searchPaths = Runtime.setupDyLdPaths();

    private static List<String> setupDyLdPaths() {
        String javaLibPath;
        String basePath;
        ArrayList<String> paths = new ArrayList<String>();
        String home = System.getProperty("user.home");
        if (Bro.IS_LINUX) {
            String ldLibPath = System.getenv("LD_LIBRARY_PATH");
            if (ldLibPath != null) {
                paths.addAll(Arrays.asList(ldLibPath.split(Pattern.quote(File.pathSeparator))));
            }
            File ldSoConf = new File("/etc/ld.so.conf");
            try {
                Runtime.readLdSoConf(ldSoConf, paths);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        if (Bro.IS_DARWIN) {
            String dyLdFallbackFwPath;
            String dyLdLibPath;
            String dyLdFwPath = System.getenv("DYLD_FRAMEWORK_PATH");
            if (dyLdFwPath != null) {
                paths.addAll(Arrays.asList(dyLdFwPath.split(Pattern.quote(File.pathSeparator))));
            }
            if ((dyLdLibPath = System.getenv("DYLD_LIBRARY_PATH")) != null) {
                paths.addAll(Arrays.asList(dyLdLibPath.split(Pattern.quote(File.pathSeparator))));
            }
            if ((dyLdFallbackFwPath = System.getenv("DYLD_FALLBACK_FRAMEWORK_PATH")) != null) {
                paths.addAll(Arrays.asList(dyLdFallbackFwPath.split(Pattern.quote(File.pathSeparator))));
            }
            if (home != null) {
                paths.add(new File(home, "Library/Frameworks").getAbsolutePath());
            }
            paths.add("/Library/Frameworks");
            paths.add("/Network/Library/Frameworks");
            paths.add("/System/Library/Frameworks");
            String dyLdFallbackLibPath = System.getenv("DYLD_FALLBACK_LIBRARY_PATH");
            if (dyLdFallbackLibPath != null) {
                paths.addAll(Arrays.asList(dyLdFallbackLibPath.split(Pattern.quote(File.pathSeparator))));
            }
            if (home != null) {
                paths.add(new File(home, "lib").getAbsolutePath());
            }
            if (Bro.IS_IOS) {
                paths.add("/System/iOSSupport/System/Library/Frameworks");
            }
        }
        if ((basePath = System.getProperty("org.robovm.base.path")) != null) {
            paths.add(basePath);
        }
        if ((javaLibPath = System.getProperty("java.library.path")) != null) {
            paths.addAll(Arrays.asList(javaLibPath.split(Pattern.quote(File.pathSeparator))));
        }
        paths.add("/usr/local/lib");
        paths.add("/lib");
        paths.add("/usr/lib");
        if (Bro.IS_DARWIN) {
            paths.add("/usr/lib/system");
            String dyLdRootPath = System.getenv("DYLD_ROOT_PATH");
            if (dyLdRootPath != null) {
                ArrayList<String> oldSearchPaths = new ArrayList<String>(paths);
                paths.clear();
                for (String root : dyLdRootPath.split(Pattern.quote(File.pathSeparator))) {
                    while (root.endsWith("/")) {
                        root = root.substring(0, root.length() - 1);
                    }
                    for (String path : oldSearchPaths) {
                        File f = new File(root + path);
                        String absPath = f.getAbsolutePath();
                        if (paths.contains(absPath) || !f.exists() || !f.isDirectory()) continue;
                        paths.add(absPath);
                    }
                }
                paths.addAll(oldSearchPaths);
            }
        }
        return Runtime.uniq(paths);
    }

    private static List<String> uniq(List<String> l) {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (String s : l) {
            if (seen.contains(s)) continue;
            result.add(s);
            seen.add(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readLdSoConf(File f, List<String> paths) throws IOException {
        if (!f.exists() || !f.isFile()) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("/")) {
                    paths.add(line);
                    continue;
                }
                if (!line.startsWith("include ") && !line.startsWith("include\t")) continue;
                String pattern = line.substring("include ".length()).trim();
                int wcIdx = pattern.indexOf(42);
                if (wcIdx != -1) {
                    File dir = new File(pattern.substring(0, wcIdx));
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    for (File child : dir.listFiles()) {
                        if (wcIdx != pattern.length() - 1 && !child.getName().endsWith(pattern.substring(wcIdx + 1))) continue;
                        Runtime.readLdSoConf(child, paths);
                    }
                    continue;
                }
                Runtime.readLdSoConf(new File(pattern), paths);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void addSearchPath(String path) {
        searchPaths.add(path);
    }

    public static void loadLibrary(String name) {
        Runtime.getHandle(name);
    }

    public static void loadLibrary(Library library) {
        Runtime.getHandle(library.value());
    }

    public static long resolveBridge(Library library, Bridge bridge, Method method) {
        long f;
        if (library == null) {
            throw new IllegalArgumentException("No @" + Library.class.getName() + " annotation found on class " + method.getDeclaringClass().getName());
        }
        long handle = Runtime.getHandle(library.value());
        String symbol = bridge.symbol();
        if (symbol == null || "".equals(symbol)) {
            symbol = method.getName();
        }
        if ((f = Dl.resolve(handle, symbol)) == 0L) {
            f = Dl.resolve(handle, UNHIDDEN_SYMBOL_PREFIX + symbol);
        }
        if (f == 0L && !bridge.optional()) {
            throw new UnsatisfiedLinkError("Failed to resolve native function '" + symbol + "' for method " + method + " with @Bridge annotation " + bridge + " in library " + library);
        }
        return f;
    }

    public static long resolveGlobalValue(Library library, GlobalValue globalValue, Method method) {
        long f;
        if (library == null) {
            throw new IllegalArgumentException("No @" + Library.class.getName() + " annotation found on class " + method.getDeclaringClass().getName());
        }
        long handle = Runtime.getHandle(library.value());
        String symbol = globalValue.symbol();
        if (symbol == null || "".equals(symbol)) {
            symbol = method.getName();
        }
        if ((f = Dl.resolve(handle, symbol)) == 0L) {
            f = Dl.resolve(handle, UNHIDDEN_SYMBOL_PREFIX + symbol);
        }
        if (f == 0L && !globalValue.optional()) {
            throw new UnsatisfiedLinkError("Failed to resolve symbol '" + symbol + "' for method " + method + " with @GlobalValue annotation " + globalValue + " in library " + library);
        }
        return f;
    }

    public static long resolveBridge(String libraryName, String symbol, Method method) {
        long handle = Runtime.getHandle(libraryName);
        long f = Dl.resolve(handle, symbol);
        if (f == 0L) {
            f = Dl.resolve(handle, UNHIDDEN_SYMBOL_PREFIX + symbol);
        }
        if (f == 0L) {
            throw new UnsatisfiedLinkError("Failed to resolve native function " + symbol + "for method " + method + " in library " + libraryName);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long getHandle(String name) {
        Map<String, Long> map = handles;
        synchronized (map) {
            Long handle = handles.get(name);
            if (handle == null) {
                if ("__internal__".equals(name)) {
                    handle = Dl.open(null);
                } else {
                    File fwDir;
                    String searchPath;
                    File f;
                    String libName = System.mapLibraryName(name);
                    Iterator<String> iterator = searchPaths.iterator();
                    while (!(!iterator.hasNext() || (f = new File(searchPath = iterator.next(), libName)).exists() && (handle = Long.valueOf(Dl.open(f.getAbsolutePath()))) != 0L || "libc.so".equals(libName) && ((f = new File(searchPath, "libc.so.6")).exists() && (handle = Long.valueOf(Dl.open(f.getAbsolutePath()))) != 0L || (f = new File(searchPath, "libc.so.6.1")).exists() && (handle = Long.valueOf(Dl.open(f.getAbsolutePath()))) != 0L) || Bro.IS_DARWIN && (fwDir = new File(searchPath, name + ".framework")).exists() && (handle = Long.valueOf(Dl.open((f = new File(fwDir, name)).getAbsolutePath()))) != 0L)) {
                    }
                    if ((handle == null || handle == 0L) && (handle = Long.valueOf(Dl.open(name))) == 0L && (handle = Long.valueOf(Dl.open(libName))) == 0L) {
                        iterator = searchPaths.iterator();
                        while (iterator.hasNext() && (handle = Long.valueOf(Dl.open(new File(searchPath = iterator.next(), libName).getAbsolutePath()))) == 0L) {
                        }
                    }
                }
                if (handle == null || handle == 0L) {
                    throw new UnsatisfiedLinkError("Library '" + name + "' not found");
                }
                handles.put(name, handle);
            }
            return handle;
        }
    }
}

