/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.bouncycastle.cms;

import com.android.org.bouncycastle.asn1.ASN1EncodableVector;
import com.android.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.android.org.bouncycastle.asn1.ASN1Set;
import com.android.org.bouncycastle.asn1.BEROctetString;
import com.android.org.bouncycastle.asn1.DERSet;
import com.android.org.bouncycastle.asn1.cms.AttributeTable;
import com.android.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.android.org.bouncycastle.asn1.cms.ContentInfo;
import com.android.org.bouncycastle.asn1.cms.SignedData;
import com.android.org.bouncycastle.asn1.cms.SignerInfo;
import com.android.org.bouncycastle.cms.CMSAbsentContent;
import com.android.org.bouncycastle.cms.CMSAttributeTableGenerator;
import com.android.org.bouncycastle.cms.CMSException;
import com.android.org.bouncycastle.cms.CMSProcessable;
import com.android.org.bouncycastle.cms.CMSProcessableByteArray;
import com.android.org.bouncycastle.cms.CMSSignedData;
import com.android.org.bouncycastle.cms.CMSSignedGenerator;
import com.android.org.bouncycastle.cms.CMSSignedHelper;
import com.android.org.bouncycastle.cms.CMSTypedData;
import com.android.org.bouncycastle.cms.CMSUtils;
import com.android.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import com.android.org.bouncycastle.cms.SignerInfoGenerator;
import com.android.org.bouncycastle.cms.SignerInformation;
import com.android.org.bouncycastle.cms.SignerInformationStore;
import com.android.org.bouncycastle.cms.SimpleAttributeTableGenerator;
import com.android.org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import com.android.org.bouncycastle.operator.ContentSigner;
import com.android.org.bouncycastle.operator.OperatorCreationException;
import com.android.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import com.android.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this.doAddSigner(key, cert, encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this.doAddSigner(key, subjectKeyID, encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttr, unsignedAttr);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.doAddSigner(key, cert, encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttr, unsignedAttr);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.doAddSigner(key, subjectKeyID, encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttrGen, unsignedAttrGen);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.doAddSigner(key, cert, encryptionOID, digestOID, signedAttrGen, unsignedAttrGen, null);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttrGen, unsignedAttrGen);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.doAddSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGen, unsignedAttrGen, null);
    }

    private void doAddSigner(PrivateKey key, Object signerIdentifier, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen, AttributeTable baseSignedTable) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, signerIdentifier, digestOID, encryptionOID, signedAttrGen, unsignedAttrGen, baseSignedTable));
    }

    public CMSSignedData generate(CMSProcessable content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, CMSUtils.getProvider(sigProvider));
    }

    public CMSSignedData generate(CMSProcessable content, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(content, false, sigProvider);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(eContentType, content, encapsulate, CMSUtils.getProvider(sigProvider), true);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(eContentType, content, encapsulate, sigProvider, true);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, String sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(eContentType, content, encapsulate, CMSUtils.getProvider(sigProvider), addDefaultAttributes);
    }

    public CMSSignedData generate(String eContentType, final CMSProcessable content, boolean encapsulate, Provider sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, CMSException {
        boolean isCounterSignature = eContentType == null;
        final ASN1ObjectIdentifier contentTypeOID = isCounterSignature ? null : new ASN1ObjectIdentifier(eContentType);
        for (SignerInf signer : this.signerInfs) {
            try {
                this.signerGens.add(signer.toSignerInfoGenerator(this.rand, sigProvider, addDefaultAttributes));
            }
            catch (OperatorCreationException e) {
                throw new CMSException("exception creating signerInf", e);
            }
            catch (IOException e) {
                throw new CMSException("exception encoding attributes", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
        }
        this.signerInfs.clear();
        if (content != null) {
            return this.generate(new CMSTypedData(){
                final /* synthetic */ CMSSignedDataGenerator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ASN1ObjectIdentifier getContentType() {
                    return contentTypeOID;
                }

                @Override
                public void write(OutputStream out) throws IOException, CMSException {
                    content.write(out);
                }

                @Override
                public Object getContent() {
                    return content.getContent();
                }
            }, encapsulate);
        }
        return this.generate(new CMSAbsentContent(contentTypeOID), encapsulate);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (content instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)content).getContentType().getId(), content, encapsulate, sigProvider);
        }
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        if (content instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)content).getContentType().getId(), content, encapsulate, sigProvider);
        }
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            signerInfos.add(signer.toASN1Structure());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        BEROctetString octs = null;
        if (content != null) {
            ByteArrayOutputStream bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, bOut);
            cOut = CMSUtils.getSafeOutputStream(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), e);
            }
            if (encapsulate) {
                octs = new BEROctetString(bOut.toByteArray());
            }
        }
        for (SignerInfoGenerator sGen : this.signerGens) {
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add(inf.getDigestAlgorithm());
            signerInfos.add(inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, sd);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signer.getSignature()), false, sigProvider).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signer.getSignature()), false, CMSUtils.getProvider(sigProvider)).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signer.getSignature()), false).getSignerInfos();
    }

    private class SignerInf {
        final PrivateKey key;
        final Object signerIdentifier;
        final String digestOID;
        final String encOID;
        final CMSAttributeTableGenerator sAttr;
        final CMSAttributeTableGenerator unsAttr;
        final AttributeTable baseSignedTable;

        SignerInf(PrivateKey key, Object signerIdentifier, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSignedTable) {
            this.key = key;
            this.signerIdentifier = signerIdentifier;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSignedTable;
        }

        SignerInfoGenerator toSignerInfoGenerator(SecureRandom random, Provider sigProvider, boolean addDefaultAttributes) throws IOException, CertificateEncodingException, CMSException, OperatorCreationException, NoSuchAlgorithmException {
            JcaContentSignerBuilder signerBuilder;
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new BcDigestCalculatorProvider());
            if (addDefaultAttributes) {
                builder.setSignedAttributeGenerator(this.sAttr);
            }
            builder.setDirectSignature(!addDefaultAttributes);
            builder.setUnsignedAttributeGenerator(this.unsAttr);
            try {
                signerBuilder = new JcaContentSignerBuilder(signatureName).setSecureRandom(random);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchAlgorithmException(e.getMessage());
            }
            if (sigProvider != null) {
                signerBuilder.setProvider(sigProvider);
            }
            ContentSigner contentSigner = signerBuilder.build(this.key);
            if (this.signerIdentifier instanceof X509Certificate) {
                return builder.build(contentSigner, (X509Certificate)this.signerIdentifier);
            }
            return builder.build(contentSigner, (byte[])this.signerIdentifier);
        }
    }
}

