/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.bouncycastle.operator.jcajce;

import com.android.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.android.org.bouncycastle.cert.X509CertificateHolder;
import com.android.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.android.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.android.org.bouncycastle.jcajce.NamedJcaJceHelper;
import com.android.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.android.org.bouncycastle.operator.ContentVerifier;
import com.android.org.bouncycastle.operator.ContentVerifierProvider;
import com.android.org.bouncycastle.operator.OperatorCreationException;
import com.android.org.bouncycastle.operator.OperatorStreamException;
import com.android.org.bouncycastle.operator.RawContentVerifier;
import com.android.org.bouncycastle.operator.RuntimeOperatorException;
import com.android.org.bouncycastle.operator.jcajce.OperatorHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class JcaContentVerifierProviderBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());

    public JcaContentVerifierProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentVerifierProviderBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public ContentVerifierProvider build(X509CertificateHolder certHolder) throws OperatorCreationException, CertificateException {
        return this.build(this.helper.convertCertificate(certHolder));
    }

    public ContentVerifierProvider build(final X509Certificate certificate) throws OperatorCreationException {
        JcaX509CertificateHolder certHolder;
        try {
            certHolder = new JcaX509CertificateHolder(certificate);
        }
        catch (CertificateEncodingException e) {
            throw new OperatorCreationException("cannot process certificate: " + e.getMessage(), e);
        }
        return new ContentVerifierProvider(){
            private SignatureOutputStream stream;
            final /* synthetic */ JcaContentVerifierProviderBuilder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasAssociatedCertificate() {
                return true;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    Signature sig = this.this$0.helper.createSignature(algorithm);
                    sig.initVerify(certificate.getPublicKey());
                    this.stream = this.this$0.new SignatureOutputStream(sig);
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException("exception on setup: " + e, e);
                }
                Signature rawSig = this.this$0.createRawSig(algorithm, certificate.getPublicKey());
                if (rawSig != null) {
                    return this.this$0.new RawSigVerifier(algorithm, this.stream, rawSig);
                }
                return this.this$0.new SigVerifier(algorithm, this.stream);
            }
        };
    }

    public ContentVerifierProvider build(final PublicKey publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){
            final /* synthetic */ JcaContentVerifierProviderBuilder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasAssociatedCertificate() {
                return false;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                SignatureOutputStream stream = this.this$0.createSignatureStream(algorithm, publicKey);
                Signature rawSig = this.this$0.createRawSig(algorithm, publicKey);
                if (rawSig != null) {
                    return this.this$0.new RawSigVerifier(algorithm, stream, rawSig);
                }
                return this.this$0.new SigVerifier(algorithm, stream);
            }
        };
    }

    private SignatureOutputStream createSignatureStream(AlgorithmIdentifier algorithm, PublicKey publicKey) throws OperatorCreationException {
        try {
            Signature sig = this.helper.createSignature(algorithm);
            sig.initVerify(publicKey);
            return new SignatureOutputStream(sig);
        }
        catch (GeneralSecurityException e) {
            throw new OperatorCreationException("exception on setup: " + e, e);
        }
    }

    private Signature createRawSig(AlgorithmIdentifier algorithm, PublicKey publicKey) {
        Signature rawSig;
        try {
            rawSig = this.helper.createRawSignature(algorithm);
            if (rawSig != null) {
                rawSig.initVerify(publicKey);
            }
        }
        catch (Exception e) {
            rawSig = null;
        }
        return rawSig;
    }

    private class SignatureOutputStream
    extends OutputStream {
        private Signature sig;

        SignatureOutputStream(Signature sig) {
            this.sig = sig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.sig.update(bytes, off, len);
            }
            catch (SignatureException e) {
                throw new OperatorStreamException("exception in content signer: " + e.getMessage(), e);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.sig.update(bytes);
            }
            catch (SignatureException e) {
                throw new OperatorStreamException("exception in content signer: " + e.getMessage(), e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.sig.update((byte)b);
            }
            catch (SignatureException e) {
                throw new OperatorStreamException("exception in content signer: " + e.getMessage(), e);
            }
        }

        boolean verify(byte[] expected) throws SignatureException {
            return this.sig.verify(expected);
        }
    }

    private class RawSigVerifier
    extends SigVerifier
    implements RawContentVerifier {
        private Signature rawSignature;

        RawSigVerifier(AlgorithmIdentifier algorithm, SignatureOutputStream stream, Signature rawSignature) {
            super(algorithm, stream);
            this.rawSignature = rawSignature;
        }

        @Override
        public boolean verify(byte[] digest, byte[] expected) {
            try {
                this.rawSignature.update(digest);
                return this.rawSignature.verify(expected);
            }
            catch (SignatureException e) {
                throw new RuntimeOperatorException("exception obtaining raw signature: " + e.getMessage(), e);
            }
        }
    }

    private class SigVerifier
    implements ContentVerifier {
        private SignatureOutputStream stream;
        private AlgorithmIdentifier algorithm;

        SigVerifier(AlgorithmIdentifier algorithm, SignatureOutputStream stream) {
            this.algorithm = algorithm;
            this.stream = stream;
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        @Override
        public boolean verify(byte[] expected) {
            try {
                return this.stream.verify(expected);
            }
            catch (SignatureException e) {
                throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
            }
        }
    }
}

