/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;

public class PipedWriter
extends Writer {
    private PipedReader destination;
    private boolean isClosed;

    public PipedWriter() {
    }

    public PipedWriter(PipedReader destination) throws IOException {
        super(destination);
        this.connect(destination);
    }

    @Override
    public void close() throws IOException {
        PipedReader reader = this.destination;
        if (reader != null) {
            reader.done();
            this.isClosed = true;
            this.destination = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PipedReader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader == null");
        }
        PipedReader pipedReader = reader;
        synchronized (pipedReader) {
            if (this.destination != null) {
                throw new IOException("Pipe already connected");
            }
            reader.establishConnection();
            this.lock = reader;
            this.destination = reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        PipedReader reader = this.destination;
        if (this.isClosed) {
            throw new IOException("Pipe is closed");
        }
        if (reader == null) {
            return;
        }
        PipedReader pipedReader = reader;
        synchronized (pipedReader) {
            reader.notifyAll();
        }
    }

    @Override
    public void write(char[] buffer, int offset, int count) throws IOException {
        PipedReader reader = this.destination;
        if (reader == null) {
            throw new IOException("Pipe not connected");
        }
        reader.receive(buffer, offset, count);
    }

    @Override
    public void write(int c) throws IOException {
        PipedReader reader = this.destination;
        if (reader == null) {
            throw new IOException("Pipe not connected");
        }
        reader.receive((char)c);
    }
}

