/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.VMStack;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.Types;

public final class Class<T>
implements Serializable,
AnnotatedElement,
GenericDeclaration,
Type {
    private static final long serialVersionUID = 3206093459760846163L;
    private SoftReference<ClassCache<T>> cacheRef;

    private Class() {
    }

    ClassCache<T> getClassCache() {
        ClassCache cache;
        ClassCache classCache = cache = this.cacheRef != null ? (ClassCache)this.cacheRef.get() : null;
        if (cache == null) {
            cache = new ClassCache(this);
            this.cacheRef = new SoftReference<ClassCache<ClassCache<T>>>(cache);
        }
        return cache;
    }

    private native String getSignatureAttribute();

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, VMStack.getCallingClassLoader());
    }

    public static Class<?> forName(String className, boolean shouldInitialize, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> result;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            result = Class.classForName(className, shouldInitialize, classLoader);
        }
        catch (ClassNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ExceptionInInitializerError) {
                throw (ExceptionInInitializerError)cause;
            }
            throw e;
        }
        return result;
    }

    static native Class<?> classForName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Class<?>[] getClasses() {
        return this.getClassCache().getClasses(true);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        A annotation = this.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        if (annotationType.isAnnotationPresent(Inherited.class)) {
            for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                annotation = super.getDeclaredAnnotation(annotationType);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getClassCache().getAnnotations(true);
    }

    final Annotation[] getAnnotations0() {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        Annotation[] declaredAnnotations = this.getClassCache().getDeclaredAnnotations(false);
        for (int i = declaredAnnotations.length - 1; i >= 0; --i) {
            map.put(declaredAnnotations[i].annotationType(), declaredAnnotations[i]);
        }
        for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
            declaredAnnotations = sup.getClassCache().getDeclaredAnnotations(false);
            for (int i = declaredAnnotations.length - 1; i >= 0; --i) {
                Class<? extends Annotation> clazz = declaredAnnotations[i].annotationType();
                if (map.containsKey(clazz) || !clazz.isAnnotationPresent(Inherited.class)) continue;
                map.put(clazz, declaredAnnotations[i]);
            }
        }
        Collection coll = map.values();
        return coll.toArray(new Annotation[coll.size()]);
    }

    public String getCanonicalName() {
        if (this.isLocalClass() || this.isAnonymousClass()) {
            return null;
        }
        if (this.isArray()) {
            String name = this.getComponentType().getCanonicalName();
            if (name != null) {
                return name + "[]";
            }
        } else if (this.isMemberClass()) {
            String name = this.getDeclaringClass().getCanonicalName();
            if (name != null) {
                return name + "." + this.getSimpleName();
            }
        } else {
            return this.getName();
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        if (this.isPrimitive()) {
            return null;
        }
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == null) {
            loader = BootClassLoader.getInstance();
        }
        return loader;
    }

    ClassLoader getClassLoaderImpl() {
        ClassLoader loader = Class.getClassLoader(this);
        return loader == null ? BootClassLoader.getInstance() : loader;
    }

    private static native ClassLoader getClassLoader(Class<?> var0);

    public native Class<?> getComponentType();

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException {
        return this.getClassCache().getConstructor(true, parameterTypes);
    }

    public Constructor<?>[] getConstructors() {
        return this.getClassCache().getDeclaredPublicConstructors(true);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getClassCache().getDeclaredAnnotations(true);
    }

    final native Annotation[] getDeclaredAnnotations0();

    private <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("annotationClass == null");
        }
        Annotation[] annos = this.getClassCache().getDeclaredAnnotations(false);
        for (int i = annos.length - 1; i >= 0; --i) {
            if (annos[i].annotationType() != annotationClass) continue;
            return (A)annos[i];
        }
        return null;
    }

    private boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("annotationClass == null");
        }
        return this.getDeclaredAnnotation(annotationClass) != null;
    }

    public Class<?>[] getDeclaredClasses() {
        return this.getClassCache().getDeclaredClasses(true);
    }

    final native Class<?>[] getDeclaredClasses0(boolean var1);

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException {
        return this.getClassCache().getDeclaredConstructor(true, parameterTypes);
    }

    public Constructor<?>[] getDeclaredConstructors() {
        return this.getClassCache().getDeclaredConstructors(true);
    }

    final native Constructor<?>[] getDeclaredConstructors0(boolean var1);

    public Field getDeclaredField(String name) throws NoSuchFieldException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return this.getClassCache().getDeclaredField(true, name);
    }

    public Field[] getDeclaredFields() {
        return this.getClassCache().getDeclaredFields(true);
    }

    final native Field[] getDeclaredFields0(boolean var1);

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return this.getClassCache().getDeclaredMethod(true, name, parameterTypes);
    }

    public Method[] getDeclaredMethods() {
        return this.getClassCache().getDeclaredMethods(true);
    }

    final native Method[] getDeclaredMethods0(boolean var1);

    public native Class<?> getDeclaringClass();

    public native Class<?> getEnclosingClass();

    public native Constructor<?> getEnclosingConstructor();

    public native Method getEnclosingMethod();

    public T[] getEnumConstants() {
        if (!this.isEnum()) {
            return null;
        }
        return (Object[])Enum.getSharedConstants((Class)this).clone();
    }

    public Field getField(String name) throws NoSuchFieldException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return this.getClassCache().getField(true, name);
    }

    public Field[] getFields() {
        return this.getClassCache().getFields(true);
    }

    public Type[] getGenericInterfaces() {
        GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
        parser.parseForClass(this, this.getSignatureAttribute());
        return Types.getTypeArray(parser.interfaceTypes, true);
    }

    public Type getGenericSuperclass() {
        GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
        parser.parseForClass(this, this.getSignatureAttribute());
        return Types.getType(parser.superclassType);
    }

    public native Class<?>[] getInterfaces();

    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return this.getClassCache().getMethod(true, name, parameterTypes);
    }

    public Method[] getMethods() {
        return this.getClassCache().getMethods(true);
    }

    public int getModifiers() {
        return Class.getModifiers(this, false);
    }

    private static native int getModifiers(Class<?> var0, boolean var1);

    public String getName() {
        return this.getClassCache().getName();
    }

    final native String getName0();

    public String getSimpleName() {
        if (this.isArray()) {
            return this.getComponentType().getSimpleName() + "[]";
        }
        String name = this.getName();
        if (this.isAnonymousClass()) {
            return "";
        }
        if (this.isMemberClass() || this.isLocalClass()) {
            return this.getInnerClassName();
        }
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            return name.substring(dot + 1);
        }
        return name;
    }

    private native String getInnerClassName();

    public ProtectionDomain getProtectionDomain() {
        return null;
    }

    public URL getResource(String resourceName) {
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        } else {
            String pkg = this.getName();
            int dot = pkg.lastIndexOf(46);
            pkg = dot != -1 ? pkg.substring(0, dot).replace('.', '/') : "";
            resourceName = pkg + "/" + resourceName;
        }
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            return loader.getResource(resourceName);
        }
        return ClassLoader.getSystemResource(resourceName);
    }

    public InputStream getResourceAsStream(String resourceName) {
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        } else {
            String pkg = this.getName();
            int dot = pkg.lastIndexOf(46);
            pkg = dot != -1 ? pkg.substring(0, dot).replace('.', '/') : "";
            resourceName = pkg + "/" + resourceName;
        }
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            return loader.getResourceAsStream(resourceName);
        }
        return ClassLoader.getSystemResourceAsStream(resourceName);
    }

    public Object[] getSigners() {
        return null;
    }

    public native Class<? super T> getSuperclass();

    public synchronized TypeVariable<Class<T>>[] getTypeParameters() {
        GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
        parser.parseForClass(this, this.getSignatureAttribute());
        return (TypeVariable[])parser.formalTypeParameters.clone();
    }

    public boolean isAnnotation() {
        int ACC_ANNOTATION = 8192;
        int mod = Class.getModifiers(this, true);
        return (mod & 0x2000) != 0;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        if (this.isDeclaredAnnotationPresent(annotationType)) {
            return true;
        }
        if (super.isDeclaredAnnotationPresent(Inherited.class)) {
            for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                if (!super.isDeclaredAnnotationPresent(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    public native boolean isAnonymousClass();

    public boolean isArray() {
        return this.getComponentType() != null;
    }

    public native boolean isAssignableFrom(Class<?> var1);

    public boolean isEnum() {
        if (this.getSuperclass() != Enum.class) {
            return false;
        }
        int mod = Class.getModifiers(this, true);
        return (mod & 0x4000) != 0;
    }

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public boolean isLocalClass() {
        boolean enclosed = this.getEnclosingMethod() != null || this.getEnclosingConstructor() != null;
        return enclosed && !this.isAnonymousClass();
    }

    public boolean isMemberClass() {
        return this.getDeclaringClass() != null;
    }

    public native boolean isPrimitive();

    public boolean isSynthetic() {
        int ACC_SYNTHETIC = 4096;
        int mod = Class.getModifiers(this, true);
        return (mod & 0x1000) != 0;
    }

    public T newInstance() throws InstantiationException, IllegalAccessException {
        try {
            Constructor<T> constructor = this.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            InstantiationException instantiationException = new InstantiationException(e.getMessage());
            instantiationException.initCause(e.getTargetException());
            throw instantiationException;
        }
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.getSimpleName();
        }
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    public Package getPackage() {
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            String name = this.getName();
            int dot = name.lastIndexOf(46);
            return dot != -1 ? loader.getPackage(name.substring(0, dot)) : null;
        }
        return null;
    }

    public native boolean desiredAssertionStatus();

    public <U> Class<? extends U> asSubclass(Class<U> c) {
        if (c.isAssignableFrom(this)) {
            return this;
        }
        String actualClassName = this.getName();
        String desiredClassName = c.getName();
        throw new ClassCastException(actualClassName + " cannot be cast to " + desiredClassName);
    }

    public T cast(Object obj) {
        if (obj == null) {
            return null;
        }
        if (this.isInstance(obj)) {
            return (T)obj;
        }
        String actualClassName = obj.getClass().getName();
        String desiredClassName = this.getName();
        throw new ClassCastException(actualClassName + " cannot be cast to " + desiredClassName);
    }

    private static <T> T[] arraycopy(T[] result, T[] head, T[] tail) {
        System.arraycopy(head, 0, result, 0, head.length);
        System.arraycopy(tail, 0, result, head.length, tail.length);
        return result;
    }
}

