/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.VMRuntime;
import java.lang.ref.FinalizerReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.TimeoutException;
import libcore.util.EmptyArray;

public final class Daemons {
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final long MAX_FINALIZE_NANOS = 10000000000L;
    private static final long MAX_FINALIZE_NANOS_HALF = 5000000000L;

    public static void start() {
        ReferenceQueueDaemon.INSTANCE.start();
        FinalizerDaemon.INSTANCE.start();
        FinalizerWatchdogDaemon.INSTANCE.start();
    }

    public static void stop() {
        ReferenceQueueDaemon.INSTANCE.stop();
        FinalizerDaemon.INSTANCE.stop();
        FinalizerWatchdogDaemon.INSTANCE.stop();
    }

    private static class ReferenceQueueDaemon
    extends Daemon {
        private static final ReferenceQueueDaemon INSTANCE = new ReferenceQueueDaemon();

        private ReferenceQueueDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (this.isRunning()) {
                Reference<?> list;
                try {
                    Class<ReferenceQueue> clazz = ReferenceQueue.class;
                    // MONITORENTER : java.lang.ref.ReferenceQueue.class
                    while (ReferenceQueue.unenqueued == null) {
                        ReferenceQueue.class.wait();
                    }
                    list = ReferenceQueue.unenqueued;
                    ReferenceQueue.unenqueued = null;
                    // MONITOREXIT : clazz
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.enqueue(list);
            }
        }

        private void enqueue(Reference<?> list) {
            while (list != null) {
                Reference<?> reference;
                if (list == list.pendingNext) {
                    reference = list;
                    reference.pendingNext = null;
                    list = null;
                } else {
                    reference = list.pendingNext;
                    list.pendingNext = reference.pendingNext;
                    reference.pendingNext = null;
                }
                reference.enqueueInternal();
            }
        }
    }

    private static class FinalizerDaemon
    extends Daemon {
        private static final FinalizerDaemon INSTANCE = new FinalizerDaemon();
        private final ReferenceQueue<Object> queue = FinalizerReference.queue;
        private volatile Object finalizingObject;
        private volatile long finalizingStartedNanos;

        private FinalizerDaemon() {
        }

        @Override
        public void run() {
            while (this.isRunning()) {
                try {
                    this.doFinalize((FinalizerReference)this.queue.remove());
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @FindBugsSuppressWarnings(value={"FI_EXPLICIT_INVOCATION"})
        private void doFinalize(FinalizerReference<?> reference) {
            FinalizerReference.remove(reference);
            Object object = reference.get();
            reference.clear();
            try {
                this.finalizingStartedNanos = System.nanoTime();
                this.finalizingObject = object;
                FinalizerWatchdogDaemon finalizerWatchdogDaemon = FinalizerWatchdogDaemon.INSTANCE;
                synchronized (finalizerWatchdogDaemon) {
                    FinalizerWatchdogDaemon.INSTANCE.notify();
                }
                object.finalize();
            }
            catch (Throwable ex) {
                System.logE("Uncaught exception thrown by finalizer", ex);
            }
            finally {
                this.finalizingObject = null;
            }
        }
    }

    private static class FinalizerWatchdogDaemon
    extends Daemon {
        private static final FinalizerWatchdogDaemon INSTANCE = new FinalizerWatchdogDaemon();

        private FinalizerWatchdogDaemon() {
        }

        @Override
        public void run() {
            while (this.isRunning()) {
                boolean finalized;
                Object object = this.waitForObject();
                if (object == null || (finalized = this.waitForFinalization(object)) || VMRuntime.getRuntime().isDebuggerActive()) continue;
                FinalizerWatchdogDaemon.finalizerTimedOut(object);
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object waitForObject() {
            Object object;
            while ((object = FinalizerDaemon.INSTANCE.finalizingObject) == null) {
                FinalizerWatchdogDaemon finalizerWatchdogDaemon = this;
                synchronized (finalizerWatchdogDaemon) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                }
            }
            return object;
        }

        private void sleepFor(long sleepNanos) {
            long sleepMills = sleepNanos / 1000000L;
            try {
                Thread.sleep(sleepMills);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private boolean waitForFinalization(Object object) {
            this.sleepFor(5000000000L);
            if (object != FinalizerDaemon.INSTANCE.finalizingObject) {
                return true;
            }
            this.sleepFor(5000000000L);
            return object != FinalizerDaemon.INSTANCE.finalizingObject;
        }

        private static void finalizerTimedOut(Object object) {
            String message = object.getClass().getName() + ".finalize() timed out after " + 10L + " seconds";
            TimeoutException syntheticException = new TimeoutException(message);
            syntheticException.setStackTrace(FinalizerDaemon.INSTANCE.getStackTrace());
            Thread.UncaughtExceptionHandler h = Thread.getDefaultUncaughtExceptionHandler();
            if (h == null) {
                System.logE(message, syntheticException);
                System.exit(2);
            }
            h.uncaughtException(Thread.currentThread(), syntheticException);
        }
    }

    private static abstract class Daemon
    implements Runnable {
        private Thread thread;

        private Daemon() {
        }

        public synchronized void start() {
            if (this.thread != null) {
                throw new IllegalStateException("already running");
            }
            this.thread = new Thread(ThreadGroup.mMain, this, this.getClass().getSimpleName());
            this.thread.setDaemon(true);
            this.thread.start();
        }

        @Override
        public abstract void run();

        protected synchronized boolean isRunning() {
            return this.thread != null;
        }

        public synchronized void interrupt() {
            if (this.thread == null) {
                throw new IllegalStateException("not running");
            }
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Thread threadToStop;
            Daemon daemon = this;
            synchronized (daemon) {
                threadToStop = this.thread;
                this.thread = null;
            }
            if (threadToStop == null) {
                throw new IllegalStateException("not running");
            }
            threadToStop.interrupt();
            while (true) {
                try {
                    threadToStop.join();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public synchronized StackTraceElement[] getStackTrace() {
            return this.thread != null ? this.thread.getStackTrace() : EmptyArray.STACK_TRACE_ELEMENT;
        }
    }
}

