/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable<Double> {
    static final int EXPONENT_BIAS = 1023;
    static final int EXPONENT_BITS = 12;
    static final int MANTISSA_BITS = 52;
    static final int NON_MANTISSA_BITS = 12;
    static final long SIGN_MASK = Long.MIN_VALUE;
    static final long EXPONENT_MASK = 0x7FF0000000000000L;
    static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long serialVersionUID = -9172774392245257468L;
    private final double value;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NaN = 0.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double MIN_NORMAL = 2.2250738585072014E-308;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final Class<Double> TYPE = double[].class.getComponentType();
    public static final int SIZE = 64;

    public Double(double value) {
        this.value = value;
    }

    public Double(String string) throws NumberFormatException {
        this(Double.parseDouble(string));
    }

    @Override
    public int compareTo(Double object) {
        return Double.compare(this.value, object.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    public static native long doubleToLongBits(double var0);

    public static native long doubleToRawLongBits(double var0);

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Double && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Double)object).value);
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public static int hashCode(double value) {
        long v = Double.doubleToLongBits(value);
        return (int)(v ^ v >>> 32);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public static native double longBitsToDouble(long var0);

    @Override
    public long longValue() {
        return (long)this.value;
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return StringToReal.parseDouble(string);
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public static String toString(double d) {
        return RealToString.getInstance().doubleToString(d);
    }

    public static Double valueOf(String string) throws NumberFormatException {
        return Double.parseDouble(string);
    }

    public static int compare(double double1, double double2) {
        if (double1 > double2) {
            return 1;
        }
        if (double2 > double1) {
            return -1;
        }
        if (double1 == double2 && 0.0 != double1) {
            return 0;
        }
        if (Double.isNaN(double1)) {
            if (Double.isNaN(double2)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(double2)) {
            return -1;
        }
        long d1 = Double.doubleToRawLongBits(double1);
        long d2 = Double.doubleToRawLongBits(double2);
        return (int)((d1 >> 63) - (d2 >> 63));
    }

    public static Double valueOf(double d) {
        return new Double(d);
    }

    public static String toHexString(double d) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        long bitValue = Double.doubleToLongBits(d);
        boolean negative = (bitValue & Long.MIN_VALUE) != 0L;
        long exponent = (bitValue & 0x7FF0000000000000L) >>> 52;
        long significand = bitValue & 0xFFFFFFFFFFFFFL;
        if (exponent == 0L && significand == 0L) {
            return negative ? "-0x0.0p0" : "0x0.0p0";
        }
        StringBuilder hexString = new StringBuilder(10);
        if (negative) {
            hexString.append("-0x");
        } else {
            hexString.append("0x");
        }
        if (exponent == 0L) {
            hexString.append("0.");
            int fractionDigits = 13;
            while (significand != 0L && (significand & 0xFL) == 0L) {
                significand >>>= 4;
                --fractionDigits;
            }
            String hexSignificand = Long.toHexString(significand);
            if (significand != 0L && fractionDigits > hexSignificand.length()) {
                int digitDiff = fractionDigits - hexSignificand.length();
                while (digitDiff-- != 0) {
                    hexString.append('0');
                }
            }
            hexString.append(hexSignificand);
            hexString.append("p-1022");
        } else {
            hexString.append("1.");
            int fractionDigits = 13;
            while (significand != 0L && (significand & 0xFL) == 0L) {
                significand >>>= 4;
                --fractionDigits;
            }
            String hexSignificand = Long.toHexString(significand);
            if (significand != 0L && fractionDigits > hexSignificand.length()) {
                int digitDiff = fractionDigits - hexSignificand.length();
                while (digitDiff-- != 0) {
                    hexString.append('0');
                }
            }
            hexString.append(hexSignificand);
            hexString.append('p');
            hexString.append(Long.toString(exponent - 1023L));
        }
        return hexString.toString();
    }
}

