/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharArrayBuffer;
import java.nio.CharSequenceAdapter;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;

public abstract class CharBuffer
extends Buffer
implements Comparable<CharBuffer>,
CharSequence,
Appendable,
Readable {
    public static CharBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new CharArrayBuffer(new char[capacity]);
    }

    public static CharBuffer wrap(char[] array) {
        return CharBuffer.wrap(array, 0, array.length);
    }

    public static CharBuffer wrap(char[] array, int start, int charCount) {
        Arrays.checkOffsetAndCount(array.length, start, charCount);
        CharArrayBuffer buf = new CharArrayBuffer(array);
        buf.position = start;
        buf.limit = start + charCount;
        return buf;
    }

    public static CharBuffer wrap(CharSequence chseq) {
        return new CharSequenceAdapter(chseq);
    }

    public static CharBuffer wrap(CharSequence cs, int start, int end) {
        if (start < 0 || end < start || end > cs.length()) {
            throw new IndexOutOfBoundsException("cs.length()=" + cs.length() + ", start=" + start + ", end=" + end);
        }
        CharSequenceAdapter result = new CharSequenceAdapter(cs);
        result.position = start;
        result.limit = end;
        return result;
    }

    CharBuffer(int capacity) {
        super(1, capacity, null);
    }

    public final char[] array() {
        return this.protectedArray();
    }

    @Override
    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract CharBuffer asReadOnlyBuffer();

    @Override
    public final char charAt(int index) {
        if (index < 0 || index >= this.remaining()) {
            throw new IndexOutOfBoundsException("index=" + index + ", remaining()=" + this.remaining());
        }
        return this.get(this.position + index);
    }

    public abstract CharBuffer compact();

    @Override
    public int compareTo(CharBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            char otherByte;
            char thisByte = this.get(thisPos);
            if (thisByte != (otherByte = otherBuffer.get(otherPos))) {
                return thisByte < otherByte ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract CharBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof CharBuffer)) {
            return false;
        }
        CharBuffer otherBuffer = (CharBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract char get();

    public CharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public CharBuffer get(char[] dst, int dstOffset, int charCount) {
        Arrays.checkOffsetAndCount(dst.length, dstOffset, charCount);
        if (charCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = dstOffset; i < dstOffset + charCount; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public abstract char get(int var1);

    @Override
    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += this.get(myPosition++);
        }
        return hash;
    }

    @Override
    public abstract boolean isDirect();

    @Override
    public final int length() {
        return this.remaining();
    }

    public abstract ByteOrder order();

    abstract char[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract CharBuffer put(char var1);

    public final CharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public CharBuffer put(char[] src, int srcOffset, int charCount) {
        Arrays.checkOffsetAndCount(src.length, srcOffset, charCount);
        if (charCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = srcOffset; i < srcOffset + charCount; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public CharBuffer put(CharBuffer src) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (src == this) {
            throw new IllegalArgumentException("src == this");
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        char[] contents = new char[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract CharBuffer put(int var1, char var2);

    public final CharBuffer put(String str) {
        return this.put(str, 0, str.length());
    }

    public CharBuffer put(String str, int start, int end) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (start < 0 || end < start || end > str.length()) {
            throw new IndexOutOfBoundsException("str.length()=" + str.length() + ", start=" + start + ", end=" + end);
        }
        if (end - start > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = start; i < end; ++i) {
            this.put(str.charAt(i));
        }
        return this;
    }

    public abstract CharBuffer slice();

    @Override
    public abstract CharBuffer subSequence(int var1, int var2);

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.limit - this.position);
        for (int i = this.position; i < this.limit; ++i) {
            result.append(this.get(i));
        }
        return result.toString();
    }

    @Override
    public CharBuffer append(char c) {
        return this.put(c);
    }

    @Override
    public CharBuffer append(CharSequence csq) {
        if (csq != null) {
            return this.put(csq.toString());
        }
        return this.put("null");
    }

    @Override
    public CharBuffer append(CharSequence csq, int start, int end) {
        CharSequence cs;
        if (csq == null) {
            csq = "null";
        }
        if ((cs = csq.subSequence(start, end)).length() > 0) {
            return this.put(cs.toString());
        }
        return this;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int remaining = this.remaining();
        if (target == this) {
            if (remaining == 0) {
                return -1;
            }
            throw new IllegalArgumentException("target == this");
        }
        if (remaining == 0) {
            return this.limit > 0 && target.remaining() == 0 ? 0 : -1;
        }
        remaining = Math.min(target.remaining(), remaining);
        if (remaining > 0) {
            char[] chars = new char[remaining];
            this.get(chars);
            target.put(chars);
        }
        return remaining;
    }

    @Override
    public final CharBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final CharBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final CharBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final CharBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final CharBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public final CharBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }

    @Override
    public final CharBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }
}

