/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.nio.FileDescriptorChannel;
import java.nio.SocketChannelImpl;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.OsConstants;

final class ServerSocketChannelImpl
extends ServerSocketChannel
implements FileDescriptorChannel {
    private final ServerSocketAdapter socket;
    private final SocketImpl impl;
    private boolean isBound = false;
    private final Object acceptLock = new Object();

    public ServerSocketChannelImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.socket = new ServerSocketAdapter(this);
        this.impl = this.socket.getImpl$();
    }

    @Override
    public ServerSocket socket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel accept() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isBound) {
            throw new NotYetBoundException();
        }
        SocketChannelImpl result = new SocketChannelImpl(this.provider(), false);
        try {
            this.begin();
            Object object = this.acceptLock;
            synchronized (object) {
                block10: {
                    try {
                        this.socket.implAccept(result);
                    }
                    catch (SocketTimeoutException e) {
                        if (!this.shouldThrowSocketTimeoutExceptionFromAccept(e)) break block10;
                        throw e;
                    }
                }
            }
        }
        finally {
            this.end(result.socket().isConnected());
        }
        return result.socket().isConnected() ? result : null;
    }

    private boolean shouldThrowSocketTimeoutExceptionFromAccept(SocketTimeoutException e) {
        if (this.isBlocking()) {
            return true;
        }
        Throwable cause = e.getCause();
        return !(cause instanceof ErrnoException) || ((ErrnoException)cause).errno != OsConstants.EAGAIN;
    }

    @Override
    protected void implConfigureBlocking(boolean blocking) throws IOException {
        IoUtils.setBlocking(this.impl.getFD$(), blocking);
    }

    @Override
    protected synchronized void implCloseSelectableChannel() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.impl.getFD$();
    }

    private static class ServerSocketAdapter
    extends ServerSocket {
        private final ServerSocketChannelImpl channelImpl;

        ServerSocketAdapter(ServerSocketChannelImpl aChannelImpl) throws IOException {
            this.channelImpl = aChannelImpl;
        }

        @Override
        public void bind(SocketAddress localAddress, int backlog) throws IOException {
            super.bind(localAddress, backlog);
            this.channelImpl.isBound = true;
        }

        @Override
        public Socket accept() throws IOException {
            if (!this.channelImpl.isBound) {
                throw new IllegalBlockingModeException();
            }
            SocketChannel sc = this.channelImpl.accept();
            if (sc == null) {
                throw new IllegalBlockingModeException();
            }
            return sc.socket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket implAccept(SocketChannelImpl clientSocketChannel) throws IOException {
            Socket clientSocket = clientSocketChannel.socket();
            boolean connectOK = false;
            try {
                ServerSocketAdapter serverSocketAdapter = this;
                synchronized (serverSocketAdapter) {
                    super.implAccept(clientSocket);
                    clientSocketChannel.setConnected();
                    clientSocketChannel.setBound(true);
                    clientSocketChannel.finishAccept();
                }
                connectOK = true;
            }
            finally {
                if (!connectOK) {
                    clientSocket.close();
                }
            }
            return clientSocket;
        }

        @Override
        public ServerSocketChannel getChannel() {
            return this.channelImpl;
        }

        @Override
        public boolean isBound() {
            return this.channelImpl.isBound;
        }

        @Override
        public void bind(SocketAddress localAddress) throws IOException {
            super.bind(localAddress);
            this.channelImpl.isBound = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ServerSocketChannelImpl serverSocketChannelImpl = this.channelImpl;
            synchronized (serverSocketChannelImpl) {
                if (this.channelImpl.isOpen()) {
                    this.channelImpl.close();
                } else {
                    super.close();
                }
            }
        }
    }
}

