/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyRep
implements Serializable {
    private static final long serialVersionUID = -4757683898830641853L;
    private final Type type;
    private final String algorithm;
    private final String format;
    private byte[] encoded;

    public KeyRep(Type type, String algorithm, String format, byte[] encoded) {
        this.type = type;
        this.algorithm = algorithm;
        this.format = format;
        this.encoded = encoded;
        if (this.type == null) {
            throw new NullPointerException("type == null");
        }
        if (this.algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        if (this.format == null) {
            throw new NullPointerException("format == null");
        }
        if (this.encoded == null) {
            throw new NullPointerException("encoded == null");
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        switch (this.type.ordinal()) {
            case 0: {
                if ("RAW".equals(this.format)) {
                    try {
                        return new SecretKeySpec(this.encoded, this.algorithm);
                    }
                    catch (IllegalArgumentException e) {
                        throw new NotSerializableException("Could not create SecretKeySpec: " + e);
                    }
                }
                throw new NotSerializableException("unrecognized type/format combination: " + (Object)((Object)this.type) + "/" + this.format);
            }
            case 1: {
                if ("X.509".equals(this.format)) {
                    try {
                        KeyFactory kf = KeyFactory.getInstance(this.algorithm);
                        return kf.generatePublic(new X509EncodedKeySpec(this.encoded));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new NotSerializableException("Could not resolve key: " + e);
                    }
                    catch (InvalidKeySpecException e) {
                        throw new NotSerializableException("Could not resolve key: " + e);
                    }
                }
                throw new NotSerializableException("unrecognized type/format combination: " + (Object)((Object)this.type) + "/" + this.format);
            }
            case 2: {
                if ("PKCS#8".equals(this.format)) {
                    try {
                        KeyFactory kf = KeyFactory.getInstance(this.algorithm);
                        return kf.generatePrivate(new PKCS8EncodedKeySpec(this.encoded));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new NotSerializableException("Could not resolve key: " + e);
                    }
                    catch (InvalidKeySpecException e) {
                        throw new NotSerializableException("Could not resolve key: " + e);
                    }
                }
                throw new NotSerializableException("unrecognized type/format combination: " + (Object)((Object)this.type) + "/" + this.format);
            }
        }
        throw new NotSerializableException("unrecognized key type: " + (Object)((Object)this.type));
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        byte[] new_encoded = new byte[this.encoded.length];
        System.arraycopy((Object)this.encoded, 0, (Object)new_encoded, 0, new_encoded.length);
        this.encoded = new_encoded;
    }

    public static enum Type {
        SECRET,
        PUBLIC,
        PRIVATE;

    }
}

