/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Extension;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public abstract class X509Certificate
extends Certificate
implements X509Extension {
    private static final long serialVersionUID = -2491127588187038216L;

    protected X509Certificate() {
        super("X.509");
    }

    public abstract void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract void checkValidity(Date var1) throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract int getVersion();

    public abstract BigInteger getSerialNumber();

    public abstract Principal getIssuerDN();

    public X500Principal getIssuerX500Principal() {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(this.getEncoded()));
            return cert.getIssuerX500Principal();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get X500Principal issuer", e);
        }
    }

    public abstract Principal getSubjectDN();

    public X500Principal getSubjectX500Principal() {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(this.getEncoded()));
            return cert.getSubjectX500Principal();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get X500Principal subject", e);
        }
    }

    public abstract Date getNotBefore();

    public abstract Date getNotAfter();

    public abstract byte[] getTBSCertificate() throws CertificateEncodingException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public abstract boolean[] getIssuerUniqueID();

    public abstract boolean[] getSubjectUniqueID();

    public abstract boolean[] getKeyUsage();

    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        return null;
    }

    public abstract int getBasicConstraints();

    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        return null;
    }

    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return null;
    }
}

