/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import libcore.util.EmptyArray;
import libcore.util.Objects;

public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private volatile transient Object[] elements;

    public CopyOnWriteArrayList() {
        this.elements = EmptyArray.OBJECT;
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
        this(collection.toArray());
    }

    public CopyOnWriteArrayList(E[] array) {
        this.elements = Arrays.copyOf(array, array.length, Object[].class);
    }

    public Object clone() {
        try {
            CopyOnWriteArrayList result = (CopyOnWriteArrayList)super.clone();
            result.elements = (Object[])result.elements.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public E get(int index) {
        return (E)this.elements[index];
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Object[] snapshot = this.elements;
        return CopyOnWriteArrayList.containsAll(collection, snapshot, 0, snapshot.length);
    }

    static boolean containsAll(Collection<?> collection, Object[] snapshot, int from, int to) {
        for (Object o : collection) {
            if (CopyOnWriteArrayList.indexOf(o, snapshot, from, to) != -1) continue;
            return false;
        }
        return true;
    }

    public int indexOf(E object, int from) {
        Object[] snapshot = this.elements;
        return CopyOnWriteArrayList.indexOf(object, snapshot, from, snapshot.length);
    }

    @Override
    public int indexOf(Object object) {
        Object[] snapshot = this.elements;
        return CopyOnWriteArrayList.indexOf(object, snapshot, 0, snapshot.length);
    }

    public int lastIndexOf(E object, int to) {
        Object[] snapshot = this.elements;
        return CopyOnWriteArrayList.lastIndexOf(object, snapshot, 0, to);
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] snapshot = this.elements;
        return CopyOnWriteArrayList.lastIndexOf(object, snapshot, 0, snapshot.length);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public Iterator<E> iterator() {
        Object[] snapshot = this.elements;
        return new CowIterator(snapshot, 0, snapshot.length);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] snapshot = this.elements;
        if (index < 0 || index > snapshot.length) {
            throw new IndexOutOfBoundsException("index=" + index + ", length=" + snapshot.length);
        }
        CowIterator result = new CowIterator(snapshot, 0, snapshot.length);
        result.index = index;
        return result;
    }

    @Override
    public ListIterator<E> listIterator() {
        Object[] snapshot = this.elements;
        return new CowIterator(snapshot, 0, snapshot.length);
    }

    @Override
    public List<E> subList(int from, int to) {
        Object[] snapshot = this.elements;
        if (from < 0 || from > to || to > snapshot.length) {
            throw new IndexOutOfBoundsException("from=" + from + ", to=" + to + ", list size=" + snapshot.length);
        }
        return new CowSubList(snapshot, from, to);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.elements.clone();
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        Object[] snapshot = this.elements;
        if (snapshot.length > contents.length) {
            return Arrays.copyOf(snapshot, snapshot.length, contents.getClass());
        }
        System.arraycopy((Object)snapshot, 0, contents, 0, snapshot.length);
        if (snapshot.length < contents.length) {
            contents[snapshot.length] = null;
        }
        return contents;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CopyOnWriteArrayList) {
            return this == other || Arrays.equals(this.elements, ((CopyOnWriteArrayList)other).elements);
        }
        if (other instanceof List) {
            Object[] snapshot = this.elements;
            Iterator i = ((List)other).iterator();
            for (Object o : snapshot) {
                if (i.hasNext() && Objects.equal(o, i.next())) continue;
                return false;
            }
            return !i.hasNext();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    public String toString() {
        return Arrays.toString(this.elements);
    }

    @Override
    public synchronized boolean add(E e) {
        Object[] newElements = new Object[this.elements.length + 1];
        System.arraycopy((Object)this.elements, 0, (Object)newElements, 0, this.elements.length);
        newElements[this.elements.length] = e;
        this.elements = newElements;
        return true;
    }

    @Override
    public synchronized void add(int index, E e) {
        Object[] newElements = new Object[this.elements.length + 1];
        System.arraycopy((Object)this.elements, 0, (Object)newElements, 0, index);
        newElements[index] = e;
        System.arraycopy((Object)this.elements, index, (Object)newElements, index + 1, this.elements.length - index);
        this.elements = newElements;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.elements.length, collection);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> collection) {
        Object[] toAdd = collection.toArray();
        Object[] newElements = new Object[this.elements.length + toAdd.length];
        System.arraycopy((Object)this.elements, 0, (Object)newElements, 0, index);
        System.arraycopy((Object)toAdd, 0, (Object)newElements, index, toAdd.length);
        System.arraycopy((Object)this.elements, index, (Object)newElements, index + toAdd.length, this.elements.length - index);
        this.elements = newElements;
        return toAdd.length > 0;
    }

    public synchronized int addAllAbsent(Collection<? extends E> collection) {
        Object[] toAdd = collection.toArray();
        Object[] newElements = new Object[this.elements.length + toAdd.length];
        System.arraycopy((Object)this.elements, 0, (Object)newElements, 0, this.elements.length);
        int addedCount = 0;
        for (Object o : toAdd) {
            if (CopyOnWriteArrayList.indexOf(o, newElements, 0, this.elements.length + addedCount) != -1) continue;
            newElements[this.elements.length + addedCount++] = o;
        }
        if (addedCount < toAdd.length) {
            newElements = Arrays.copyOfRange(newElements, 0, this.elements.length + addedCount);
        }
        this.elements = newElements;
        return addedCount;
    }

    public synchronized boolean addIfAbsent(E object) {
        if (this.contains(object)) {
            return false;
        }
        this.add(object);
        return true;
    }

    @Override
    public synchronized void clear() {
        this.elements = EmptyArray.OBJECT;
    }

    @Override
    public synchronized E remove(int index) {
        Object removed = this.elements[index];
        this.removeRange(index, index + 1);
        return (E)removed;
    }

    @Override
    public synchronized boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        return this.removeOrRetain(collection, false, 0, this.elements.length) != 0;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        return this.removeOrRetain(collection, true, 0, this.elements.length) != 0;
    }

    private int removeOrRetain(Collection<?> collection, boolean retain, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (collection.contains(this.elements[i]) == retain) continue;
            Object[] newElements = new Object[this.elements.length - 1];
            System.arraycopy((Object)this.elements, 0, (Object)newElements, 0, i);
            int newSize = i;
            for (int j = i + 1; j < to; ++j) {
                if (collection.contains(this.elements[j]) != retain) continue;
                newElements[newSize++] = this.elements[j];
            }
            System.arraycopy((Object)this.elements, to, (Object)newElements, newSize, this.elements.length - to);
            if ((newSize += this.elements.length - to) < newElements.length) {
                newElements = Arrays.copyOfRange(newElements, 0, newSize);
            }
            int removed = this.elements.length - newElements.length;
            this.elements = newElements;
            return removed;
        }
        return 0;
    }

    @Override
    public synchronized E set(int index, E e) {
        Object[] newElements = (Object[])this.elements.clone();
        Object result = newElements[index];
        newElements[index] = e;
        this.elements = newElements;
        return (E)result;
    }

    private void removeRange(int from, int to) {
        Object[] newElements = new Object[this.elements.length - (to - from)];
        System.arraycopy((Object)this.elements, 0, (Object)newElements, 0, from);
        System.arraycopy((Object)this.elements, to, (Object)newElements, from, this.elements.length - to);
        this.elements = newElements;
    }

    static int lastIndexOf(Object o, Object[] data, int from, int to) {
        if (o == null) {
            for (int i = to - 1; i >= from; --i) {
                if (data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = to - 1; i >= from; --i) {
                if (!o.equals(data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    static int indexOf(Object o, Object[] data, int from, int to) {
        if (o == null) {
            for (int i = from; i < to; ++i) {
                if (data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = from; i < to; ++i) {
                if (!o.equals(data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    final Object[] getArray() {
        return this.elements;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object[] snapshot = this.elements;
        out.defaultWriteObject();
        out.writeInt(snapshot.length);
        for (Object o : snapshot) {
            out.writeObject(o);
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object[] snapshot = new Object[in.readInt()];
        for (int i = 0; i < snapshot.length; ++i) {
            snapshot[i] = in.readObject();
        }
        this.elements = snapshot;
    }

    static class CowIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private final int from;
        private final int to;
        private int index = 0;

        CowIterator(Object[] snapshot, int from, int to) {
            this.snapshot = snapshot;
            this.from = from;
            this.to = to;
            this.index = from;
        }

        @Override
        public void add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.to;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > this.from;
        }

        @Override
        public E next() {
            if (this.index < this.to) {
                return (E)this.snapshot[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public E previous() {
            if (this.index > this.from) {
                return (E)this.snapshot[--this.index];
            }
            throw new NoSuchElementException();
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E object) {
            throw new UnsupportedOperationException();
        }
    }

    class CowSubList
    extends AbstractList<E> {
        private volatile Slice slice;

        public CowSubList(Object[] expectedElements, int from, int to) {
            this.slice = new Slice(expectedElements, from, to);
        }

        @Override
        public int size() {
            Slice slice = this.slice;
            return slice.to - slice.from;
        }

        @Override
        public boolean isEmpty() {
            Slice slice = this.slice;
            return slice.from == slice.to;
        }

        @Override
        public E get(int index) {
            Slice slice = this.slice;
            Object[] snapshot = CopyOnWriteArrayList.this.elements;
            slice.checkElementIndex(index);
            slice.checkConcurrentModification(snapshot);
            return snapshot[index + slice.from];
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            Slice slice = this.slice;
            Object[] snapshot = CopyOnWriteArrayList.this.elements;
            slice.checkPositionIndex(index);
            slice.checkConcurrentModification(snapshot);
            CowIterator result = new CowIterator(snapshot, slice.from, slice.to);
            result.index = slice.from + index;
            return result;
        }

        @Override
        public int indexOf(Object object) {
            Slice slice = this.slice;
            Object[] snapshot = CopyOnWriteArrayList.this.elements;
            slice.checkConcurrentModification(snapshot);
            int result = CopyOnWriteArrayList.indexOf(object, snapshot, slice.from, slice.to);
            return result != -1 ? result - slice.from : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            Slice slice = this.slice;
            Object[] snapshot = CopyOnWriteArrayList.this.elements;
            slice.checkConcurrentModification(snapshot);
            int result = CopyOnWriteArrayList.lastIndexOf(object, snapshot, slice.from, slice.to);
            return result != -1 ? result - slice.from : -1;
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Slice slice = this.slice;
            Object[] snapshot = CopyOnWriteArrayList.this.elements;
            slice.checkConcurrentModification(snapshot);
            return CopyOnWriteArrayList.containsAll(collection, snapshot, slice.from, slice.to);
        }

        @Override
        public List<E> subList(int from, int to) {
            Slice slice = this.slice;
            if (from < 0 || from > to || to > this.size()) {
                throw new IndexOutOfBoundsException("from=" + from + ", to=" + to + ", list size=" + this.size());
            }
            return new CowSubList(slice.expectedElements, slice.from + from, slice.from + to);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.slice.checkElementIndex(index);
                this.slice.checkConcurrentModification(CopyOnWriteArrayList.this.elements);
                Object removed = CopyOnWriteArrayList.this.remove(this.slice.from + index);
                this.slice = new Slice(CopyOnWriteArrayList.this.elements, this.slice.from, this.slice.to - 1);
                return removed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.slice.checkConcurrentModification(CopyOnWriteArrayList.this.elements);
                CopyOnWriteArrayList.this.removeRange(this.slice.from, this.slice.to);
                this.slice = new Slice(CopyOnWriteArrayList.this.elements, this.slice.from, this.slice.from);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E object) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.slice.checkPositionIndex(index);
                this.slice.checkConcurrentModification(CopyOnWriteArrayList.this.elements);
                CopyOnWriteArrayList.this.add(index + this.slice.from, object);
                this.slice = new Slice(CopyOnWriteArrayList.this.elements, this.slice.from, this.slice.to + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E object) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.add(this.slice.to - this.slice.from, object);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> collection) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.slice.checkPositionIndex(index);
                this.slice.checkConcurrentModification(CopyOnWriteArrayList.this.elements);
                int oldSize = CopyOnWriteArrayList.this.elements.length;
                boolean result = CopyOnWriteArrayList.this.addAll(index + this.slice.from, collection);
                this.slice = new Slice(CopyOnWriteArrayList.this.elements, this.slice.from, this.slice.to + (CopyOnWriteArrayList.this.elements.length - oldSize));
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                return this.addAll(this.size(), collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E object) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.slice.checkElementIndex(index);
                this.slice.checkConcurrentModification(CopyOnWriteArrayList.this.elements);
                Object result = CopyOnWriteArrayList.this.set(index + this.slice.from, object);
                this.slice = new Slice(CopyOnWriteArrayList.this.elements, this.slice.from, this.slice.to);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                int index = this.indexOf(object);
                if (index == -1) {
                    return false;
                }
                this.remove(index);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.slice.checkConcurrentModification(CopyOnWriteArrayList.this.elements);
                int removed = CopyOnWriteArrayList.this.removeOrRetain(collection, false, this.slice.from, this.slice.to);
                this.slice = new Slice(CopyOnWriteArrayList.this.elements, this.slice.from, this.slice.to - removed);
                return removed != 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.slice.checkConcurrentModification(CopyOnWriteArrayList.this.elements);
                int removed = CopyOnWriteArrayList.this.removeOrRetain(collection, true, this.slice.from, this.slice.to);
                this.slice = new Slice(CopyOnWriteArrayList.this.elements, this.slice.from, this.slice.to - removed);
                return removed != 0;
            }
        }
    }

    static class Slice {
        private final Object[] expectedElements;
        private final int from;
        private final int to;

        Slice(Object[] expectedElements, int from, int to) {
            this.expectedElements = expectedElements;
            this.from = from;
            this.to = to;
        }

        void checkElementIndex(int index) {
            if (index < 0 || index >= this.to - this.from) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=" + (this.to - this.from));
            }
        }

        void checkPositionIndex(int index) {
            if (index < 0 || index > this.to - this.from) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=" + (this.to - this.from));
            }
        }

        void checkConcurrentModification(Object[] snapshot) {
            if (this.expectedElements != snapshot) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

