/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import libcore.io.Streams;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    static final String META_DIR = "META-INF/";
    private Manifest manifest;
    private ZipEntry manifestEntry;
    JarVerifier verifier;
    private boolean closed = false;

    public JarFile(File file) throws IOException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws IOException {
        super(file);
        if (verify) {
            this.verifier = new JarVerifier(file.getPath());
        }
        this.readMetaEntries();
    }

    public JarFile(File file, boolean verify, int mode) throws IOException {
        super(file, mode);
        if (verify) {
            this.verifier = new JarVerifier(file.getPath());
        }
        this.readMetaEntries();
    }

    public JarFile(String filename) throws IOException {
        this(filename, true);
    }

    public JarFile(String filename, boolean verify) throws IOException {
        super(filename);
        if (verify) {
            this.verifier = new JarVerifier(filename);
        }
        this.readMetaEntries();
    }

    public Enumeration<JarEntry> entries() {
        class JarFileEnumerator
        implements Enumeration<JarEntry> {
            Enumeration<? extends ZipEntry> ze;
            JarFile jf;

            JarFileEnumerator(Enumeration<? extends ZipEntry> zenum, JarFile jf) {
                this.ze = zenum;
                this.jf = jf;
            }

            @Override
            public boolean hasMoreElements() {
                return this.ze.hasMoreElements();
            }

            @Override
            public JarEntry nextElement() {
                JarEntry je = new JarEntry(this.ze.nextElement());
                je.parentJar = this.jf;
                return je;
            }
        }
        return new JarFileEnumerator(super.entries(), this);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public Manifest getManifest() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("JarFile has been closed");
        }
        if (this.manifest != null) {
            return this.manifest;
        }
        try {
            InputStream is = super.getInputStream(this.manifestEntry);
            if (this.verifier != null) {
                this.verifier.addMetaEntry(this.manifestEntry.getName(), Streams.readFully(is));
                is = super.getInputStream(this.manifestEntry);
            }
            try {
                this.manifest = new Manifest(is, this.verifier != null);
            }
            finally {
                is.close();
            }
            this.manifestEntry = null;
        }
        catch (NullPointerException e) {
            this.manifestEntry = null;
        }
        return this.manifest;
    }

    private void readMetaEntries() throws IOException {
        ZipEntry[] metaEntries = this.getMetaEntriesImpl();
        if (metaEntries == null) {
            this.verifier = null;
            return;
        }
        boolean signed = false;
        for (ZipEntry entry : metaEntries) {
            String entryName = entry.getName();
            if (this.manifestEntry == null && entryName.equalsIgnoreCase(MANIFEST_NAME)) {
                this.manifestEntry = entry;
                if (this.verifier != null) continue;
                break;
            }
            if (this.verifier == null || !JarFile.endsWithIgnoreCase(entryName, ".SF") && !JarFile.endsWithIgnoreCase(entryName, ".DSA") && !JarFile.endsWithIgnoreCase(entryName, ".RSA") && !JarFile.endsWithIgnoreCase(entryName, ".EC")) continue;
            signed = true;
            InputStream is = super.getInputStream(entry);
            this.verifier.addMetaEntry(entryName, Streams.readFully(is));
        }
        if (!signed) {
            this.verifier = null;
        }
    }

    private static boolean endsWithIgnoreCase(String s, String suffix) {
        return s.regionMatches(true, s.length() - suffix.length(), suffix, 0, suffix.length());
    }

    @Override
    public InputStream getInputStream(ZipEntry ze) throws IOException {
        InputStream in;
        if (this.manifestEntry != null) {
            this.getManifest();
        }
        if (this.verifier != null) {
            this.verifier.setManifest(this.getManifest());
            if (this.manifest != null) {
                this.verifier.mainAttributesEnd = this.manifest.getMainAttributesEnd();
            }
            if (this.verifier.readCertificates()) {
                this.verifier.removeMetaEntries();
                if (this.manifest != null) {
                    this.manifest.removeChunks();
                }
                if (!this.verifier.isSignedJar()) {
                    this.verifier = null;
                }
            }
        }
        if ((in = super.getInputStream(ze)) == null) {
            return null;
        }
        if (this.verifier == null || ze.getSize() == -1L) {
            return in;
        }
        JarVerifier.VerifierEntry entry = this.verifier.initEntry(ze.getName());
        if (entry == null) {
            return in;
        }
        return new JarFileInputStream(in, ze, entry);
    }

    @Override
    public ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        if (ze == null) {
            return ze;
        }
        JarEntry je = new JarEntry(ze);
        je.parentJar = this;
        return je;
    }

    private ZipEntry[] getMetaEntriesImpl() {
        ArrayList<ZipEntry> list = new ArrayList<ZipEntry>(8);
        Enumeration<JarEntry> allEntries = this.entries();
        while (allEntries.hasMoreElements()) {
            ZipEntry ze = allEntries.nextElement();
            if (!ze.getName().startsWith(META_DIR) || ze.getName().length() <= META_DIR.length()) continue;
            list.add(ze);
        }
        if (list.size() == 0) {
            return null;
        }
        ZipEntry[] result = new ZipEntry[list.size()];
        list.toArray(result);
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    static final class JarFileInputStream
    extends FilterInputStream {
        private long count;
        private ZipEntry zipEntry;
        private JarVerifier.VerifierEntry entry;
        private boolean done = false;

        JarFileInputStream(InputStream is, ZipEntry ze, JarVerifier.VerifierEntry e) {
            super(is);
            this.zipEntry = ze;
            this.count = this.zipEntry.getSize();
            this.entry = e;
        }

        @Override
        public int read() throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read();
                if (r != -1) {
                    this.entry.write(r);
                    --this.count;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                    this.entry.verify();
                }
                return r;
            }
            this.done = true;
            this.entry.verify();
            return -1;
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read(buffer, byteOffset, byteCount);
                if (r != -1) {
                    int size = r;
                    if (this.count < (long)size) {
                        size = (int)this.count;
                    }
                    this.entry.write(buffer, byteOffset, size);
                    this.count -= (long)size;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                    this.entry.verify();
                }
                return r;
            }
            this.done = true;
            this.entry.verify();
            return -1;
        }

        @Override
        public int available() throws IOException {
            if (this.done) {
                return 0;
            }
            return super.available();
        }

        @Override
        public long skip(long byteCount) throws IOException {
            return Streams.skipByReading(this, byteCount);
        }
    }
}

