/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import java.util.Map;
import java.util.TreeMap;
import org.apache.harmony.xml.dom.AttrImpl;
import org.apache.harmony.xml.dom.CDATASectionImpl;
import org.apache.harmony.xml.dom.CommentImpl;
import org.apache.harmony.xml.dom.DOMErrorImpl;
import org.apache.harmony.xml.dom.ElementImpl;
import org.apache.harmony.xml.dom.ProcessingInstructionImpl;
import org.apache.harmony.xml.dom.TextImpl;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DOMConfigurationImpl
implements DOMConfiguration {
    private static final Map<String, Parameter> PARAMETERS = new TreeMap<String, Parameter>(String.CASE_INSENSITIVE_ORDER);
    private boolean cdataSections = true;
    private boolean comments = true;
    private boolean datatypeNormalization = false;
    private boolean entities = true;
    private DOMErrorHandler errorHandler;
    private boolean namespaces = true;
    private String schemaLocation;
    private String schemaType;
    private boolean splitCdataSections = true;
    private boolean validate = false;
    private boolean wellFormed = true;

    @Override
    public boolean canSetParameter(String name, Object value) {
        Parameter parameter = PARAMETERS.get(name);
        return parameter != null && parameter.canSet(this, value);
    }

    @Override
    public void setParameter(String name, Object value) throws DOMException {
        Parameter parameter = PARAMETERS.get(name);
        if (parameter == null) {
            throw new DOMException(8, "No such parameter: " + name);
        }
        try {
            parameter.set(this, value);
        }
        catch (NullPointerException e) {
            throw new DOMException(17, "Null not allowed for " + name);
        }
        catch (ClassCastException e) {
            throw new DOMException(17, "Invalid type for " + name + ": " + value.getClass());
        }
    }

    @Override
    public Object getParameter(String name) throws DOMException {
        Parameter parameter = PARAMETERS.get(name);
        if (parameter == null) {
            throw new DOMException(8, "No such parameter: " + name);
        }
        return parameter.get(this);
    }

    @Override
    public DOMStringList getParameterNames() {
        final String[] result = PARAMETERS.keySet().toArray(new String[PARAMETERS.size()]);
        return new DOMStringList(){
            final /* synthetic */ DOMConfigurationImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String item(int index) {
                return index < result.length ? result[index] : null;
            }

            @Override
            public int getLength() {
                return result.length;
            }

            @Override
            public boolean contains(String str) {
                return PARAMETERS.containsKey(str);
            }
        };
    }

    public void normalize(Node node) {
        switch (node.getNodeType()) {
            case 4: {
                CDATASectionImpl cdata = (CDATASectionImpl)node;
                if (this.cdataSections) {
                    if (cdata.needsSplitting()) {
                        if (this.splitCdataSections) {
                            cdata.split();
                            this.report((short)1, "cdata-sections-splitted");
                        } else {
                            this.report((short)2, "wf-invalid-character");
                        }
                    }
                    this.checkTextValidity(cdata.buffer);
                    break;
                }
                node = cdata.replaceWithText();
            }
            case 3: {
                TextImpl text = (TextImpl)node;
                text = text.minimize();
                if (text == null) break;
                this.checkTextValidity(text.buffer);
                break;
            }
            case 8: {
                CommentImpl comment = (CommentImpl)node;
                if (!this.comments) {
                    comment.getParentNode().removeChild(comment);
                    break;
                }
                if (comment.containsDashDash()) {
                    this.report((short)2, "wf-invalid-character");
                }
                this.checkTextValidity(comment.buffer);
                break;
            }
            case 7: {
                this.checkTextValidity(((ProcessingInstructionImpl)node).getData());
                break;
            }
            case 2: {
                this.checkTextValidity(((AttrImpl)node).getValue());
                break;
            }
            case 1: {
                ElementImpl element = (ElementImpl)node;
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.normalize(attributes.item(i));
                }
            }
            case 9: 
            case 11: {
                Node child = node.getFirstChild();
                while (child != null) {
                    Node next = child.getNextSibling();
                    this.normalize(child);
                    child = next;
                }
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                break;
            }
            default: {
                throw new DOMException(9, "Unsupported node type " + node.getNodeType());
            }
        }
    }

    private void checkTextValidity(CharSequence s) {
        if (this.wellFormed && !this.isValid(s)) {
            this.report((short)2, "wf-invalid-character");
        }
    }

    private boolean isValid(CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            boolean valid;
            char c = text.charAt(i);
            boolean bl = valid = c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
            if (valid) continue;
            return false;
        }
        return true;
    }

    private void report(short severity, String type) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(new DOMErrorImpl(severity, type));
        }
    }

    static {
        PARAMETERS.put("canonical-form", new FixedParameter(false));
        PARAMETERS.put("cdata-sections", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.cdataSections;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.cdataSections = (Boolean)value;
            }
        });
        PARAMETERS.put("check-character-normalization", new FixedParameter(false));
        PARAMETERS.put("comments", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.comments;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.comments = (Boolean)value;
            }
        });
        PARAMETERS.put("datatype-normalization", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.datatypeNormalization;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                if (((Boolean)value).booleanValue()) {
                    config.datatypeNormalization = true;
                    config.validate = true;
                } else {
                    config.datatypeNormalization = false;
                }
            }
        });
        PARAMETERS.put("element-content-whitespace", new FixedParameter(true));
        PARAMETERS.put("entities", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.entities;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.entities = (Boolean)value;
            }
        });
        PARAMETERS.put("error-handler", new Parameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.errorHandler;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.errorHandler = (DOMErrorHandler)value;
            }

            @Override
            public boolean canSet(DOMConfigurationImpl config, Object value) {
                return value == null || value instanceof DOMErrorHandler;
            }
        });
        PARAMETERS.put("infoset", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return !config.entities && !config.datatypeNormalization && !config.cdataSections && config.wellFormed && config.comments && config.namespaces;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                if (((Boolean)value).booleanValue()) {
                    config.entities = false;
                    config.datatypeNormalization = false;
                    config.cdataSections = false;
                    config.wellFormed = true;
                    config.comments = true;
                    config.namespaces = true;
                }
            }
        });
        PARAMETERS.put("namespaces", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.namespaces;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.namespaces = (Boolean)value;
            }
        });
        PARAMETERS.put("namespace-declarations", new FixedParameter(true));
        PARAMETERS.put("normalize-characters", new FixedParameter(false));
        PARAMETERS.put("schema-location", new Parameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.schemaLocation;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.schemaLocation = (String)value;
            }

            @Override
            public boolean canSet(DOMConfigurationImpl config, Object value) {
                return value == null || value instanceof String;
            }
        });
        PARAMETERS.put("schema-type", new Parameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.schemaType;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.schemaType = (String)value;
            }

            @Override
            public boolean canSet(DOMConfigurationImpl config, Object value) {
                return value == null || value instanceof String;
            }
        });
        PARAMETERS.put("split-cdata-sections", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.splitCdataSections;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.splitCdataSections = (Boolean)value;
            }
        });
        PARAMETERS.put("validate", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.validate;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.validate = (Boolean)value;
            }
        });
        PARAMETERS.put("validate-if-schema", new FixedParameter(false));
        PARAMETERS.put("well-formed", new BooleanParameter(){

            @Override
            public Object get(DOMConfigurationImpl config) {
                return config.wellFormed;
            }

            @Override
            public void set(DOMConfigurationImpl config, Object value) {
                config.wellFormed = (Boolean)value;
            }
        });
    }

    static interface Parameter {
        public Object get(DOMConfigurationImpl var1);

        public void set(DOMConfigurationImpl var1, Object var2);

        public boolean canSet(DOMConfigurationImpl var1, Object var2);
    }

    static class FixedParameter
    implements Parameter {
        final Object onlyValue;

        FixedParameter(Object onlyValue) {
            this.onlyValue = onlyValue;
        }

        @Override
        public Object get(DOMConfigurationImpl config) {
            return this.onlyValue;
        }

        @Override
        public void set(DOMConfigurationImpl config, Object value) {
            if (!this.onlyValue.equals(value)) {
                throw new DOMException(9, "Unsupported value: " + value);
            }
        }

        @Override
        public boolean canSet(DOMConfigurationImpl config, Object value) {
            return this.onlyValue.equals(value);
        }
    }

    static abstract class BooleanParameter
    implements Parameter {
        BooleanParameter() {
        }

        @Override
        public boolean canSet(DOMConfigurationImpl config, Object value) {
            return value instanceof Boolean;
        }
    }
}

