/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import org.apache.harmony.xml.dom.CharacterDataImpl;
import org.apache.harmony.xml.dom.DocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements Text {
    public TextImpl(DocumentImpl document, String data) {
        super(document, data);
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public final Text splitText(int offset) throws DOMException {
        TextImpl newText = this.document.createTextNode(this.substringData(offset, this.getLength() - offset));
        this.deleteData(0, offset);
        Node refNode = this.getNextSibling();
        if (refNode == null) {
            this.getParentNode().appendChild(newText);
        } else {
            this.getParentNode().insertBefore(newText, refNode);
        }
        return this;
    }

    @Override
    public final boolean isElementContentWhitespace() {
        return false;
    }

    @Override
    public final String getWholeText() {
        StringBuilder result = new StringBuilder();
        for (TextImpl n = this.firstTextNodeInCurrentRun(); n != null; n = n.nextTextNode()) {
            n.appendDataTo(result);
        }
        return result.toString();
    }

    @Override
    public final Text replaceWholeText(String content) throws DOMException {
        Node parent = this.getParentNode();
        TextImpl result = null;
        TextImpl n = this.firstTextNodeInCurrentRun();
        while (n != null) {
            if (n == this && content != null && content.length() > 0) {
                this.setData(content);
                result = this;
                n = n.nextTextNode();
                continue;
            }
            TextImpl toRemove = n;
            n = n.nextTextNode();
            parent.removeChild(toRemove);
        }
        return result;
    }

    private TextImpl firstTextNodeInCurrentRun() {
        short nodeType;
        TextImpl firstTextInCurrentRun = this;
        for (Node p = this.getPreviousSibling(); p != null && ((nodeType = p.getNodeType()) == 3 || nodeType == 4); p = p.getPreviousSibling()) {
            firstTextInCurrentRun = (TextImpl)p;
        }
        return firstTextInCurrentRun;
    }

    private TextImpl nextTextNode() {
        Node nextSibling = this.getNextSibling();
        if (nextSibling == null) {
            return null;
        }
        short nodeType = nextSibling.getNodeType();
        return nodeType == 3 || nodeType == 4 ? (TextImpl)nextSibling : null;
    }

    public final TextImpl minimize() {
        if (this.getLength() == 0) {
            this.parent.removeChild(this);
            return null;
        }
        Node previous = this.getPreviousSibling();
        if (previous == null || previous.getNodeType() != 3) {
            return this;
        }
        TextImpl previousText = (TextImpl)previous;
        previousText.buffer.append(this.buffer);
        this.parent.removeChild(this);
        return previousText;
    }
}

