/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Blob;
import java.io.IOException;
import java.io.InputStream;

class BlobR
extends InputStream {
    private Blob blob;
    private int pos;

    BlobR(Blob blob) {
        this.blob = blob;
        this.pos = 0;
    }

    @Override
    public int available() throws IOException {
        int ret = this.blob.size - this.pos;
        return ret < 0 ? 0 : ret;
    }

    @Override
    public void mark(int limit) {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.blob.close();
        this.blob = null;
        this.pos = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = (long)this.pos + n;
        if (ret < 0L) {
            ret = 0L;
            this.pos = 0;
        } else if (ret > (long)this.blob.size) {
            ret = this.blob.size;
            this.pos = this.blob.size;
        } else {
            this.pos = (int)ret;
        }
        return ret;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int n = this.blob.read(b, 0, this.pos, b.length);
        if (n > 0) {
            this.pos += n;
            return b[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = this.blob.read(b, 0, this.pos, b.length);
        if (n > 0) {
            this.pos += n;
            return n;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off + len > b.length) {
            len = b.length - off;
        }
        if (len < 0) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        int n = this.blob.read(b, off, this.pos, len);
        if (n > 0) {
            this.pos += n;
            return n;
        }
        return -1;
    }
}

