/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;

public abstract class CharsetDecoder {
    private static final String RESET = "RESET";
    private static final String ONGOING = "ONGOING";
    private static final String END_OF_INPUT = "END_OF_INPUT";
    private static final String FLUSHED = "FLUSHED";
    private final Charset charset;
    private final float averageCharsPerByte;
    private final float maxCharsPerByte;
    private String replacementChars = "\ufffd";
    private String state = "RESET";
    private CodingErrorAction malformedInputAction = CodingErrorAction.REPORT;
    private CodingErrorAction unmappableCharacterAction = CodingErrorAction.REPORT;

    protected CharsetDecoder(Charset charset, float averageCharsPerByte, float maxCharsPerByte) {
        if (averageCharsPerByte <= 0.0f || maxCharsPerByte <= 0.0f) {
            throw new IllegalArgumentException("averageCharsPerByte and maxCharsPerByte must be positive");
        }
        if (averageCharsPerByte > maxCharsPerByte) {
            throw new IllegalArgumentException("averageCharsPerByte is greater than maxCharsPerByte");
        }
        this.averageCharsPerByte = averageCharsPerByte;
        this.maxCharsPerByte = maxCharsPerByte;
        this.charset = charset;
    }

    public final float averageCharsPerByte() {
        return this.averageCharsPerByte;
    }

    public final Charset charset() {
        return this.charset;
    }

    public final CharBuffer decode(ByteBuffer in) throws CharacterCodingException {
        int length = (int)((float)in.remaining() * this.averageCharsPerByte);
        CharBuffer out = CharBuffer.allocate(length);
        this.reset();
        while (this.state != FLUSHED) {
            CoderResult result = this.decode(in, out, true);
            if (result == CoderResult.OVERFLOW) {
                out = this.allocateMore(out);
                continue;
            }
            this.checkCoderResult(result);
            result = this.flush(out);
            if (result == CoderResult.OVERFLOW) {
                out = this.allocateMore(out);
                continue;
            }
            this.checkCoderResult(result);
        }
        out.flip();
        return out;
    }

    private void checkCoderResult(CoderResult result) throws CharacterCodingException {
        if (result.isMalformed() && this.malformedInputAction == CodingErrorAction.REPORT) {
            throw new MalformedInputException(result.length());
        }
        if (result.isUnmappable() && this.unmappableCharacterAction == CodingErrorAction.REPORT) {
            throw new UnmappableCharacterException(result.length());
        }
    }

    private CharBuffer allocateMore(CharBuffer output) {
        if (output.capacity() == 0) {
            return CharBuffer.allocate(1);
        }
        CharBuffer result = CharBuffer.allocate(output.capacity() * 2);
        output.flip();
        result.put(output);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final CoderResult decode(ByteBuffer in, CharBuffer out, boolean endOfInput) {
        if (!(this.state == RESET || this.state == ONGOING || endOfInput && this.state == END_OF_INPUT)) {
            throw this.illegalStateException();
        }
        this.state = endOfInput ? END_OF_INPUT : ONGOING;
        while (true) {
            CodingErrorAction action;
            CoderResult result;
            try {
                result = this.decodeLoop(in, out);
            }
            catch (BufferOverflowException ex) {
                throw new CoderMalfunctionError(ex);
            }
            catch (BufferUnderflowException ex) {
                throw new CoderMalfunctionError(ex);
            }
            if (result == CoderResult.UNDERFLOW) {
                if (!endOfInput || !in.hasRemaining()) return result;
                result = CoderResult.malformedForLength(in.remaining());
            } else if (result == CoderResult.OVERFLOW) {
                return result;
            }
            CodingErrorAction codingErrorAction = action = result.isUnmappable() ? this.unmappableCharacterAction : this.malformedInputAction;
            if (action == CodingErrorAction.REPORT) {
                return result;
            }
            if (action == CodingErrorAction.REPLACE) {
                if (out.remaining() < this.replacementChars.length()) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.replacementChars);
            }
            in.position(in.position() + result.length());
        }
    }

    protected abstract CoderResult decodeLoop(ByteBuffer var1, CharBuffer var2);

    public Charset detectedCharset() {
        throw new UnsupportedOperationException();
    }

    public final CoderResult flush(CharBuffer out) {
        if (this.state != FLUSHED && this.state != END_OF_INPUT) {
            throw this.illegalStateException();
        }
        CoderResult result = this.implFlush(out);
        if (result == CoderResult.UNDERFLOW) {
            this.state = FLUSHED;
        }
        return result;
    }

    protected CoderResult implFlush(CharBuffer out) {
        return CoderResult.UNDERFLOW;
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
    }

    protected void implReplaceWith(String newReplacement) {
    }

    protected void implReset() {
    }

    public boolean isAutoDetecting() {
        return false;
    }

    public boolean isCharsetDetected() {
        throw new UnsupportedOperationException();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final float maxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public final CharsetDecoder onMalformedInput(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("newAction == null");
        }
        this.malformedInputAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    public final CharsetDecoder onUnmappableCharacter(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("newAction == null");
        }
        this.unmappableCharacterAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    public final String replacement() {
        return this.replacementChars;
    }

    public final CharsetDecoder replaceWith(String replacement) {
        if (replacement == null) {
            throw new IllegalArgumentException("replacement == null");
        }
        if (replacement.isEmpty()) {
            throw new IllegalArgumentException("replacement.isEmpty()");
        }
        if ((float)replacement.length() > this.maxCharsPerByte()) {
            throw new IllegalArgumentException("replacement length > maxCharsPerByte: " + replacement.length() + " > " + this.maxCharsPerByte());
        }
        this.replacementChars = replacement;
        this.implReplaceWith(replacement);
        return this;
    }

    public final CharsetDecoder reset() {
        this.state = RESET;
        this.implReset();
        return this;
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    private IllegalStateException illegalStateException() {
        throw new IllegalStateException("State: " + this.state);
    }
}

