/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Format;

public class FieldPosition {
    private int myField;
    private int beginIndex;
    private int endIndex;
    private Format.Field myAttribute;

    public FieldPosition(int field) {
        this.myField = field;
    }

    public FieldPosition(Format.Field attribute) {
        this.myAttribute = attribute;
        this.myField = -1;
    }

    public FieldPosition(Format.Field attribute, int field) {
        this.myAttribute = attribute;
        this.myField = field;
    }

    void clear() {
        this.endIndex = 0;
        this.beginIndex = 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FieldPosition)) {
            return false;
        }
        FieldPosition pos = (FieldPosition)object;
        return this.myField == pos.myField && this.myAttribute == pos.myAttribute && this.beginIndex == pos.beginIndex && this.endIndex == pos.endIndex;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getField() {
        return this.myField;
    }

    public Format.Field getFieldAttribute() {
        return this.myAttribute;
    }

    public int hashCode() {
        int attributeHash = this.myAttribute == null ? 0 : this.myAttribute.hashCode();
        return attributeHash + this.myField * 10 + this.beginIndex * 100 + this.endIndex;
    }

    public void setBeginIndex(int index) {
        this.beginIndex = index;
    }

    public void setEndIndex(int index) {
        this.endIndex = index;
    }

    public String toString() {
        return this.getClass().getName() + "[attribute=" + this.myAttribute + ", field=" + this.myField + ", beginIndex=" + this.beginIndex + ", endIndex=" + this.endIndex + "]";
    }
}

