/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.IdleConnectionHandler;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPoolEntryRef;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RefQueueHandler;
import org.apache.http.impl.conn.tsccm.RefQueueWorker;

public abstract class AbstractConnPool
implements RefQueueHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final Lock poolLock;
    protected Set<BasicPoolEntryRef> issuedConnections = new HashSet<BasicPoolEntryRef>();
    protected IdleConnectionHandler idleConnHandler = new IdleConnectionHandler();
    protected int numConnections;
    protected ReferenceQueue<Object> refQueue;
    private RefQueueWorker refWorker;
    protected volatile boolean isShutDown;

    protected AbstractConnPool() {
        boolean fair = false;
        this.poolLock = new ReentrantLock(fair);
    }

    public void enableConnectionGC() throws IllegalStateException {
        if (this.refQueue != null) {
            throw new IllegalStateException("Connection GC already enabled.");
        }
        this.poolLock.lock();
        try {
            if (this.numConnections > 0) {
                throw new IllegalStateException("Pool already in use.");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        this.refQueue = new ReferenceQueue();
        this.refWorker = new RefQueueWorker(this.refQueue, this);
        Thread t = new Thread(this.refWorker);
        t.setDaemon(true);
        t.setName("RefQueueWorker@" + this);
        t.start();
    }

    public final BasicPoolEntry getEntry(HttpRoute route, Object state, long timeout, TimeUnit tunit) throws ConnectionPoolTimeoutException, InterruptedException {
        return this.requestPoolEntry(route, state).getPoolEntry(timeout, tunit);
    }

    public abstract PoolEntryRequest requestPoolEntry(HttpRoute var1, Object var2);

    public abstract void freeEntry(BasicPoolEntry var1, boolean var2, long var3, TimeUnit var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReference(Reference ref) {
        this.poolLock.lock();
        try {
            boolean lost;
            if (ref instanceof BasicPoolEntryRef && (lost = this.issuedConnections.remove(ref))) {
                HttpRoute route = ((BasicPoolEntryRef)ref).getRoute();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connection garbage collected. " + route);
                }
                this.handleLostEntry(route);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected abstract void handleLostEntry(HttpRoute var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        this.poolLock.lock();
        try {
            this.idleConnHandler.closeIdleConnections(tunit.toMillis(idletime));
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public void closeExpiredConnections() {
        this.poolLock.lock();
        try {
            this.idleConnHandler.closeExpiredConnections();
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public abstract void deleteClosedConnections();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.poolLock.lock();
        try {
            if (this.isShutDown) {
                return;
            }
            if (this.refWorker != null) {
                this.refWorker.shutdown();
            }
            Iterator<BasicPoolEntryRef> iter = this.issuedConnections.iterator();
            while (iter.hasNext()) {
                BasicPoolEntryRef per = iter.next();
                iter.remove();
                BasicPoolEntry entry = (BasicPoolEntry)per.get();
                if (entry == null) continue;
                this.closeConnection(entry.getConnection());
            }
            this.idleConnHandler.removeAll();
            this.isShutDown = true;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected void closeConnection(OperatedClientConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.log.debug("I/O error closing connection", ex);
            }
        }
    }
}

