/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Database;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCDriver
implements Driver {
    public static final int MAJORVERSION = 1;
    public static boolean sharedCache = false;
    public static String vfs = null;
    private static Constructor makeConn = null;
    protected Connection conn;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("sqlite:/") || url.startsWith("jdbc:sqlite:/");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Object[] args = new Object[5];
        args[0] = url;
        if (info != null) {
            args[1] = info.getProperty("encoding");
            args[2] = info.getProperty("password");
            args[3] = info.getProperty("daterepr");
            args[4] = info.getProperty("vfs");
        }
        if (args[1] == null) {
            args[1] = System.getProperty("SQLite.encoding");
        }
        if (args[4] == null) {
            args[4] = vfs;
        }
        try {
            this.conn = (Connection)makeConn.newInstance(args);
        }
        catch (InvocationTargetException ie) {
            throw new SQLException(ie.getTargetException().toString());
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        return this.conn;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 20100131;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo pp = new DriverPropertyInfo("encoding", "");
        pp = new DriverPropertyInfo("password", "");
        pp = new DriverPropertyInfo("daterepr", "normal");
        pp = new DriverPropertyInfo("vfs", vfs);
        DriverPropertyInfo[] p = new DriverPropertyInfo[]{pp, pp, pp, pp};
        return p;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            String cvers;
            Class[] args;
            Class<?> connClass = null;
            args = new Class[]{Class.forName("java.lang.String"), args[0], args[0], args[0], args[0]};
            String jvers = System.getProperty("java.version");
            if (jvers == null || jvers.startsWith("1.0")) {
                throw new Exception("unsupported java version");
            }
            if (jvers.startsWith("1.1")) {
                cvers = "SQLite.JDBC1.JDBCConnection";
            } else if (jvers.startsWith("1.2") || jvers.startsWith("1.3")) {
                cvers = "SQLite.JDBC2.JDBCConnection";
            } else if (jvers.startsWith("1.4")) {
                cvers = "SQLite.JDBC2x.JDBCConnection";
            } else if (jvers.startsWith("1.5")) {
                cvers = "SQLite.JDBC2y.JDBCConnection";
                try {
                    Class.forName(cvers);
                }
                catch (Exception e) {
                    cvers = "SQLite.JDBC2x.JDBCConnection";
                }
            } else {
                cvers = "SQLite.JDBC2z.JDBCConnection";
                try {
                    Class.forName(cvers);
                }
                catch (Exception e) {
                    cvers = "SQLite.JDBC2y.JDBCConnection";
                    try {
                        Class.forName(cvers);
                    }
                    catch (Exception ee) {
                        cvers = "SQLite.JDBC2x.JDBCConnection";
                    }
                }
            }
            connClass = Class.forName(cvers);
            makeConn = connClass.getConstructor(args);
            DriverManager.registerDriver(new JDBCDriver());
            try {
                String shcache = System.getProperty("SQLite.sharedcache");
                if (shcache != null && (shcache.startsWith("y") || shcache.startsWith("Y"))) {
                    sharedCache = Database._enable_shared_cache(true);
                }
            }
            catch (Exception shcache) {
                // empty catch block
            }
            try {
                String tvfs = System.getProperty("SQLite.vfs");
                if (tvfs != null) {
                    vfs = tvfs;
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

