/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.Failure;
import com.android.okhttp.Request;
import com.android.okhttp.internal.Util;
import com.android.okhttp.internal.http.RawHeaders;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;

public final class Response {
    private final Request request;
    private final int code;
    private final RawHeaders headers;
    private final Body body;
    private final Response redirectedBy;

    private Response(Builder builder) {
        this.request = builder.request;
        this.code = builder.code;
        this.headers = new RawHeaders(builder.headers);
        this.body = builder.body;
        this.redirectedBy = builder.redirectedBy;
    }

    public Request request() {
        return this.request;
    }

    public int code() {
        return this.code;
    }

    public String header(String name) {
        return this.header(name, null);
    }

    public String header(String name, String defaultValue) {
        String result = this.headers.get(name);
        return result != null ? result : defaultValue;
    }

    public List<String> headers(String name) {
        return this.headers.values(name);
    }

    public Set<String> headerNames() {
        return this.headers.names();
    }

    public int headerCount() {
        return this.headers.length();
    }

    public String headerName(int index) {
        return this.headers.getFieldName(index);
    }

    public String headerValue(int index) {
        return this.headers.getValue(index);
    }

    public Body body() {
        return this.body;
    }

    public Response redirectedBy() {
        return this.redirectedBy;
    }

    public static class Builder {
        private final Request request;
        private final int code;
        private final RawHeaders headers = new RawHeaders();
        private Body body;
        private Response redirectedBy;

        public Builder(Request request, int code) {
            if (request == null) {
                throw new IllegalArgumentException("request == null");
            }
            if (code <= 0) {
                throw new IllegalArgumentException("code <= 0");
            }
            this.request = request;
            this.code = code;
        }

        public Builder header(String name, String value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder body(Body body) {
            this.body = body;
            return this;
        }

        public Builder redirectedBy(Response redirectedBy) {
            this.redirectedBy = redirectedBy;
            return this;
        }

        public Response build() {
            if (this.request == null) {
                throw new IllegalStateException("Response has no request.");
            }
            if (this.code == -1) {
                throw new IllegalStateException("Response has no code.");
            }
            return new Response(this);
        }
    }

    public static interface Receiver {
        public void onFailure(Failure var1);

        public void onResponse(Response var1) throws IOException;
    }

    public static abstract class Body {
        public String contentType() {
            return null;
        }

        public long contentLength() {
            return -1L;
        }

        public abstract InputStream byteStream() throws IOException;

        public byte[] bytes() throws IOException {
            long contentLength = this.contentLength();
            if (contentLength > Integer.MAX_VALUE) {
                throw new IOException("Cannot buffer entire body for content length: " + contentLength);
            }
            if (contentLength != -1L) {
                byte[] content = new byte[(int)contentLength];
                InputStream in = this.byteStream();
                Util.readFully(in, content);
                if (in.read() != -1) {
                    throw new IOException("Content-Length and stream length disagree");
                }
                return content;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Util.copy(this.byteStream(), out);
            return out.toByteArray();
        }

        public Reader charStream() throws IOException {
            return new InputStreamReader(this.byteStream(), "UTF-8");
        }

        public String string() throws IOException {
            return new String(this.bytes(), "UTF-8");
        }
    }
}

