/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal;

import com.android.okhttp.internal.AbstractOutputStream;
import com.android.okhttp.internal.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class FaultRecoveringOutputStream
extends AbstractOutputStream {
    private final int maxReplayBufferLength;
    private ByteArrayOutputStream replayBuffer;
    private OutputStream out;

    public FaultRecoveringOutputStream(int maxReplayBufferLength, OutputStream out) {
        if (maxReplayBufferLength < 0) {
            throw new IllegalArgumentException();
        }
        this.maxReplayBufferLength = maxReplayBufferLength;
        this.replayBuffer = new ByteArrayOutputStream(maxReplayBufferLength);
        this.out = out;
    }

    @Override
    public final void write(byte[] buffer, int offset, int count) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        Util.checkOffsetAndCount(buffer.length, offset, count);
        while (true) {
            try {
                this.out.write(buffer, offset, count);
                if (this.replayBuffer != null) {
                    if (count + this.replayBuffer.size() > this.maxReplayBufferLength) {
                        this.replayBuffer = null;
                    } else {
                        this.replayBuffer.write(buffer, offset, count);
                    }
                }
                return;
            }
            catch (IOException e) {
                if (this.recover(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this.closed) {
            return;
        }
        while (true) {
            try {
                this.out.flush();
                return;
            }
            catch (IOException e) {
                if (this.recover(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            return;
        }
        while (true) {
            try {
                this.out.close();
                this.closed = true;
                return;
            }
            catch (IOException e) {
                if (this.recover(e)) continue;
                throw e;
            }
            break;
        }
    }

    private boolean recover(IOException e) {
        if (this.replayBuffer == null) {
            return false;
        }
        while (true) {
            OutputStream replacementStream = null;
            try {
                replacementStream = this.replacementStream(e);
                if (replacementStream == null) {
                    return false;
                }
                this.replaceStream(replacementStream);
                return true;
            }
            catch (IOException replacementStreamFailure) {
                Util.closeQuietly(replacementStream);
                e = replacementStreamFailure;
                continue;
            }
            break;
        }
    }

    public boolean isRecoverable() {
        return this.replayBuffer != null;
    }

    public final void replaceStream(OutputStream replacementStream) throws IOException {
        if (!this.isRecoverable()) {
            throw new IllegalStateException();
        }
        if (this.out == replacementStream) {
            return;
        }
        this.replayBuffer.writeTo(replacementStream);
        Util.closeQuietly(this.out);
        this.out = replacementStream;
    }

    protected abstract OutputStream replacementStream(IOException var1) throws IOException;
}

