/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public class Modifier {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    public static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;
    public static final int MIRANDA = 32768;
    public static final int CONSTRUCTOR = 65536;

    public static int classModifiers() {
        return 3103;
    }

    public static int constructorModifiers() {
        return 7;
    }

    public static int fieldModifiers() {
        return 223;
    }

    public static int interfaceModifiers() {
        return 3087;
    }

    public static int methodModifiers() {
        return 3391;
    }

    public static boolean isAbstract(int modifiers) {
        return (modifiers & 0x400) != 0;
    }

    public static boolean isFinal(int modifiers) {
        return (modifiers & 0x10) != 0;
    }

    public static boolean isInterface(int modifiers) {
        return (modifiers & 0x200) != 0;
    }

    public static boolean isNative(int modifiers) {
        return (modifiers & 0x100) != 0;
    }

    public static boolean isPrivate(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static boolean isProtected(int modifiers) {
        return (modifiers & 4) != 0;
    }

    public static boolean isPublic(int modifiers) {
        return (modifiers & 1) != 0;
    }

    public static boolean isStatic(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static boolean isStrict(int modifiers) {
        return (modifiers & 0x800) != 0;
    }

    public static boolean isSynchronized(int modifiers) {
        return (modifiers & 0x20) != 0;
    }

    public static boolean isTransient(int modifiers) {
        return (modifiers & 0x80) != 0;
    }

    public static boolean isVolatile(int modifiers) {
        return (modifiers & 0x40) != 0;
    }

    public static boolean isConstructor(int modifiers) {
        return (modifiers & 0x10000) != 0;
    }

    public static String toString(int modifiers) {
        StringBuilder buf = new StringBuilder();
        if (Modifier.isPublic(modifiers)) {
            buf.append("public ");
        }
        if (Modifier.isProtected(modifiers)) {
            buf.append("protected ");
        }
        if (Modifier.isPrivate(modifiers)) {
            buf.append("private ");
        }
        if (Modifier.isAbstract(modifiers)) {
            buf.append("abstract ");
        }
        if (Modifier.isStatic(modifiers)) {
            buf.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            buf.append("final ");
        }
        if (Modifier.isTransient(modifiers)) {
            buf.append("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            buf.append("volatile ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            buf.append("synchronized ");
        }
        if (Modifier.isNative(modifiers)) {
            buf.append("native ");
        }
        if (Modifier.isStrict(modifiers)) {
            buf.append("strictfp ");
        }
        if (Modifier.isInterface(modifiers)) {
            buf.append("interface ");
        }
        if (buf.length() == 0) {
            return "";
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }
}

