/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import libcore.util.Objects;

public class HashMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Map.Entry[] EMPTY_TABLE = new HashMapEntry[2];
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient HashMapEntry<K, V>[] table;
    transient HashMapEntry<K, V> entryForNullKey;
    transient int size;
    transient int modCount;
    private transient int threshold;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient Collection<V> values;
    private static final long serialVersionUID = 362498820763181265L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("loadFactor", Float.TYPE)};

    public HashMap() {
        this.table = (HashMapEntry[])EMPTY_TABLE;
        this.threshold = -1;
    }

    public HashMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity: " + capacity);
        }
        if (capacity == 0) {
            HashMapEntry[] tab = (HashMapEntry[])EMPTY_TABLE;
            this.table = tab;
            this.threshold = -1;
            return;
        }
        capacity = capacity < 4 ? 4 : (capacity > 0x40000000 ? 0x40000000 : Collections.roundUpToPowerOfTwo(capacity));
        this.makeTable(capacity);
    }

    public HashMap(int capacity, float loadFactor) {
        this(capacity);
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor: " + loadFactor);
        }
    }

    public HashMap(Map<? extends K, ? extends V> map) {
        this(HashMap.capacityForInitSize(map.size()));
        this.constructorPutAll(map);
    }

    final void constructorPutAll(Map<? extends K, ? extends V> map) {
        if (this.table == EMPTY_TABLE) {
            this.doubleCapacity();
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.constructorPut(e.getKey(), e.getValue());
        }
    }

    static int capacityForInitSize(int size) {
        int result = (size >> 1) + size;
        return (result & 0xC0000000) == 0 ? result : 0x40000000;
    }

    @Override
    public Object clone() {
        HashMap result;
        try {
            result = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        result.makeTable(this.table.length);
        result.entryForNullKey = null;
        result.size = 0;
        result.keySet = null;
        result.entrySet = null;
        result.values = null;
        result.init();
        result.constructorPutAll(this);
        return result;
    }

    void init() {
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            HashMapEntry<K, V> e = this.entryForNullKey;
            return e == null ? null : (V)e.value;
        }
        int hash = key.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        HashMapEntry<K, V>[] tab = this.table;
        HashMapEntry<K, V> e = tab[hash & tab.length - 1];
        while (e != null) {
            Object eKey = e.key;
            if (eKey == key || e.hash == hash && key.equals(eKey)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.entryForNullKey != null;
        }
        int hash = key.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        HashMapEntry<K, V>[] tab = this.table;
        HashMapEntry<K, V> e = tab[hash & tab.length - 1];
        while (e != null) {
            Object eKey = e.key;
            if (eKey == key || e.hash == hash && key.equals(eKey)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    static int secondaryHash(Object key) {
        int hash = key.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    @Override
    public boolean containsValue(Object value) {
        HashMapEntry<K, V>[] tab = this.table;
        int len = tab.length;
        if (value == null) {
            for (int i = 0; i < len; ++i) {
                HashMapEntry<K, V> e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return this.entryForNullKey != null && this.entryForNullKey.value == null;
        }
        for (int i = 0; i < len; ++i) {
            HashMapEntry<K, V> e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return this.entryForNullKey != null && value.equals(this.entryForNullKey.value);
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            return this.putValueForNullKey(value);
        }
        int hash = HashMap.secondaryHash(key);
        HashMapEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashMapEntry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && key.equals(e.key)) {
                this.preModify(e);
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.size++ > this.threshold) {
            tab = this.doubleCapacity();
            index = hash & tab.length - 1;
        }
        this.addNewEntry(key, value, hash, index);
        return null;
    }

    private V putValueForNullKey(V value) {
        HashMapEntry<K, V> entry = this.entryForNullKey;
        if (entry == null) {
            this.addNewEntryForNullKey(value);
            ++this.size;
            ++this.modCount;
            return null;
        }
        this.preModify(entry);
        Object oldValue = entry.value;
        entry.value = value;
        return oldValue;
    }

    void preModify(HashMapEntry<K, V> e) {
    }

    private void constructorPut(K key, V value) {
        HashMapEntry<K, V> first;
        if (key == null) {
            HashMapEntry<K, V> entry = this.entryForNullKey;
            if (entry == null) {
                this.entryForNullKey = this.constructorNewEntry(null, value, 0, null);
                ++this.size;
            } else {
                entry.value = value;
            }
            return;
        }
        int hash = HashMap.secondaryHash(key);
        HashMapEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashMapEntry<K, V> e = first = tab[index];
        while (e != null) {
            if (e.hash == hash && key.equals(e.key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        tab[index] = this.constructorNewEntry(key, value, hash, first);
        ++this.size;
    }

    void addNewEntry(K key, V value, int hash, int index) {
        this.table[index] = new HashMapEntry<K, V>(key, value, hash, this.table[index]);
    }

    void addNewEntryForNullKey(V value) {
        this.entryForNullKey = new HashMapEntry<Object, V>(null, value, 0, null);
    }

    HashMapEntry<K, V> constructorNewEntry(K key, V value, int hash, HashMapEntry<K, V> first) {
        return new HashMapEntry<K, V>(key, value, hash, first);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.ensureCapacity(map.size());
        super.putAll(map);
    }

    private void ensureCapacity(int numMappings) {
        HashMapEntry<K, V>[] oldTable;
        int oldCapacity;
        int newCapacity = Collections.roundUpToPowerOfTwo(HashMap.capacityForInitSize(numMappings));
        if (newCapacity <= (oldCapacity = (oldTable = this.table).length)) {
            return;
        }
        if (newCapacity == oldCapacity * 2) {
            this.doubleCapacity();
            return;
        }
        HashMapEntry<K, V>[] newTable = this.makeTable(newCapacity);
        if (this.size != 0) {
            int newMask = newCapacity - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                HashMapEntry<K, V> e = oldTable[i];
                while (e != null) {
                    HashMapEntry oldNext = e.next;
                    int newIndex = e.hash & newMask;
                    HashMapEntry<K, V> newNext = newTable[newIndex];
                    newTable[newIndex] = e;
                    e.next = newNext;
                    e = oldNext;
                }
            }
        }
    }

    private HashMapEntry<K, V>[] makeTable(int newCapacity) {
        HashMapEntry[] newTable = new HashMapEntry[newCapacity];
        this.table = newTable;
        this.threshold = (newCapacity >> 1) + (newCapacity >> 2);
        return newTable;
    }

    private HashMapEntry<K, V>[] doubleCapacity() {
        HashMapEntry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity * 2;
        HashMapEntry<K, V>[] newTable = this.makeTable(newCapacity);
        if (this.size == 0) {
            return newTable;
        }
        for (int j = 0; j < oldCapacity; ++j) {
            HashMapEntry<K, V> e = oldTable[j];
            if (e == null) continue;
            int highBit = e.hash & oldCapacity;
            HashMapEntry<K, V> broken = null;
            newTable[j | highBit] = e;
            HashMapEntry n = e.next;
            while (n != null) {
                int nextHighBit = n.hash & oldCapacity;
                if (nextHighBit != highBit) {
                    if (broken == null) {
                        newTable[j | nextHighBit] = n;
                    } else {
                        broken.next = n;
                    }
                    broken = e;
                    highBit = nextHighBit;
                }
                e = n;
                n = n.next;
            }
            if (broken == null) continue;
            broken.next = null;
        }
        return newTable;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return this.removeNullKey();
        }
        int hash = HashMap.secondaryHash(key);
        HashMapEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashMapEntry<K, V> e = tab[index];
        HashMapEntry<K, V> prev = null;
        while (e != null) {
            if (e.hash == hash && key.equals(e.key)) {
                if (prev == null) {
                    tab[index] = e.next;
                } else {
                    prev.next = e.next;
                }
                ++this.modCount;
                --this.size;
                this.postRemove(e);
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    private V removeNullKey() {
        HashMapEntry<K, V> e = this.entryForNullKey;
        if (e == null) {
            return null;
        }
        this.entryForNullKey = null;
        ++this.modCount;
        --this.size;
        this.postRemove(e);
        return e.value;
    }

    void postRemove(HashMapEntry<K, V> e) {
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            Arrays.fill(this.table, null);
            this.entryForNullKey = null;
            ++this.modCount;
            this.size = 0;
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private boolean containsMapping(Object key, Object value) {
        if (key == null) {
            HashMapEntry<K, V> e = this.entryForNullKey;
            return e != null && Objects.equal(value, e.value);
        }
        int hash = HashMap.secondaryHash(key);
        HashMapEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashMapEntry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && key.equals(e.key)) {
                return Objects.equal(value, e.value);
            }
            e = e.next;
        }
        return false;
    }

    private boolean removeMapping(Object key, Object value) {
        if (key == null) {
            HashMapEntry<K, V> e = this.entryForNullKey;
            if (e == null || !Objects.equal(value, e.value)) {
                return false;
            }
            this.entryForNullKey = null;
            ++this.modCount;
            --this.size;
            this.postRemove(e);
            return true;
        }
        int hash = HashMap.secondaryHash(key);
        HashMapEntry<K, V>[] tab = this.table;
        int index = hash & tab.length - 1;
        HashMapEntry<K, V> e = tab[index];
        HashMapEntry<K, V> prev = null;
        while (e != null) {
            if (e.hash == hash && key.equals(e.key)) {
                if (!Objects.equal(value, e.value)) {
                    return false;
                }
                if (prev == null) {
                    tab[index] = e.next;
                } else {
                    prev.next = e.next;
                }
                ++this.modCount;
                --this.size;
                this.postRemove(e);
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("loadFactor", 0.75f);
        stream.writeFields();
        stream.writeInt(this.table.length);
        stream.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            stream.writeObject(e.getKey());
            stream.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int capacity = stream.readInt();
        if (capacity < 0) {
            throw new InvalidObjectException("Capacity: " + capacity);
        }
        capacity = capacity < 4 ? 4 : (capacity > 0x40000000 ? 0x40000000 : Collections.roundUpToPowerOfTwo(capacity));
        this.makeTable(capacity);
        int size = stream.readInt();
        if (size < 0) {
            throw new InvalidObjectException("Size: " + size);
        }
        this.init();
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object val = stream.readObject();
            this.constructorPut(key, val);
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return HashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return HashMap.this.containsMapping(e.getKey(), e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return HashMap.this.removeMapping(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return HashMap.this.size == 0;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return HashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return HashMap.this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            return HashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return HashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return HashMap.this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            return HashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = HashMap.this.size;
            HashMap.this.remove(o);
            return HashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    private abstract class HashIterator {
        int nextIndex;
        HashMapEntry<K, V> nextEntry;
        HashMapEntry<K, V> lastEntryReturned;
        int expectedModCount;

        HashIterator() {
            this.nextEntry = HashMap.this.entryForNullKey;
            this.expectedModCount = HashMap.this.modCount;
            if (this.nextEntry == null) {
                HashMapEntry<K, V>[] tab = HashMap.this.table;
                HashMapEntry next = null;
                while (next == null && this.nextIndex < tab.length) {
                    next = tab[this.nextIndex++];
                }
                this.nextEntry = next;
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashMapEntry<K, V> nextEntry() {
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            HashMapEntry entryToReturn = this.nextEntry;
            HashMapEntry<K, V>[] tab = HashMap.this.table;
            HashMapEntry next = entryToReturn.next;
            while (next == null && this.nextIndex < tab.length) {
                next = tab[this.nextIndex++];
            }
            this.nextEntry = next;
            this.lastEntryReturned = entryToReturn;
            return this.lastEntryReturned;
        }

        public void remove() {
            if (this.lastEntryReturned == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            HashMap.this.remove(this.lastEntryReturned.key);
            this.lastEntryReturned = null;
            this.expectedModCount = HashMap.this.modCount;
        }
    }

    static class HashMapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        final int hash;
        HashMapEntry<K, V> next;

        HashMapEntry(K key, V value, int hash, HashMapEntry<K, V> next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equal(e.getKey(), this.key) && Objects.equal(e.getValue(), this.value);
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

