/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IntConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.arraycheck.IntValueContainer;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.util.Chain;

public class ClassFieldAnalysis {
    private final boolean final_in = true;
    private final boolean private_in = true;
    private final Map<SootClass, Hashtable<SootField, IntValueContainer>> classToFieldInfoMap = new HashMap<SootClass, Hashtable<SootField, IntValueContainer>>();

    public ClassFieldAnalysis(Singletons.Global g) {
    }

    public static ClassFieldAnalysis v() {
        return G.v().soot_jimple_toolkits_annotation_arraycheck_ClassFieldAnalysis();
    }

    protected void internalTransform(SootClass c) {
        if (this.classToFieldInfoMap.containsKey(c)) {
            return;
        }
        Date start = new Date();
        if (Options.v().verbose()) {
            G.v().out.println("[] ClassFieldAnalysis started on : " + start + " for " + c.getPackageName() + c.getName());
        }
        Hashtable<SootField, IntValueContainer> fieldInfoTable = new Hashtable<SootField, IntValueContainer>();
        this.classToFieldInfoMap.put(c, fieldInfoTable);
        HashSet<SootField> candidSet = new HashSet<SootField>();
        int arrayTypeFieldNum = 0;
        for (SootField field : c.getFields()) {
            int modifiers = field.getModifiers();
            Type type = field.getType();
            if (!(type instanceof ArrayType) || (modifiers & 0x10) == 0 && (modifiers & 2) == 0) continue;
            candidSet.add(field);
            ++arrayTypeFieldNum;
        }
        if (arrayTypeFieldNum == 0) {
            if (Options.v().verbose()) {
                G.v().out.println("[] ClassFieldAnalysis finished with nothing");
            }
            return;
        }
        Iterator<SootMethod> methodIt = c.methodIterator();
        while (methodIt.hasNext()) {
            this.ScanMethod(methodIt.next(), candidSet, fieldInfoTable);
        }
        Date finish = new Date();
        if (Options.v().verbose()) {
            long runtime = finish.getTime() - start.getTime();
            long mins = runtime / 60000L;
            long secs = runtime % 60000L / 1000L;
            G.v().out.println("[] ClassFieldAnalysis finished normally. It took " + mins + " mins and " + secs + " secs.");
        }
    }

    public Object getFieldInfo(SootField field) {
        SootClass c = field.getDeclaringClass();
        Hashtable<SootField, IntValueContainer> fieldInfoTable = this.classToFieldInfoMap.get(c);
        if (fieldInfoTable == null) {
            this.internalTransform(c);
            fieldInfoTable = this.classToFieldInfoMap.get(c);
        }
        return fieldInfoTable.get(field);
    }

    public void ScanMethod(SootMethod method, Set<SootField> candidates, Hashtable<SootField, IntValueContainer> fieldinfo) {
        if (!method.isConcrete()) {
            return;
        }
        Body body = method.retrieveActiveBody();
        if (body == null) {
            return;
        }
        boolean hasArrayLocal = false;
        Chain<Local> locals = body.getLocals();
        for (Local local : locals) {
            Type type = local.getType();
            if (!(type instanceof ArrayType)) continue;
            hasArrayLocal = true;
            break;
        }
        if (!hasArrayLocal) {
            return;
        }
        HashMap<Stmt, SootField> stmtfield = new HashMap<Stmt, SootField>();
        for (Stmt stmt : body.getUnits()) {
            FieldRef fref;
            SootField field;
            Value leftOp;
            if (!stmt.containsFieldRef() || !((leftOp = ((AssignStmt)stmt).getLeftOp()) instanceof FieldRef) || !candidates.contains(field = (fref = (FieldRef)leftOp).getField())) continue;
            stmtfield.put(stmt, field);
        }
        if (stmtfield.size() == 0) {
            return;
        }
        if (Options.v().verbose()) {
            G.v().out.println("[] ScanMethod for field started.");
        }
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(body);
        SmartLocalDefs smartLocalDefs = new SmartLocalDefs(g, new SimpleLiveLocals(g));
        Set entries = stmtfield.entrySet();
        for (Map.Entry entry : entries) {
            Stmt where = (Stmt)entry.getKey();
            SootField which = (SootField)entry.getValue();
            IntValueContainer length = new IntValueContainer();
            Value rightOp = ((AssignStmt)where).getRightOp();
            if (!(rightOp instanceof Local)) continue;
            Local local = (Local)rightOp;
            DefinitionStmt usestmt = (DefinitionStmt)where;
            while (length.isBottom()) {
                List<Unit> defs = smartLocalDefs.getDefsOfAt(local, usestmt);
                if (defs.size() == 1) {
                    Value tmp_rhs;
                    usestmt = (DefinitionStmt)defs.get(0);
                    if (Options.v().debug()) {
                        G.v().out.println("        " + usestmt);
                    }
                    if ((tmp_rhs = usestmt.getRightOp()) instanceof NewArrayExpr || tmp_rhs instanceof NewMultiArrayExpr) {
                        Value size = tmp_rhs instanceof NewArrayExpr ? ((NewArrayExpr)tmp_rhs).getSize() : ((NewMultiArrayExpr)tmp_rhs).getSize(0);
                        if (size instanceof IntConstant) {
                            length.setValue(((IntConstant)size).value);
                            continue;
                        }
                        if (size instanceof Local) {
                            local = (Local)size;
                            continue;
                        }
                        length.setTop();
                        continue;
                    }
                    if (tmp_rhs instanceof IntConstant) {
                        length.setValue(((IntConstant)tmp_rhs).value);
                        continue;
                    }
                    if (tmp_rhs instanceof Local) {
                        local = (Local)tmp_rhs;
                        continue;
                    }
                    length.setTop();
                    continue;
                }
                length.setTop();
            }
            IntValueContainer oldv = fieldinfo.get(which);
            if (length.isTop()) {
                if (oldv == null) {
                    fieldinfo.put(which, length.dup());
                } else {
                    oldv.setTop();
                }
                candidates.remove(which);
                continue;
            }
            if (!length.isInteger()) continue;
            if (oldv == null) {
                fieldinfo.put(which, length.dup());
                continue;
            }
            if (!oldv.isInteger() || oldv.getValue() == length.getValue()) continue;
            oldv.setTop();
            candidates.remove(which);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[] ScanMethod finished.");
        }
    }
}

