/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Unit;
import soot.toolkits.graph.UnitGraph;

public abstract class UnitMap
implements Map {
    private Hashtable<Object, Object> unitToResult;

    public UnitMap(Body b) {
        this.unitToResult = new Hashtable();
        this.map(b);
    }

    public UnitMap(UnitGraph g) {
        this(g.getBody());
    }

    public UnitMap(Body b, int initialCapacity) {
        this.unitToResult = new Hashtable(initialCapacity);
        this.map(b);
    }

    public UnitMap(UnitGraph g, int initialCapacity) {
        this(g.getBody(), initialCapacity);
    }

    public UnitMap(Body b, int initialCapacity, float loadFactor) {
        this.unitToResult = new Hashtable(initialCapacity);
        this.init();
        this.map(b);
    }

    public UnitMap(UnitGraph g, int initialCapacity, float loadFactor) {
        this(g.getBody(), initialCapacity);
    }

    private void map(Body b) {
        for (Unit currentUnit : b.getUnits()) {
            Object o = this.mapTo(currentUnit);
            if (o == null) continue;
            this.unitToResult.put(currentUnit, o);
        }
    }

    protected void init() {
    }

    protected abstract Object mapTo(Unit var1);

    @Override
    public void clear() {
        this.unitToResult.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.unitToResult.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.unitToResult.containsValue(value);
    }

    public Set entrySet() {
        return this.unitToResult.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.unitToResult.equals(o);
    }

    public Object get(Object key) {
        return this.unitToResult.get(key);
    }

    @Override
    public int hashCode() {
        return this.unitToResult.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.unitToResult.isEmpty();
    }

    public Set<Object> keySet() {
        return this.unitToResult.keySet();
    }

    public Object put(Object key, Object value) {
        return this.unitToResult.put(key, value);
    }

    public void putAll(Map t) {
        this.unitToResult.putAll(t);
    }

    public Object remove(Object key) {
        return this.unitToResult.remove(key);
    }

    @Override
    public int size() {
        return this.unitToResult.size();
    }

    public Collection<Object> values() {
        return this.unitToResult.values();
    }
}

