/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import soot.ClassProvider;
import soot.ClassSource;
import soot.CoffiClassSource;
import soot.SourceLocator;

public class CoffiJava9ClassProvider
implements ClassProvider {
    @Override
    public ClassSource find(String cls) {
        String clsFile = cls.replace('.', '/') + ".class";
        SourceLocator.FoundFile file = null;
        Path p = Paths.get(URI.create("jrt:/modules"));
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
            for (Path entry : stream) {
                file = SourceLocator.v().lookUpInVirtualFileSystem(entry.toUri().toString(), clsFile);
                if (file == null) continue;
                break;
            }
        }
        catch (FileSystemNotFoundException ex) {
            System.out.println("Could not read my modules (perhaps not Java 9?).");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file == null ? null : new CoffiClassSource(cls, file.inputStream());
    }
}

