/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.BodyPack;
import soot.G;
import soot.HasPhaseOptions;
import soot.JimpleBodyPack;
import soot.Pack;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.coffi.CFG;
import soot.jimple.JimpleBody;
import soot.jimple.toolkits.annotation.AvailExprTagger;
import soot.jimple.toolkits.annotation.DominatorsTagger;
import soot.jimple.toolkits.annotation.LineNumberAdder;
import soot.jimple.toolkits.annotation.arraycheck.ArrayBoundsChecker;
import soot.jimple.toolkits.annotation.callgraph.CallGraphTagger;
import soot.jimple.toolkits.annotation.defs.ReachingDefsTagger;
import soot.jimple.toolkits.annotation.liveness.LiveVarsTagger;
import soot.jimple.toolkits.annotation.logic.LoopInvariantFinder;
import soot.jimple.toolkits.annotation.nullcheck.NullCheckEliminator;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerChecker;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerColorer;
import soot.jimple.toolkits.annotation.parity.ParityTagger;
import soot.jimple.toolkits.annotation.profiling.ProfilingGenerator;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.callgraph.UnreachableMethodTransformer;
import soot.jimple.toolkits.pointer.CastCheckEliminatorDumper;
import soot.jimple.toolkits.pointer.ParameterAliasTagger;
import soot.jimple.toolkits.pointer.SideEffectTagger;
import soot.jimple.toolkits.scalar.CommonSubexpressionEliminator;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.jimple.toolkits.scalar.pre.BusyCodeMotion;
import soot.jimple.toolkits.scalar.pre.LazyCodeMotion;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;
import soot.tagkit.InnerClassTagAggregator;
import soot.toolkits.exceptions.TrapTightener;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.LocalPacker;
import soot.toolkits.scalar.LocalSplitter;
import soot.toolkits.scalar.RoboVmLocalPacker;
import soot.toolkits.scalar.UnusedLocalEliminator;

public class PackManager {
    public static boolean DEBUG = false;
    private boolean onlyStandardPacks = false;
    private final Map<String, Pack> packNameToPack = new HashMap<String, Pack>();
    private final List<Pack> packList = new LinkedList<Pack>();

    public PackManager(Singletons.Global g) {
        PhaseOptions.v().setPackManager(this);
        this.init();
    }

    public boolean onlyStandardPacks() {
        return this.onlyStandardPacks;
    }

    void notifyAddPack() {
        this.onlyStandardPacks = false;
    }

    private void init() {
        BodyPack p = new JimpleBodyPack();
        this.addPack(p);
        p.add(new Transform("jb.tt", TrapTightener.v()));
        p.add(new Transform("jb.ls", LocalSplitter.v()));
        p.add(new Transform("jb.a", Aggregator.v()));
        p.add(new Transform("jb.ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jb.tr", TypeAssigner.v()));
        p.add(new Transform("jb.robovm.lp", RoboVmLocalPacker.v()));
        p.add(new Transform("jb.ulp", LocalPacker.v()));
        p.add(new Transform("jb.lns", LocalNameStandardizer.v()));
        p.add(new Transform("jb.cp", CopyPropagator.v()));
        p.add(new Transform("jb.dae", DeadAssignmentEliminator.v()));
        p.add(new Transform("jb.cp-ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jb.lp", LocalPacker.v()));
        p.add(new Transform("jb.ne", NopEliminator.v()));
        p.add(new Transform("jb.uce", UnreachableCodeEliminator.v()));
        p = new BodyPack("jtp");
        this.addPack(p);
        p = new BodyPack("jop");
        this.addPack(p);
        p.add(new Transform("jop.cse", CommonSubexpressionEliminator.v()));
        p.add(new Transform("jop.bcm", BusyCodeMotion.v()));
        p.add(new Transform("jop.lcm", LazyCodeMotion.v()));
        p.add(new Transform("jop.cp", CopyPropagator.v()));
        p.add(new Transform("jop.cpf", ConstantPropagatorAndFolder.v()));
        p.add(new Transform("jop.cbf", ConditionalBranchFolder.v()));
        p.add(new Transform("jop.dae", DeadAssignmentEliminator.v()));
        p.add(new Transform("jop.nce", new NullCheckEliminator()));
        p.add(new Transform("jop.uce1", UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf1", UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.uce2", UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf2", UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.ule", UnusedLocalEliminator.v()));
        p = new BodyPack("jap");
        this.addPack(p);
        p.add(new Transform("jap.npc", NullPointerChecker.v()));
        p.add(new Transform("jap.npcolorer", NullPointerColorer.v()));
        p.add(new Transform("jap.abc", ArrayBoundsChecker.v()));
        p.add(new Transform("jap.profiling", ProfilingGenerator.v()));
        p.add(new Transform("jap.sea", SideEffectTagger.v()));
        p.add(new Transform("jap.cgtagger", CallGraphTagger.v()));
        p.add(new Transform("jap.parity", ParityTagger.v()));
        p.add(new Transform("jap.pat", ParameterAliasTagger.v()));
        p.add(new Transform("jap.rdtagger", ReachingDefsTagger.v()));
        p.add(new Transform("jap.lvtagger", LiveVarsTagger.v()));
        p.add(new Transform("jap.che", CastCheckEliminatorDumper.v()));
        p.add(new Transform("jap.umt", new UnreachableMethodTransformer()));
        p.add(new Transform("jap.lit", LoopInvariantFinder.v()));
        p.add(new Transform("jap.aet", AvailExprTagger.v()));
        p.add(new Transform("jap.dmt", DominatorsTagger.v()));
        this.onlyStandardPacks = true;
    }

    public static PackManager v() {
        return G.v().soot_PackManager();
    }

    private void addPack(Pack p) {
        if (this.packNameToPack.containsKey(p.getPhaseName())) {
            throw new RuntimeException("Duplicate pack " + p.getPhaseName());
        }
        this.packNameToPack.put(p.getPhaseName(), p);
        this.packList.add(p);
    }

    public boolean hasPack(String phaseName) {
        return this.getPhase(phaseName) != null;
    }

    public Pack getPack(String phaseName) {
        Pack p = this.packNameToPack.get(phaseName);
        return p;
    }

    public boolean hasPhase(String phaseName) {
        return this.getPhase(phaseName) != null;
    }

    public HasPhaseOptions getPhase(String phaseName) {
        int index = phaseName.indexOf(".");
        if (index < 0) {
            return this.getPack(phaseName);
        }
        String packName = phaseName.substring(0, index);
        if (!this.hasPack(packName)) {
            return null;
        }
        return this.getPack(packName).get(phaseName);
    }

    public Transform getTransform(String phaseName) {
        return (Transform)this.getPhase(phaseName);
    }

    public Collection<Pack> allPacks() {
        return Collections.unmodifiableList(this.packList);
    }

    public void runPacks() {
        if (Options.v().src_prec() == 1 && Options.v().keep_line_number()) {
            LineNumberAdder lineNumAdder = LineNumberAdder.v();
            lineNumAdder.internalTransform("", null);
        }
        this.retrieveAllBodies();
        if (Options.v().interactive_mode()) {
            if (InteractionHandler.v().getInteractionListener() == null) {
                G.v().out.println("Cannot run in interactive mode. No listeners available. Continuing in regular mode.");
                Options.v().set_interactive_mode(false);
            } else {
                G.v().out.println("Running in interactive mode.");
            }
        }
        this.runBodyPacks();
        this.handleInnerClasses();
    }

    public void coffiMetrics() {
        int tV = 0;
        int tE = 0;
        int hM = 0;
        double aM = 0.0;
        HashMap<SootMethod, int[]> hashVem = CFG.methodsToVEM;
        Iterator<SootMethod> it = hashVem.keySet().iterator();
        while (it.hasNext()) {
            int[] vem = hashVem.get(it.next());
            tV += vem[0];
            tE += vem[1];
            aM += (double)vem[2];
            if (vem[2] <= hM) continue;
            hM = vem[2];
        }
        if (hashVem.size() > 0) {
            aM /= (double)hashVem.size();
        }
        G.v().out.println("Vertices, Edges, Avg Degree, Highest Deg:    " + tV + "  " + tE + "  " + aM + "  " + hM);
    }

    public void runBodyPacks() {
        this.runBodyPacks(this.reachableClasses());
    }

    private void runBodyPacks(Iterator classes) {
        while (classes.hasNext()) {
            SootClass cl = (SootClass)classes.next();
            this.runBodyPacks(cl);
        }
    }

    private void handleInnerClasses() {
        InnerClassTagAggregator agg = InnerClassTagAggregator.v();
        agg.internalTransform("", null);
    }

    private void releaseBodies(Iterator classes) {
        while (classes.hasNext()) {
            SootClass cl = (SootClass)classes.next();
            this.releaseBodies(cl);
        }
    }

    private Iterator reachableClasses() {
        return Scene.v().getApplicationClasses().iterator();
    }

    private void runBodyPacks(SootClass c) {
        boolean produceJimple = true;
        LinkedList<SootMethod> methodsCopy = new LinkedList<SootMethod>(c.getMethods());
        for (SootMethod m : methodsCopy) {
            if (DEBUG && m.getExceptions().size() != 0) {
                System.out.println("PackManager printing out jimple body exceptions for method " + m.toString() + " " + m.getExceptions().toString());
            }
            if (!m.isConcrete() || !produceJimple) continue;
            JimpleBody body = (JimpleBody)m.retrieveActiveBody();
            PackManager.v().getPack("jtp").apply(body);
            if (Options.v().validate()) {
                body.validate();
            }
            PackManager.v().getPack("jop").apply(body);
            PackManager.v().getPack("jap").apply(body);
        }
    }

    private void releaseBodies(SootClass cl) {
        Iterator<SootMethod> methodIt = cl.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod m = methodIt.next();
            if (!m.hasActiveBody()) continue;
            m.releaseActiveBody();
        }
    }

    private void retrieveAllBodies() {
        Iterator clIt = this.reachableClasses();
        while (clIt.hasNext()) {
            SootClass cl = (SootClass)clIt.next();
            Iterator<SootMethod> methodIt = cl.methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m = methodIt.next();
                if (DEBUG && cl.isApplicationClass()) {
                    if (m.getExceptions().size() != 0) {
                        System.out.println("PackManager printing out from within retrieveAllBodies exceptions for method " + m.toString() + " " + m.getExceptions().toString());
                    } else {
                        System.out.println("in retrieveAllBodies......Currently Method " + m.toString() + " has no exceptions ");
                    }
                }
                if (!m.isConcrete()) continue;
                m.retrieveActiveBody();
            }
        }
    }
}

