/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.PrecedenceTest;
import soot.jimple.CastExpr;
import soot.jimple.ExprSwitch;
import soot.jimple.Jimple;
import soot.util.Switch;

public abstract class AbstractCastExpr
implements CastExpr {
    ValueBox opBox;
    Type type;

    AbstractCastExpr(Value op, Type type) {
        this(Jimple.v().newImmediateBox(op), type);
    }

    @Override
    public abstract Object clone();

    protected AbstractCastExpr(ValueBox opBox, Type type) {
        this.opBox = opBox;
        this.type = type;
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractCastExpr) {
            AbstractCastExpr ace = (AbstractCastExpr)o;
            return this.opBox.getValue().equivTo(ace.opBox.getValue()) && this.type.equals(ace.type);
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.opBox.getValue().equivHashCode() * 101 + this.type.hashCode() + 17;
    }

    public String toString() {
        return "(" + this.type.toString() + ") " + this.opBox.getValue().toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("(");
        up.type(this.type);
        up.literal(") ");
        if (PrecedenceTest.needsBrackets(this.opBox, this)) {
            up.literal("(");
        }
        this.opBox.toString(up);
        if (PrecedenceTest.needsBrackets(this.opBox, this)) {
            up.literal(")");
        }
    }

    @Override
    public Value getOp() {
        return this.opBox.getValue();
    }

    @Override
    public void setOp(Value op) {
        this.opBox.setValue(op);
    }

    @Override
    public ValueBox getOpBox() {
        return this.opBox;
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        list.addAll(this.opBox.getValue().getUseBoxes());
        list.add(this.opBox);
        return list;
    }

    @Override
    public Type getCastType() {
        return this.type;
    }

    @Override
    public void setCastType(Type castType) {
        this.type = castType;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseCastExpr(this);
    }
}

