/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.parity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AddExpr;
import soot.jimple.ArithmeticConstant;
import soot.jimple.BinopExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.MulExpr;
import soot.jimple.Stmt;
import soot.jimple.SubExpr;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.LiveLocals;
import soot.util.Chain;

public class ParityAnalysis
extends ForwardFlowAnalysis {
    private UnitGraph g;
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private static final String EVEN = "even";
    private static final String ODD = "odd";
    private LiveLocals filter;

    public ParityAnalysis(UnitGraph g, LiveLocals filter) {
        super(g);
        this.g = g;
        this.filter = filter;
        this.filterUnitToBeforeFlow = new HashMap();
        this.buildBeforeFilterMap();
        this.filterUnitToAfterFlow = new HashMap();
        this.doAnalysis();
    }

    public ParityAnalysis(UnitGraph g) {
        super(g);
        this.g = g;
        this.doAnalysis();
    }

    private void buildBeforeFilterMap() {
        for (Stmt stmt : this.g.getBody().getUnits()) {
            List list = this.filter.getLiveLocalsBefore(stmt);
            HashMap map = new HashMap();
            Iterator listIt = list.iterator();
            while (listIt.hasNext()) {
                map.put(listIt.next(), BOTTOM);
            }
            this.filterUnitToBeforeFlow.put(stmt, map);
        }
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        HashMap inMap1 = (HashMap)in1;
        HashMap inMap2 = (HashMap)in2;
        HashMap outMap = (HashMap)out;
        Set keys = inMap1.keySet();
        for (Object var1 : keys) {
            String inVal1 = (String)inMap1.get(var1);
            String inVal2 = (String)inMap2.get(var1);
            if (inVal2 == null) {
                outMap.put(var1, inVal1);
                continue;
            }
            if (inVal1.equals(BOTTOM)) {
                outMap.put(var1, inVal2);
                continue;
            }
            if (inVal2.equals(BOTTOM)) {
                outMap.put(var1, inVal1);
                continue;
            }
            if (inVal1.equals(EVEN) && inVal2.equals(EVEN)) {
                outMap.put(var1, EVEN);
                continue;
            }
            if (inVal1.equals(ODD) && inVal2.equals(ODD)) {
                outMap.put(var1, ODD);
                continue;
            }
            outMap.put(var1, TOP);
        }
    }

    @Override
    protected void copy(Object source, Object dest) {
        HashMap sourceIn = (HashMap)source;
        HashMap destOut = (HashMap)dest;
        destOut.putAll(sourceIn);
        dest = destOut;
    }

    private String getParity(HashMap<Value, String> in, Value val) {
        if (val instanceof AddExpr | val instanceof SubExpr) {
            String resVal1 = this.getParity(in, ((BinopExpr)val).getOp1());
            String resVal2 = this.getParity(in, ((BinopExpr)val).getOp2());
            if (resVal1.equals(TOP) | resVal2.equals(TOP)) {
                return TOP;
            }
            if (resVal1.equals(BOTTOM) | resVal2.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (resVal1.equals(resVal2)) {
                return EVEN;
            }
            return ODD;
        }
        if (val instanceof MulExpr) {
            String resVal1 = this.getParity(in, ((BinopExpr)val).getOp1());
            String resVal2 = this.getParity(in, ((BinopExpr)val).getOp2());
            if (resVal1.equals(TOP) | resVal2.equals(TOP)) {
                return TOP;
            }
            if (resVal1.equals(BOTTOM) | resVal2.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (resVal1.equals(ODD) && resVal2.equals(ODD)) {
                return ODD;
            }
            return EVEN;
        }
        if (val instanceof IntConstant) {
            int value = ((IntConstant)val).value;
            if (value % 2 == 0) {
                return EVEN;
            }
            return ODD;
        }
        if (val instanceof LongConstant) {
            long value = ((LongConstant)val).value;
            if (value % 2L == 0L) {
                return EVEN;
            }
            return ODD;
        }
        if (in.containsKey(val)) {
            return in.get(val);
        }
        return TOP;
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        Value left;
        HashMap in = (HashMap)inValue;
        HashMap out = (HashMap)outValue;
        Stmt s = (Stmt)unit;
        out.putAll(in);
        if (s instanceof DefinitionStmt && (left = ((DefinitionStmt)s).getLeftOp()) instanceof Local && (left.getType() instanceof IntegerType || left.getType() instanceof LongType)) {
            Value right = ((DefinitionStmt)s).getRightOp();
            out.put(left, this.getParity(out, right));
        }
        for (Object next : s.getUseAndDefBoxes()) {
            Value val = ((ValueBox)next).getValue();
            if (!(val instanceof ArithmeticConstant)) continue;
            out.put(val, this.getParity(out, val));
        }
        if (Options.v().interactive_mode()) {
            this.buildAfterFilterMap(s);
            this.updateAfterFilterMap(s);
        }
    }

    private void buildAfterFilterMap(Stmt s) {
        List list = this.filter.getLiveLocalsAfter(s);
        HashMap map = new HashMap();
        Iterator listIt = list.iterator();
        while (listIt.hasNext()) {
            map.put(listIt.next(), BOTTOM);
        }
        this.filterUnitToAfterFlow.put(s, map);
    }

    @Override
    protected Object entryInitialFlow() {
        return this.newInitialFlow();
    }

    private void updateBeforeFilterMap() {
        for (Stmt s : this.filterUnitToBeforeFlow.keySet()) {
            HashMap allData = (HashMap)this.unitToBeforeFlow.get(s);
            HashMap filterData = (HashMap)this.filterUnitToBeforeFlow.get(s);
            this.filterUnitToBeforeFlow.put(s, this.updateFilter(allData, filterData));
        }
    }

    private void updateAfterFilterMap(Stmt s) {
        HashMap allData = (HashMap)this.unitToAfterFlow.get(s);
        HashMap filterData = (HashMap)this.filterUnitToAfterFlow.get(s);
        this.filterUnitToAfterFlow.put(s, this.updateFilter(allData, filterData));
    }

    private HashMap updateFilter(HashMap allData, HashMap filterData) {
        if (allData == null) {
            return filterData;
        }
        Iterator filterVarsIt = filterData.keySet().iterator();
        ArrayList<Value> toRemove = new ArrayList<Value>();
        while (filterVarsIt.hasNext()) {
            Value v = (Value)filterVarsIt.next();
            if (allData.get(v) == null) {
                toRemove.add(v);
                continue;
            }
            filterData.put(v, allData.get(v));
        }
        Iterator removeIt = toRemove.iterator();
        while (removeIt.hasNext()) {
            filterData.remove(removeIt.next());
        }
        return filterData;
    }

    @Override
    protected Object newInitialFlow() {
        HashMap<Value, String> initMap = new HashMap<Value, String>();
        Chain<Local> locals = this.g.getBody().getLocals();
        for (Local next : locals) {
            if (!(next.getType() instanceof IntegerType) && !(next.getType() instanceof LongType)) continue;
            initMap.put(next, BOTTOM);
        }
        Iterator<ValueBox> boxIt = this.g.getBody().getUseAndDefBoxes().iterator();
        while (boxIt.hasNext()) {
            Value val = boxIt.next().getValue();
            if (!(val instanceof ArithmeticConstant)) continue;
            initMap.put(val, this.getParity(initMap, val));
        }
        if (Options.v().interactive_mode()) {
            this.updateBeforeFilterMap();
        }
        return initMap;
    }
}

