/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.Kind;
import soot.MethodOrMethodContext;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class CallGraph {
    protected Set<Edge> edges = new HashSet<Edge>();
    protected ChunkedQueue<Edge> stream = new ChunkedQueue();
    protected QueueReader<Edge> reader = this.stream.reader();
    protected Map<MethodOrMethodContext, Edge> srcMethodToEdge = new HashMap<MethodOrMethodContext, Edge>();
    protected Map<Unit, Edge> srcUnitToEdge = new HashMap<Unit, Edge>();
    protected Map<MethodOrMethodContext, Edge> tgtToEdge = new HashMap<MethodOrMethodContext, Edge>();
    protected Edge dummy = new Edge(null, null, null, Kind.INVALID);

    public boolean addEdge(Edge e) {
        if (!this.edges.add(e)) {
            return false;
        }
        this.stream.add(e);
        Edge position = null;
        position = this.srcUnitToEdge.get(e.srcUnit());
        if (position == null) {
            this.srcUnitToEdge.put(e.srcUnit(), e);
            position = this.dummy;
        }
        e.insertAfterByUnit(position);
        position = this.srcMethodToEdge.get(e.getSrc());
        if (position == null) {
            this.srcMethodToEdge.put(e.getSrc(), e);
            position = this.dummy;
        }
        e.insertAfterBySrc(position);
        position = this.tgtToEdge.get(e.getTgt());
        if (position == null) {
            this.tgtToEdge.put(e.getTgt(), e);
            position = this.dummy;
        }
        e.insertAfterByTgt(position);
        return true;
    }

    public boolean removeEdge(Edge e) {
        if (!this.edges.remove(e)) {
            return false;
        }
        e.remove();
        if (this.srcUnitToEdge.get(e.srcUnit()) == e) {
            if (e.nextByUnit().srcUnit() == e.srcUnit()) {
                this.srcUnitToEdge.put(e.srcUnit(), e.nextByUnit());
            } else {
                this.srcUnitToEdge.put(e.srcUnit(), null);
            }
        }
        if (this.srcMethodToEdge.get(e.getSrc()) == e) {
            if (e.nextBySrc().getSrc() == e.getSrc()) {
                this.srcMethodToEdge.put(e.getSrc(), e.nextBySrc());
            } else {
                this.srcMethodToEdge.put(e.getSrc(), null);
            }
        }
        if (this.tgtToEdge.get(e.getTgt()) == e) {
            if (e.nextByTgt().getTgt() == e.getTgt()) {
                this.tgtToEdge.put(e.getTgt(), e.nextByTgt());
            } else {
                this.tgtToEdge.put(e.getTgt(), null);
            }
        }
        return true;
    }

    public boolean isEntryMethod(SootMethod method) {
        return !this.tgtToEdge.containsKey(method);
    }

    public Edge findEdge(Unit u, SootMethod callee) {
        Edge e = this.srcUnitToEdge.get(u);
        while (e.srcUnit() == u && e.kind() != Kind.INVALID) {
            if (e.tgt() == callee) {
                return e;
            }
            e = e.nextByUnit();
        }
        return null;
    }

    public Iterator<MethodOrMethodContext> sourceMethods() {
        return this.srcMethodToEdge.keySet().iterator();
    }

    public Iterator<Edge> edgesOutOf(Unit u) {
        return new TargetsOfUnitIterator(u);
    }

    public Iterator<Edge> edgesOutOf(MethodOrMethodContext m) {
        return new TargetsOfMethodIterator(m);
    }

    public Iterator<Edge> edgesInto(MethodOrMethodContext m) {
        return new CallersOfMethodIterator(m);
    }

    public QueueReader<Edge> listener() {
        return this.reader.clone();
    }

    public QueueReader<Edge> newListener() {
        return this.stream.reader();
    }

    public String toString() {
        QueueReader<Edge> reader = this.listener();
        StringBuffer out = new StringBuffer();
        while (reader.hasNext()) {
            Edge e = reader.next();
            out.append(e.toString() + "\n");
        }
        return out.toString();
    }

    public int size() {
        return this.edges.size();
    }

    class TargetsOfUnitIterator
    implements Iterator<Edge> {
        private Edge position = null;
        private Unit u;

        TargetsOfUnitIterator(Unit u) {
            this.u = u;
            if (u == null) {
                throw new RuntimeException();
            }
            this.position = CallGraph.this.srcUnitToEdge.get(u);
            if (this.position == null) {
                this.position = CallGraph.this.dummy;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.position.srcUnit() != this.u) {
                return false;
            }
            return this.position.kind() != Kind.INVALID;
        }

        @Override
        public Edge next() {
            Edge ret = this.position;
            this.position = this.position.nextByUnit();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class TargetsOfMethodIterator
    implements Iterator<Edge> {
        private Edge position = null;
        private MethodOrMethodContext m;

        TargetsOfMethodIterator(MethodOrMethodContext m) {
            this.m = m;
            if (m == null) {
                throw new RuntimeException();
            }
            this.position = CallGraph.this.srcMethodToEdge.get(m);
            if (this.position == null) {
                this.position = CallGraph.this.dummy;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.position.getSrc() != this.m) {
                return false;
            }
            return this.position.kind() != Kind.INVALID;
        }

        @Override
        public Edge next() {
            Edge ret = this.position;
            this.position = this.position.nextBySrc();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class CallersOfMethodIterator
    implements Iterator<Edge> {
        private Edge position = null;
        private MethodOrMethodContext m;

        CallersOfMethodIterator(MethodOrMethodContext m) {
            this.m = m;
            if (m == null) {
                throw new RuntimeException();
            }
            this.position = CallGraph.this.tgtToEdge.get(m);
            if (this.position == null) {
                this.position = CallGraph.this.dummy;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.position.getTgt() != this.m) {
                return false;
            }
            return this.position.kind() != Kind.INVALID;
        }

        @Override
        public Edge next() {
            Edge ret = this.position;
            this.position = this.position.nextByTgt();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

