/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.AnySubType;
import soot.ArrayType;
import soot.FastHierarchy;
import soot.G;
import soot.NullType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.SpecialInvokeExpr;
import soot.util.LargeNumberedMap;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;
import soot.util.queue.ChunkedQueue;

public final class VirtualCalls {
    private final LargeNumberedMap typeToVtbl = new LargeNumberedMap(Scene.v().getTypeNumberer());
    private final Map<Type, List<Type>> baseToSubTypes = new HashMap<Type, List<Type>>();
    public final NumberedString sigClinit = Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()");
    public final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    public final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");

    public VirtualCalls(Singletons.Global g) {
    }

    public static VirtualCalls v() {
        return G.v().soot_jimple_toolkits_callgraph_VirtualCalls();
    }

    public SootMethod resolveSpecial(SpecialInvokeExpr iie, NumberedString subSig, SootMethod container) {
        SootMethod target = iie.getMethod();
        if (Scene.v().getOrMakeFastHierarchy().canStoreType(container.getDeclaringClass().getType(), target.getDeclaringClass().getType()) && container.getDeclaringClass().getType() != target.getDeclaringClass().getType() && !target.getName().equals("<init>") && subSig != this.sigClinit) {
            return this.resolveNonSpecial(container.getDeclaringClass().getSuperclass().getType(), subSig);
        }
        return target;
    }

    public SootMethod resolveNonSpecial(RefType t, NumberedString subSig) {
        SootMethod ret;
        SmallNumberedMap vtbl = (SmallNumberedMap)this.typeToVtbl.get(t);
        if (vtbl == null) {
            vtbl = new SmallNumberedMap(Scene.v().getMethodNumberer());
            this.typeToVtbl.put(t, vtbl);
        }
        if ((ret = (SootMethod)vtbl.get(subSig)) != null) {
            return ret;
        }
        SootClass cls = t.getSootClass();
        if (cls.declaresMethod(subSig)) {
            SootMethod m = cls.getMethod(subSig);
            if (m.isConcrete() || m.isNative() || m.isPhantom()) {
                ret = cls.getMethod(subSig);
            }
        } else if (cls.hasSuperclass()) {
            ret = this.resolveNonSpecial(cls.getSuperclass().getType(), subSig);
        }
        vtbl.put(subSig, ret);
        return ret;
    }

    public void resolve(Type t, Type declaredType, NumberedString subSig, SootMethod container, ChunkedQueue targets) {
        this.resolve(t, declaredType, null, subSig, container, targets);
    }

    public void resolve(Type t, Type declaredType, Type sigType, NumberedString subSig, SootMethod container, ChunkedQueue targets) {
        if (declaredType instanceof ArrayType) {
            declaredType = RefType.v("java.lang.Object");
        }
        if (sigType instanceof ArrayType) {
            sigType = RefType.v("java.lang.Object");
        }
        if (t instanceof ArrayType) {
            t = RefType.v("java.lang.Object");
        }
        if (declaredType != null && !Scene.v().getOrMakeFastHierarchy().canStoreType(t, declaredType)) {
            return;
        }
        if (sigType != null && !Scene.v().getOrMakeFastHierarchy().canStoreType(t, sigType)) {
            return;
        }
        if (t instanceof RefType) {
            SootMethod target = this.resolveNonSpecial((RefType)t, subSig);
            if (target != null) {
                targets.add(target);
            }
        } else if (t instanceof AnySubType) {
            RefType base = ((AnySubType)t).getBase();
            List<Type> subTypes = this.baseToSubTypes.get(base);
            if (subTypes != null) {
                for (Type st : subTypes) {
                    this.resolve(st, declaredType, sigType, subSig, container, targets);
                }
                return;
            }
            subTypes = new ArrayList<Type>();
            this.baseToSubTypes.put(base, subTypes);
            subTypes.add(base);
            LinkedList<SootClass> worklist = new LinkedList<SootClass>();
            HashSet<SootClass> workset = new HashSet<SootClass>();
            FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
            SootClass cl = base.getSootClass();
            if (workset.add(cl)) {
                worklist.add(cl);
            }
            while (!worklist.isEmpty()) {
                cl = (SootClass)worklist.removeFirst();
                if (cl.isInterface()) {
                    for (SootClass c : fh.getAllImplementersOfInterface(cl)) {
                        if (!workset.add(c)) continue;
                        worklist.add(c);
                    }
                    continue;
                }
                if (cl.isConcrete()) {
                    this.resolve(cl.getType(), declaredType, sigType, subSig, container, targets);
                    subTypes.add(cl.getType());
                }
                for (SootClass c : fh.getSubclassesOf(cl)) {
                    if (!workset.add(c)) continue;
                    worklist.add(c);
                }
            }
        } else if (!(t instanceof NullType)) {
            throw new RuntimeException("oops " + t);
        }
    }
}

