/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.EquivalentValue;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefLikeType;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.CastExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.queue.QueueReader;

public class LocalMustAliasAnalysis
extends ForwardFlowAnalysis<Unit, HashMap<Value, Object>> {
    public static final String UNKNOWN_LABEL = "UNKNOWN";
    protected static final Object UNKNOWN = new Object(){

        public String toString() {
            return LocalMustAliasAnalysis.UNKNOWN_LABEL;
        }
    };
    protected static final Object NOTHING = new Object(){

        public String toString() {
            return "NOTHING";
        }
    };
    protected Set<Value> localsAndFieldRefs;
    protected transient Map<Value, Integer> rhsToNumber;
    protected transient Map<Unit, Map<Value, Integer>> mergePointToValueToNumber;
    protected int nextNumber = 1;
    protected SootMethod container;

    public LocalMustAliasAnalysis(UnitGraph g) {
        this(g, false);
    }

    public LocalMustAliasAnalysis(UnitGraph g, boolean tryTrackFieldAssignments) {
        super(g);
        this.container = g.getBody().getMethod();
        this.localsAndFieldRefs = new HashSet<Value>();
        for (Local l : g.getBody().getLocals()) {
            if (!(l.getType() instanceof RefLikeType)) continue;
            this.localsAndFieldRefs.add(l);
        }
        if (tryTrackFieldAssignments) {
            this.localsAndFieldRefs.addAll(this.trackableFields());
        }
        this.rhsToNumber = new HashMap<Value, Integer>();
        this.mergePointToValueToNumber = new HashMap<Unit, Map<Value, Integer>>();
        this.doAnalysis();
        this.rhsToNumber = null;
        this.mergePointToValueToNumber = null;
    }

    private Set<Value> trackableFields() {
        HashSet<Value> usedFieldRefs = new HashSet<Value>();
        for (Unit unit : this.graph) {
            Stmt s = (Stmt)unit;
            List<ValueBox> useBoxes = s.getUseBoxes();
            for (ValueBox useBox : useBoxes) {
                FieldRef fieldRef;
                Value val = useBox.getValue();
                if (!(val instanceof FieldRef) || !((fieldRef = (FieldRef)val).getType() instanceof RefLikeType)) continue;
                usedFieldRefs.add(new EquivalentValue(fieldRef));
            }
        }
        if (!usedFieldRefs.isEmpty()) {
            if (!Scene.v().hasCallGraph()) {
                throw new IllegalStateException("No call graph found!");
            }
            CallGraph cg = Scene.v().getCallGraph();
            ReachableMethods reachableMethods = new ReachableMethods(cg, Collections.singletonList(this.container));
            reachableMethods.update();
            QueueReader<MethodOrMethodContext> iterator = reachableMethods.listener();
            while (iterator.hasNext()) {
                SootMethod m = (SootMethod)iterator.next();
                if (!m.hasActiveBody() || m.getName().equals("<clinit>") && m.getDeclaringClass().equals(this.container.getDeclaringClass())) continue;
                for (Unit u : m.getActiveBody().getUnits()) {
                    List<ValueBox> defBoxes = u.getDefBoxes();
                    for (ValueBox defBox : defBoxes) {
                        Value value = defBox.getValue();
                        if (!(value instanceof FieldRef)) continue;
                        usedFieldRefs.remove(new EquivalentValue(value));
                    }
                }
            }
        }
        return usedFieldRefs;
    }

    @Override
    protected void merge(Unit succUnit, HashMap<Value, Object> inMap1, HashMap<Value, Object> inMap2, HashMap<Value, Object> outMap) {
        for (Value l : this.localsAndFieldRefs) {
            Integer number;
            Object i2;
            Object i1 = inMap1.get(l);
            if (i1.equals(i2 = inMap2.get(l))) {
                outMap.put(l, i1);
                continue;
            }
            if (i1 == NOTHING) {
                outMap.put(l, i2);
                continue;
            }
            if (i2 == NOTHING) {
                outMap.put(l, i1);
                continue;
            }
            Map<Value, Integer> valueToNumber = this.mergePointToValueToNumber.get(succUnit);
            if (valueToNumber == null) {
                valueToNumber = new HashMap<Value, Integer>();
                this.mergePointToValueToNumber.put(succUnit, valueToNumber);
            }
            if ((number = valueToNumber.get(l)) == null) {
                number = this.nextNumber++;
                valueToNumber.put(l, number);
            }
            outMap.put(l, number);
        }
    }

    @Override
    protected void flowThrough(HashMap<Value, Object> in, Unit u, HashMap<Value, Object> out) {
        Stmt s = (Stmt)u;
        out.clear();
        out.putAll(in);
        if (s instanceof DefinitionStmt) {
            DefinitionStmt ds = (DefinitionStmt)s;
            Value lhs = ds.getLeftOp();
            Value rhs = ds.getRightOp();
            if (rhs instanceof CastExpr) {
                CastExpr castExpr = (CastExpr)rhs;
                rhs = castExpr.getOp();
            }
            if ((lhs instanceof Local || lhs instanceof FieldRef && this.localsAndFieldRefs.contains(new EquivalentValue(lhs))) && lhs.getType() instanceof RefLikeType) {
                if (rhs instanceof Local) {
                    out.put(lhs, in.get(rhs));
                } else if (rhs instanceof ThisRef) {
                    out.put(lhs, LocalMustAliasAnalysis.thisRefNumber());
                } else if (rhs instanceof ParameterRef) {
                    out.put(lhs, LocalMustAliasAnalysis.parameterRefNumber((ParameterRef)rhs));
                } else {
                    out.put(lhs, this.numberOfRhs(rhs));
                }
            }
        } else assert (s.getDefBoxes().isEmpty());
    }

    private Object numberOfRhs(Value rhs) {
        Integer num;
        EquivalentValue equivValue = new EquivalentValue(rhs);
        if (this.localsAndFieldRefs.contains(equivValue)) {
            rhs = equivValue;
        }
        if ((num = this.rhsToNumber.get(rhs)) == null) {
            num = this.nextNumber++;
            this.rhsToNumber.put(rhs, num);
        }
        return num;
    }

    public static int thisRefNumber() {
        return 0;
    }

    public static int parameterRefNumber(ParameterRef r) {
        return -1 - r.getIndex();
    }

    @Override
    protected void copy(HashMap<Value, Object> sourceMap, HashMap<Value, Object> destMap) {
        destMap.clear();
        destMap.putAll(sourceMap);
    }

    @Override
    protected HashMap<Value, Object> entryInitialFlow() {
        HashMap<Value, Object> m = new HashMap<Value, Object>();
        for (Value l : this.localsAndFieldRefs) {
            m.put(l, UNKNOWN);
        }
        return m;
    }

    @Override
    protected HashMap<Value, Object> newInitialFlow() {
        HashMap<Value, Object> m = new HashMap<Value, Object>();
        for (Value l : this.localsAndFieldRefs) {
            m.put(l, NOTHING);
        }
        return m;
    }

    public String instanceKeyString(Local l, Stmt s) {
        Object ln = ((HashMap)this.getFlowBefore(s)).get(l);
        if (ln == null) {
            return null;
        }
        if (ln == UNKNOWN) {
            return UNKNOWN.toString();
        }
        return ln.toString();
    }

    public boolean hasInfoOn(Local l, Stmt s) {
        HashMap flowBefore = (HashMap)this.getFlowBefore(s);
        if (flowBefore == null) {
            return false;
        }
        Object info = flowBefore.get(l);
        return info != null && info != UNKNOWN;
    }

    public boolean mustAlias(Local l1, Stmt s1, Local l2, Stmt s2) {
        Object l1n = ((HashMap)this.getFlowBefore(s1)).get(l1);
        Object l2n = ((HashMap)this.getFlowBefore(s2)).get(l2);
        if (l1n == UNKNOWN || l2n == UNKNOWN) {
            return false;
        }
        return l1n == l2n;
    }

    @Override
    protected void merge(HashMap<Value, Object> in1, HashMap<Value, Object> in2, HashMap<Value, Object> out) {
        throw new UnsupportedOperationException("not implemented; use other merge method instead");
    }
}

