/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.pointer.DependenceGraph;
import soot.jimple.toolkits.pointer.DependenceTag;
import soot.jimple.toolkits.pointer.FullRWSet;
import soot.jimple.toolkits.pointer.MemoryEfficientRasUnion;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.jimple.toolkits.pointer.Union;
import soot.jimple.toolkits.pointer.UnionFactory;

public class SideEffectTagger
extends BodyTransformer {
    public int numRWs = 0;
    public int numWRs = 0;
    public int numRRs = 0;
    public int numWWs = 0;
    public int numNatives = 0;
    public Date startTime = null;
    boolean optionNaive = false;
    private CallGraph cg;

    public SideEffectTagger(Singletons.Global g) {
    }

    public static SideEffectTagger v() {
        return G.v().soot_jimple_toolkits_pointer_SideEffectTagger();
    }

    protected void initializationStuff(String phaseName) {
        G.v().Union_factory = new UnionFactory(){

            @Override
            public Union newUnion() {
                return new MemoryEfficientRasUnion();
            }
        };
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        this.cg = Scene.v().getCallGraph();
    }

    protected Object keyFor(Stmt s) {
        if (s.containsInvokeExpr()) {
            if (this.optionNaive) {
                throw new RuntimeException("shouldn't get here");
            }
            Iterator<Edge> it = this.cg.edgesOutOf(s);
            if (!it.hasNext()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Edge> ret = new ArrayList<Edge>();
            while (it.hasNext()) {
                ret.add(it.next());
            }
            return ret;
        }
        return s;
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map options) {
        this.initializationStuff(phaseName);
        SideEffectAnalysis sea = Scene.v().getSideEffectAnalysis();
        this.optionNaive = PhaseOptions.getBoolean(options, "naive");
        if (!this.optionNaive) {
            sea.findNTRWSets(body.getMethod());
        }
        HashMap<Object, RWSet> stmtToReadSet = new HashMap<Object, RWSet>();
        HashMap<Object, RWSet> stmtToWriteSet = new HashMap<Object, RWSet>();
        UniqueRWSets sets = new UniqueRWSets();
        boolean justDoTotallyConservativeThing = body.getMethod().getName().equals("<clinit>");
        for (Stmt stmt : body.getUnits()) {
            if (justDoTotallyConservativeThing || this.optionNaive && stmt.containsInvokeExpr()) {
                stmtToReadSet.put(stmt, sets.getUnique(new FullRWSet()));
                stmtToWriteSet.put(stmt, sets.getUnique(new FullRWSet()));
                continue;
            }
            Object object = this.keyFor(stmt);
            if (stmtToReadSet.containsKey(object)) continue;
            stmtToReadSet.put(object, sets.getUnique(sea.readSet(body.getMethod(), stmt)));
            stmtToWriteSet.put(object, sets.getUnique(sea.writeSet(body.getMethod(), stmt)));
        }
        DependenceGraph graph = new DependenceGraph();
        Iterator<RWSet> iterator = sets.iterator();
        while (iterator.hasNext()) {
            RWSet inner;
            RWSet rWSet = iterator.next();
            Iterator<RWSet> innerIt = sets.iterator();
            while (innerIt.hasNext() && (inner = innerIt.next()) != rWSet) {
                if (!rWSet.hasNonEmptyIntersection(inner)) continue;
                graph.addEdge(sets.indexOf(rWSet), sets.indexOf(inner));
            }
        }
        body.getMethod().addTag(graph);
        for (Stmt stmt : body.getUnits()) {
            Object key = this.optionNaive && stmt.containsInvokeExpr() ? stmt : this.keyFor(stmt);
            RWSet read = (RWSet)stmtToReadSet.get(key);
            RWSet write = (RWSet)stmtToWriteSet.get(key);
            if (read == null && write == null) continue;
            DependenceTag tag = new DependenceTag();
            if (read != null && read.getCallsNative()) {
                tag.setCallsNative();
                ++this.numNatives;
            } else if (write != null && write.getCallsNative()) {
                tag.setCallsNative();
                ++this.numNatives;
            }
            tag.setRead(sets.indexOf(read));
            tag.setWrite(sets.indexOf(write));
            stmt.addTag(tag);
        }
    }

    protected class UniqueRWSets {
        protected ArrayList<RWSet> l = new ArrayList();

        protected UniqueRWSets() {
        }

        RWSet getUnique(RWSet s) {
            if (s == null) {
                return s;
            }
            for (RWSet ret : this.l) {
                if (!ret.isEquivTo(s)) continue;
                return ret;
            }
            this.l.add(s);
            return s;
        }

        Iterator<RWSet> iterator() {
            return this.l.iterator();
        }

        short indexOf(RWSet s) {
            short i = 0;
            for (RWSet ret : this.l) {
                if (ret.isEquivTo(s)) {
                    return i;
                }
                i = (short)(i + 1);
            }
            return -1;
        }
    }
}

