/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PatchingChain;
import soot.Singletons;
import soot.Unit;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.options.Options;

public class UnconditionalBranchFolder
extends BodyTransformer {
    static final int JUMPOPT_TYPES = 6;
    int[] numFound;
    int[] numFixed;
    HashMap<Stmt, Stmt> stmtMap;

    public UnconditionalBranchFolder(Singletons.Global g) {
    }

    public static UnconditionalBranchFolder v() {
        return G.v().soot_jimple_toolkits_scalar_UnconditionalBranchFolder();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map options) {
        StmtBody body = (StmtBody)b;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Folding unconditional branches...");
        }
        if (this.numFound == null) {
            this.numFound = new int[7];
            this.numFixed = new int[7];
        }
        for (int i = 0; i <= 6; ++i) {
            this.numFound[i] = 0;
            this.numFixed[i] = 0;
        }
        PatchingChain<Unit> units = body.getUnits();
        this.stmtMap = new HashMap();
        Iterator stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            Stmt newTarget;
            Stmt target;
            Stmt stmt = (Stmt)stmtIt.next();
            if (stmt instanceof GotoStmt) {
                target = (Stmt)((GotoStmt)stmt).getTarget();
                if (stmtIt.hasNext() && units.getSuccOf(stmt) == target) {
                    stmtIt.remove();
                    this.updateCounters(6, true);
                }
                if (target instanceof GotoStmt) {
                    newTarget = this.getFinalTarget(target);
                    if (newTarget == null) {
                        newTarget = stmt;
                    }
                    ((GotoStmt)stmt).setTarget(newTarget);
                    this.updateCounters(1, true);
                    continue;
                }
                if (!(target instanceof IfStmt)) continue;
                this.updateCounters(3, false);
                continue;
            }
            if (!(stmt instanceof IfStmt)) continue;
            target = ((IfStmt)stmt).getTarget();
            if (target instanceof GotoStmt) {
                newTarget = this.getFinalTarget(target);
                if (newTarget == null) {
                    newTarget = stmt;
                }
                ((IfStmt)stmt).setTarget(newTarget);
                this.updateCounters(2, true);
                continue;
            }
            if (!(target instanceof IfStmt)) continue;
            this.updateCounters(4, false);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     " + this.numFixed[0] + " of " + this.numFound[0] + " branches folded.");
        }
    }

    private void updateCounters(int type, boolean fixed) {
        if (type < 0 || type > 6) {
            return;
        }
        this.numFound[0] = this.numFound[0] + 1;
        int n = type;
        this.numFound[n] = this.numFound[n] + 1;
        if (fixed) {
            this.numFixed[0] = this.numFixed[0] + 1;
            int n2 = type;
            this.numFixed[n2] = this.numFixed[n2] + 1;
        }
    }

    private Stmt getFinalTarget(Stmt stmt) {
        Stmt finalTarget = null;
        if (!(stmt instanceof GotoStmt)) {
            return stmt;
        }
        this.stmtMap.put(stmt, stmt);
        Stmt target = (Stmt)((GotoStmt)stmt).getTarget();
        if (this.stmtMap.containsKey(target)) {
            finalTarget = this.stmtMap.get(target);
            if (finalTarget == target) {
                finalTarget = null;
            }
        } else {
            finalTarget = this.getFinalTarget(target);
        }
        this.stmtMap.put(stmt, finalTarget);
        return finalTarget;
    }
}

